set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9813575';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.746547,
      2.969419,
      3,
      5,
      1,
      1,
      1,
      0.692228,
      NULL,
      NULL,
      31,
      29.276459,
      '4324322',
      NULL,
      1.009635,
      0,
      2,
      '2414',
      5.480340,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      28.387343,
      NULL,
      NULL,
      NULL,
      '11-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      0.998260,
      NULL,
      NULL,
      '10- 4-1996',
      0.596744,
      0.822928,
      2.215330,
      1.391845,
      1.947345,
      1.038058,
      0,
      NULL,
      0,
      1.685239,
      4,
      7.479783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      0.765168,
      1.470879,
      0,
      NULL,
      NULL,
      0.257480,
      NULL,
      0.276257,
      0.281417,
      NULL,
      NULL,
      1,
      3.854378,
      1,
      8,
      NULL,
      0.431504,
      3,
      7.014473,
      1.400118,
      3.118891,
      NULL,
      4.591345,
      3,
      NULL,
      5.520401,
      5,
      1,
      4,
      3.305613,
      2.049542,
      1.101616,
      NULL,
      NULL,
      1.727065,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743222,
      1.575472,
      NULL,
      0.872233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881557,
      1,
      5,
      0,
      1,
      1,
      0.370232,
      1.400708,
      0.721085,
      1.910319,
      0.107893,
      1,
      1,
      1,
      0.701473,
      0.563680,
      0,
      0.877833,
      NULL,
      NULL,
      1,
      5,
      0.922816,
      0.073934,
      NULL,
      NULL,
      NULL,
      1.308951,
      2,
      0.042290,
      0,
      1.623859,
      NULL,
      3.377983,
      0.991855,
      0.333480,
      5,
      0.206918,
      1,
      1,
      4,
      7.684437,
      4,
      7.153125,
      3.130783,
      5,
      3,
      0.343464,
      NULL,
      503,
      ' 0-20-1985',
      161,
      1.282179,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713886,
      0.002816,
      0.856781,
      1.254107,
      1,
      0,
      0.677090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.258991,
      NULL,
      9.419458,
      0,
      0.459072,
      1.806198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      5.475039,
      3.220385,
      7.372817,
      1.891283,
      1.473253,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.984632,
      NULL,
      0.519146,
      1.155209,
      NULL,
      0.616406,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.215128,
      0.303502,
      0,
      2.159862,
      0,
      1.201398,
      0,
      3,
      0.068577,
      1.045308,
      0.981886,
      NULL,
      2,
      3,
      2,
      NULL,
      0,
      1.546402,
      1.276803,
      2.200428,
      1,
      0.184104,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1.663672,
      0.094453,
      0.689648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      40.806383,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      '03133',
      NULL,
      '',
      1.592619,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      23.423065,
      NULL,
      17.849446,
      0.360992,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.826036,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111764,
      0,
      3,
      3,
      0.596370,
      0.453817,
      0.782001,
      NULL,
      NULL,
      2.649440,
      NULL,
      1,
      3.302590,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.354259,
      0.988707,
      NULL,
      1,
      1.196500,
      0,
      2.490906,
      0.072502,
      0,
      2.665188,
      NULL,
      NULL,
      0.580699,
      0,
      NULL,
      NULL,
      NULL,
      0.230168,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.583765,
      0.108636,
      0,
      1,
      NULL,
      1,
      NULL,
      0.841899,
      1,
      0,
      1,
      1,
      NULL,
      3,
      0.276780,
      1,
      1.358913,
      NULL,
      NULL,
      0.418727,
      NULL,
      NULL,
      0.135859,
      NULL,
      NULL,
      6,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.576396,
      0.960896,
      2,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      6.995037,
      2,
      2,
      1.362268,
      NULL,
      NULL,
      1.650743,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.085940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884881,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.816684,
      1.887955,
      0.404569,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554731,
      NULL,
      NULL,
      NULL,
      3.093254,
      1,
      3.654521,
      2,
      1,
      3.117760,
      3,
      5,
      0,
      0.336602,
      3.970797,
      3.119704,
      2,
      2,
      2,
      0,
      3.912756,
      1.834967,
      NULL,
      2,
      9.234784,
      3,
      1.215374,
      4,
      1.396787,
      7.948145,
      2.772631,
      NULL,
      5,
      0,
      NULL,
      1,
      0,
      1.313951,
      1.610310,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150735,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.566769,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.992738,
      NULL,
      NULL,
      1.666277,
      NULL,
      NULL,
      2,
      2.408610,
      NULL,
      3.817549,
      0.592081,
      0.824875,
      1,
      1.390964,
      NULL,
      2.493978,
      NULL,
      NULL,
      NULL,
      151,
      NULL,
      NULL,
      NULL,
      3.540492,
      NULL,
      1.967111,
      NULL,
      NULL,
      NULL,
      2.689719,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.022636,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.250676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2.019045,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.628812,
      NULL,
      1.110277,
      NULL,
      1,
      NULL,
      1.773982,
      NULL,
      1.179085,
      NULL,
      NULL,
      NULL,
      14.980014,
      NULL,
      12,
      NULL,
      1,
      NULL,
      NULL,
      3.232488,
      3.871479,
      3.347548,
      0.336810,
      NULL,
      NULL,
      0,
      99,
      21.187223,
      0.175331,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.831829,
      NULL,
      NULL,
      1.535148,
      NULL,
      0,
      0.800919,
      11.832981,
      1,
      1.206167,
      NULL,
      1,
      NULL,
      1.121901,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.566091,
      NULL,
      1.379705,
      1,
      1,
      1.717648,
      2.937123,
      1,
      1.908936,
      0.772168,
      1.265171,
      1.800549,
      0.808858,
      NULL,
      1.477011,
      1.029136,
      0.912973,
      NULL,
      57,
      NULL,
      NULL,
      17.369726,
      NULL,
      2,
      0,
      NULL,
      0.879684,
      1.479978,
      0,
      0.846500,
      0.421230,
      0.119634,
      NULL,
      0.980289,
      NULL,
      1.437334,
      0.612317,
      0,
      0.431795,
      0,
      1,
      NULL,
      0.820200,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0.406730,
      NULL,
      1.012743,
      0.286539,
      NULL,
      3.013109,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371029,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.391576,
      NULL,
      0,
      NULL,
      0.612543,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.731200,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.046335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288840,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.471196,
      1,
      0.557399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295851,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931815,
      0.414716,
      0,
      0.590753,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      6.004826,
      NULL,
      6.447468,
      5,
      5.727657,
      10,
      2.823617,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.206504,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      1,
      NULL,
      1.720947,
      0,
      NULL,
      1.277514,
      NULL,
      NULL,
      3.036547,
      2.549013,
      NULL,
      NULL,
      1.920683,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1.845547,
      0.262411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029598,
      NULL,
      1.203432,
      NULL,
      0.803682,
      NULL,
      5.033589,
      9.392710,
      7.416598,
      2.925522,
      2,
      2,
      46,
      51.474221,
      3.648703,
      2.293119,
      6,
      '33313',
      '20332',
      '12013',
      1.772562,
      NULL,
      '',
      '',
      1,
      '24112',
      '',
      '');
commit;
end;
/


