set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104509';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      3.497106,
      0.799656,
      1,
      0,
      '1203',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.515657,
      NULL,
      3,
      1.246419,
      0,
      ' 9-10-1983',
      NULL,
      NULL,
      286.963052,
      119.134238,
      3.237046,
      '11-18-1976',
      '11- 2-1990',
      ' 6-20-2000',
      3,
      2.507705,
      1.474995,
      3,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      4.999430,
      1.397440,
      6,
      12,
      NULL,
      28,
      3.590899,
      2.504292,
      0.964763,
      0,
      1,
      NULL,
      1.560083,
      NULL,
      1.358281,
      1,
      2,
      NULL,
      NULL,
      0.017114,
      1.712211,
      3.010340,
      1,
      NULL,
      9,
      0.736728,
      0.523522,
      4,
      1,
      NULL,
      4.092897,
      1.095070,
      6.467346,
      0,
      4.499347,
      1.484681,
      10,
      1.591864,
      0,
      3.534324,
      5,
      1.773991,
      NULL,
      NULL,
      0.747354,
      NULL,
      NULL,
      NULL,
      1.483247,
      1.604620,
      3,
      1.982575,
      0,
      2.559241,
      3.275491,
      0.400499,
      1,
      0.499929,
      3.034384,
      NULL,
      1,
      0.455373,
      2.167897,
      NULL,
      1.078153,
      NULL,
      8,
      0.933845,
      7,
      2.378841,
      0,
      2,
      3.120028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.891838,
      0.661639,
      1.619874,
      2.044367,
      1.147603,
      1.192470,
      NULL,
      1,
      3.339729,
      3.286017,
      1.637582,
      1,
      NULL,
      1.108139,
      1.974491,
      NULL,
      0.336122,
      0.299245,
      NULL,
      0.583524,
      0.520651,
      NULL,
      1.594284,
      NULL,
      1,
      4.576585,
      1.701477,
      1.421472,
      0.918157,
      0,
      1,
      0,
      NULL,
      0,
      0.783923,
      4,
      0,
      NULL,
      0.642115,
      1.142487,
      2,
      NULL,
      7.102200,
      1.831154,
      0.312890,
      NULL,
      0,
      ' 9- 1-1975',
      265.181789,
      ' 9-18-1994',
      748,
      1,
      0,
      3.545347,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.844519,
      NULL,
      5.889901,
      0.046617,
      1,
      0.828476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.308193,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.282616,
      5.123613,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537716,
      2,
      1,
      1.008254,
      0.700087,
      1.683859,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949380,
      NULL,
      6,
      0.137303,
      1.938123,
      3.574682,
      4,
      1,
      4.086448,
      1.386871,
      1,
      6,
      3,
      NULL,
      2,
      NULL,
      1.298737,
      0,
      7,
      1.305330,
      0.950750,
      1.166312,
      0.528765,
      2,
      1,
      1,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      11,
      71,
      35.628461,
      1.285706,
      0.444494,
      3,
      '11232',
      '',
      '',
      1,
      '23134',
      '',
      '',
      1.201462,
      '',
      '',
      NULL,
      3,
      46,
      77,
      32.441682,
      0.984314,
      33,
      2,
      2,
      1,
      0.860196,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.685859,
      NULL,
      3,
      1.832006,
      NULL,
      NULL,
      NULL,
      1.550323,
      2,
      2.985108,
      3,
      2,
      0,
      NULL,
      NULL,
      1.592404,
      1.736874,
      NULL,
      0,
      0.852705,
      1.052192,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.310300,
      0.457390,
      0.869275,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552180,
      1,
      NULL,
      NULL,
      0.018438,
      NULL,
      NULL,
      0,
      NULL,
      0.323630,
      2,
      0,
      3,
      3.779014,
      1,
      NULL,
      0.279620,
      0,
      NULL,
      3,
      1.434557,
      1,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.717119,
      1.308543,
      3.263807,
      2.187005,
      5.247357,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.896420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1.497703,
      0,
      2.859850,
      NULL,
      NULL,
      NULL,
      3.165893,
      0.982549,
      NULL,
      1,
      1.586393,
      1.531741,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.576665,
      NULL,
      NULL,
      0.065510,
      NULL,
      NULL,
      0.123972,
      NULL,
      NULL,
      0.404258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.337804,
      NULL,
      NULL,
      0.791589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.666122,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1.250128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.481829,
      5,
      5.154485,
      3.956286,
      1.942959,
      NULL,
      NULL,
      3.556740,
      3.317720,
      2.139104,
      0,
      1,
      1.263676,
      1,
      1.495318,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542607,
      NULL,
      NULL,
      1.275346,
      NULL,
      NULL,
      0.072138,
      NULL,
      NULL,
      0.419810,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.598865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.822616,
      1,
      0,
      NULL,
      0.735124,
      1,
      NULL,
      NULL,
      1.843797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.920570,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.942911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607755,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.680896,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.874041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.064952,
      0,
      NULL,
      0.107932,
      13,
      0.639346,
      0.234773,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.066747,
      4.474662,
      0,
      1.065384,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168700,
      NULL,
      1.437684,
      0.790330,
      1,
      1.180169,
      NULL,
      0.043596,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1.456965,
      0.823042,
      0,
      1,
      1.079423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113733,
      1,
      0,
      NULL,
      0.608612,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.873216,
      NULL,
      1,
      NULL,
      0.246861,
      NULL,
      1.176273,
      0.958641,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271476,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651011,
      0.463729,
      NULL,
      1.282536,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.402406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.031854,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      4.095302,
      2.322329,
      0,
      1.169939,
      1.127279,
      0.007100,
      NULL,
      1.119267,
      1,
      NULL,
      NULL,
      0.728268,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.760738,
      0.725654,
      NULL,
      1.387570,
      1.565957,
      NULL,
      0,
      0,
      NULL,
      0,
      3.469261,
      NULL,
      0.476557,
      0.754389,
      NULL,
      2,
      0,
      1.031039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690473,
      NULL,
      NULL,
      NULL,
      0.668746,
      NULL,
      1,
      6,
      10,
      3,
      1,
      1,
      43.796271,
      NULL,
      4.571689,
      0,
      NULL,
      NULL,
      NULL,
      '',
      1,
      '00204',
      NULL,
      '',
      1.356500,
      '',
      '',
      NULL);
commit;
end;
/


