set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5504579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1021001',
      3,
      NULL,
      1,
      1,
      '2212',
      3,
      1.505658,
      NULL,
      NULL,
      ' 0-21-1998',
      0.180902,
      NULL,
      0,
      2,
      0.851779,
      ' 8-13-2000',
      10,
      0,
      84.262775,
      63.173426,
      3.227949,
      ' 6- 6-1993',
      ' 1-19-1979',
      '10-13-1982',
      1,
      NULL,
      1,
      0,
      0.877327,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.042253,
      14.329953,
      188,
      NULL,
      2.277782,
      16,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.101831,
      3,
      5.074072,
      1.526619,
      0,
      0.224662,
      1.579616,
      NULL,
      1.183103,
      0.708053,
      7.658558,
      0.150736,
      0.220617,
      NULL,
      1,
      0,
      NULL,
      1.276840,
      5,
      0,
      1,
      1,
      NULL,
      NULL,
      1.949478,
      NULL,
      NULL,
      7,
      2.547722,
      1,
      3.593533,
      1.741577,
      1.930023,
      1,
      1.141029,
      0,
      NULL,
      0.494102,
      0,
      0.802762,
      1.246067,
      0.106902,
      0.648164,
      1,
      0,
      0,
      NULL,
      0.843403,
      1.812513,
      8.297687,
      0.648938,
      4,
      0.040181,
      1.517290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1.496464,
      0,
      1.344064,
      1,
      0.340357,
      0.812032,
      0.003173,
      1,
      1.150672,
      0.184958,
      0,
      NULL,
      0.698054,
      2.689515,
      NULL,
      0,
      0.949410,
      1.173609,
      NULL,
      7,
      NULL,
      3.492604,
      NULL,
      NULL,
      0.029657,
      NULL,
      1.591300,
      4.423522,
      NULL,
      NULL,
      4,
      5.710616,
      5.445755,
      3.330180,
      11.818151,
      4.389998,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1028,
      ' 1-11-1984',
      NULL,
      0.370812,
      0.712954,
      1,
      5.588704,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083611,
      0,
      1.442758,
      NULL,
      1,
      1.497799,
      1.605144,
      1.551356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.037560,
      0.529781,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548068,
      1.395947,
      2.413732,
      NULL,
      2,
      2,
      4.317726,
      1.058924,
      NULL,
      NULL,
      2.699415,
      2.239871,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.067704,
      1,
      0,
      NULL,
      0,
      1.985923,
      0.244916,
      3.023908,
      6.532075,
      0,
      NULL,
      40.692787,
      1465.659713,
      505,
      3,
      0,
      3.829299,
      3.684439,
      NULL,
      1.250894,
      2.811629,
      2.791143,
      2,
      1.725505,
      2.903584,
      1,
      NULL,
      2.348526,
      NULL,
      NULL,
      140.855410,
      NULL,
      NULL,
      188.095155,
      165.452010,
      21,
      NULL,
      28,
      5.420664,
      75,
      154.707649,
      21,
      NULL,
      0.808631,
      19.082827,
      1.346871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      13,
      29,
      31.252873,
      2,
      1,
      0.704506,
      '24442',
      '',
      '',
      1.665873,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      15,
      14.516941,
      10,
      1.781308,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.810023,
      2.250892,
      2.867345,
      1,
      NULL,
      NULL,
      0.727510,
      NULL,
      NULL,
      1.942297,
      NULL,
      NULL,
      0.165826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623124,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042015,
      NULL,
      NULL,
      NULL,
      2.946738,
      6.389808,
      8.521252,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.348939,
      1,
      1.943551,
      1.481772,
      1.867000,
      0,
      0.680509,
      0,
      0.517181,
      NULL,
      1.978208,
      0.858456,
      0.397163,
      0.391416,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.200532,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2,
      1.478667,
      0,
      0.411374,
      NULL,
      NULL,
      NULL,
      0.481746,
      NULL,
      NULL,
      NULL,
      0.817882,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064485,
      NULL,
      NULL,
      1.251465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.624883,
      NULL,
      NULL,
      1.218083,
      NULL,
      NULL,
      1.524722,
      NULL,
      NULL,
      1.108209,
      NULL,
      NULL,
      1.051789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509564,
      NULL,
      NULL,
      1.765699,
      NULL,
      NULL,
      1.483541,
      2,
      1.958081,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.164122,
      NULL,
      NULL,
      2.749000,
      2.632412,
      1.287241,
      2.855833,
      1.474870,
      NULL,
      NULL,
      1,
      2.540162,
      3,
      0,
      1,
      0.088498,
      0,
      1,
      2,
      NULL,
      NULL,
      3.979133,
      2.325559,
      2,
      0.849155,
      1.042890,
      0,
      0.893754,
      0,
      NULL,
      NULL,
      NULL,
      1.533983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.856556,
      NULL,
      NULL,
      1.369031,
      NULL,
      NULL,
      0.780087,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.494653,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.201042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013701,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374714,
      1.091875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.434974,
      1.130284,
      NULL,
      NULL,
      0,
      3.854360,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2.566663,
      NULL,
      NULL,
      1.000387,
      0.291973,
      NULL,
      NULL,
      0.483928,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.938941,
      21,
      11.982817,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599529,
      NULL,
      NULL,
      3,
      0,
      883,
      1.725769,
      NULL,
      1.328788,
      5372,
      866.101679,
      0,
      NULL,
      0,
      1.471105,
      NULL,
      1,
      0,
      1.865169,
      0.204357,
      1.809805,
      0.441473,
      1,
      0,
      1.882264,
      1.461958,
      1,
      0.762101,
      1.871474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.771237,
      5.201537,
      2.681649,
      NULL,
      NULL,
      NULL,
      2.695318,
      0.224552,
      5,
      3.950715,
      1.553598,
      1,
      1.063730,
      0,
      0,
      3,
      0,
      2.611815,
      1.399709,
      1.198716,
      2,
      0.605509,
      1.047152,
      NULL,
      NULL,
      3.916825,
      1.751364,
      NULL,
      1,
      1.256207,
      NULL,
      2,
      2.941230,
      2.937737,
      NULL,
      NULL,
      1,
      0,
      1,
      13.498165,
      3,
      2.184396,
      1.406915,
      1.222368,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.124034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022568,
      1,
      NULL,
      1.308819,
      NULL,
      1.656612,
      NULL,
      NULL,
      NULL,
      3,
      1.780400,
      1.223442,
      NULL,
      94,
      3,
      1.271864,
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


