set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7524604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '1113240',
      1.011238,
      0.801745,
      3,
      3,
      '4401',
      3.554152,
      1,
      NULL,
      NULL,
      ' 3-18-1974',
      65,
      NULL,
      1,
      NULL,
      1,
      ' 7-26-1976',
      74,
      NULL,
      268.864852,
      84.637417,
      0,
      ' 7-13-1994',
      NULL,
      ' 3- 9-2000',
      1.397909,
      1.363986,
      3,
      0,
      NULL,
      0.400275,
      3.291347,
      0.694314,
      0,
      43.607962,
      NULL,
      NULL,
      9.814056,
      7,
      171,
      NULL,
      13,
      7.283452,
      NULL,
      9.391825,
      1.087411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959972,
      1,
      0.480094,
      NULL,
      0.603115,
      NULL,
      3,
      0.175565,
      3,
      1,
      7.091080,
      0,
      0,
      1,
      0,
      0.747626,
      0.774572,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.174268,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      0,
      0.220760,
      NULL,
      0.042121,
      NULL,
      0.776042,
      0,
      NULL,
      1,
      3.450733,
      3,
      3.839790,
      0,
      1,
      NULL,
      5,
      0.289674,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.627024,
      0,
      0.378234,
      2,
      2.500135,
      NULL,
      2,
      1,
      1,
      5,
      1,
      1.413306,
      1,
      3,
      0,
      NULL,
      1.071887,
      1.633868,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.454367,
      4,
      0,
      NULL,
      4,
      7,
      0.660728,
      NULL,
      0,
      6.179306,
      2,
      NULL,
      9.795960,
      6.604831,
      3,
      4.377766,
      7,
      8.496473,
      1.871979,
      NULL,
      2.968023,
      NULL,
      '10- 7-1977',
      1393.591823,
      ' 5-22-1996',
      200.200985,
      0.401390,
      1.177666,
      1.233159,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.197179,
      2,
      0,
      0.026004,
      1.903215,
      0,
      1.669051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      11,
      NULL,
      3,
      2.280122,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.195595,
      NULL,
      0.056151,
      NULL,
      NULL,
      NULL,
      2.236133,
      2.383164,
      NULL,
      5,
      NULL,
      3.676592,
      1.556858,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      1.243584,
      NULL,
      0,
      NULL,
      3.458067,
      1.866601,
      NULL,
      NULL,
      NULL,
      1.972995,
      1,
      0,
      1.732040,
      3,
      0,
      0.806438,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      18,
      5.647860,
      42.274996,
      0.840550,
      113,
      147,
      97.994724,
      72.159099,
      1.684370,
      NULL,
      1,
      0.503679,
      0.231116,
      1,
      0.934382,
      14.705525,
      10,
      NULL,
      8.776616,
      6,
      0,
      1.571779,
      0,
      2,
      0,
      NULL,
      5.583211,
      0.262740,
      1.893447,
      1,
      10.731229,
      0.608347,
      0,
      NULL,
      26.033231,
      57,
      45,
      9.227117,
      NULL,
      0,
      '13321',
      '',
      '',
      0.136918,
      '',
      '',
      '',
      0.321701,
      '',
      '',
      '',
      0.605385,
      11.990502,
      247.129262,
      49,
      3,
      NULL,
      2.975259,
      3,
      5,
      2.635519,
      0.065300,
      3.183186,
      1,
      NULL,
      NULL,
      1.946371,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.897591,
      1.882016,
      3,
      NULL,
      3.380444,
      1,
      1.373921,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.791998,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      4,
      NULL,
      0.971961,
      NULL,
      NULL,
      NULL,
      1.885235,
      NULL,
      NULL,
      NULL,
      0,
      0.142822,
      1.000083,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.843331,
      0.151230,
      NULL,
      NULL,
      1.767931,
      NULL,
      3,
      NULL,
      0,
      1.000064,
      3.935949,
      NULL,
      3,
      2.888142,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.487338,
      0,
      4.880725,
      6.434164,
      NULL,
      0.606873,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.885914,
      NULL,
      NULL,
      0.626803,
      NULL,
      NULL,
      0,
      1.053077,
      0,
      0,
      NULL,
      NULL,
      3,
      5.111616,
      5.406342,
      3.690996,
      3,
      0,
      1.065729,
      NULL,
      NULL,
      0,
      1,
      1.469537,
      0.639698,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.471192,
      NULL,
      NULL,
      0.326792,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.409319,
      NULL,
      NULL,
      1.641557,
      NULL,
      NULL,
      0.089991,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.410207,
      3.645124,
      1.119186,
      1.887825,
      NULL,
      NULL,
      1.061395,
      6,
      0,
      0.212920,
      2.196697,
      NULL,
      3,
      3.388024,
      0,
      2,
      7.126068,
      2,
      NULL,
      0,
      NULL,
      0.775308,
      15,
      NULL,
      1,
      0.218999,
      3.455790,
      1.551560,
      2.544907,
      2,
      7,
      4.835306,
      6,
      1.001893,
      3,
      0.721505,
      NULL,
      NULL,
      2.304588,
      NULL,
      0.923701,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072483,
      NULL,
      NULL,
      0.865792,
      NULL,
      NULL,
      1.151381,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.611021,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      4.661908,
      NULL,
      NULL,
      NULL,
      1.827033,
      NULL,
      NULL,
      NULL,
      1.108352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.224028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.562665,
      NULL,
      NULL,
      NULL,
      0.306090,
      NULL,
      NULL,
      NULL,
      0.096852,
      NULL,
      NULL,
      NULL,
      2.728681,
      NULL,
      NULL,
      NULL,
      1.607094,
      NULL,
      NULL,
      NULL,
      11.137038,
      NULL,
      NULL,
      NULL,
      0.337481,
      NULL,
      NULL,
      NULL,
      NULL,
      184,
      3,
      NULL,
      0,
      1.506832,
      0,
      NULL,
      NULL,
      0.589728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.863687,
      NULL,
      1,
      129.380942,
      1.189111,
      0.661657,
      1.964274,
      1,
      0,
      0,
      0,
      1,
      1.044926,
      1,
      1.236712,
      0.952989,
      1,
      0.885837,
      1,
      0.431032,
      0.491925,
      0.317592,
      0.973108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358437,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.353077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837953,
      NULL,
      2.311471,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.415755,
      NULL,
      1,
      NULL,
      1.207566,
      1.125466,
      1.415628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.381772,
      2.144261,
      0,
      0,
      0,
      1.206666,
      1,
      4.127287,
      NULL,
      3.323972,
      0.623693,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.963776,
      NULL,
      1,
      0,
      NULL,
      2,
      3.298067,
      NULL,
      1.473310,
      NULL,
      NULL,
      0.258878,
      0.841375,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.770349,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.665182,
      NULL,
      1.312219,
      NULL,
      6,
      4.280412,
      5.480065,
      NULL,
      0.396022,
      NULL,
      NULL,
      1,
      8.348439,
      1,
      2.718385,
      '02242',
      NULL,
      '',
      1.024236,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


