set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '4014230',
      NULL,
      NULL,
      0,
      NULL,
      '1422',
      2.118313,
      0,
      NULL,
      NULL,
      ' 4-27-1989',
      56.538574,
      NULL,
      2.443062,
      1.172543,
      2.853467,
      NULL,
      NULL,
      0,
      NULL,
      86,
      0.276386,
      ' 6-19-2001',
      NULL,
      ' 9-13-1994',
      0,
      NULL,
      1,
      3,
      1.578801,
      0.708638,
      2.337696,
      NULL,
      1.251729,
      28,
      0.907370,
      13.827198,
      2.910498,
      12.093839,
      19,
      4.652923,
      14,
      NULL,
      2,
      5,
      NULL,
      NULL,
      1.831732,
      0,
      0,
      NULL,
      1,
      NULL,
      2.663541,
      NULL,
      0,
      3.035627,
      NULL,
      3,
      1.235182,
      3,
      1.192659,
      6,
      1,
      1.035039,
      4.462116,
      7.238110,
      NULL,
      1,
      0.076207,
      7.603709,
      NULL,
      3,
      NULL,
      2.971281,
      0.501958,
      2,
      0.153112,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.677905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.646835,
      6.518429,
      0.860585,
      3.935800,
      1.185748,
      5.839540,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      0.162958,
      0.715658,
      1,
      0.611371,
      0.255661,
      1.886940,
      0.949107,
      0,
      0.642169,
      1.192870,
      0,
      1,
      NULL,
      0,
      1.197277,
      0,
      NULL,
      0,
      NULL,
      1.350066,
      1.453463,
      1,
      1.915917,
      1.864065,
      2,
      4,
      0.018691,
      5,
      0,
      2,
      7,
      5,
      NULL,
      4.699690,
      11.100612,
      9,
      8.543651,
      0,
      5.356266,
      11.608727,
      1,
      0.451564,
      1.773558,
      0,
      0,
      '11- 1-1983',
      NULL,
      ' 0-25-1988',
      NULL,
      NULL,
      0,
      1,
      4.828644,
      1.921714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.055560,
      4.988333,
      0.245945,
      1.327385,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.935565,
      NULL,
      2.637735,
      3.005409,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0.895704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416158,
      6,
      NULL,
      NULL,
      0.083440,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.903798,
      1.704374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.784985,
      0,
      0,
      NULL,
      0.161034,
      1,
      1.486427,
      17.836748,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.945141,
      0.980607,
      NULL,
      2.192835,
      0.675669,
      3,
      2,
      3,
      3,
      3,
      1,
      2,
      1.739062,
      1.050583,
      NULL,
      1,
      4,
      1.295454,
      0,
      1,
      0.843015,
      0,
      NULL,
      NULL,
      1.611646,
      1,
      0.119958,
      NULL,
      0.780388,
      14,
      4,
      1,
      NULL,
      4,
      NULL,
      9.093943,
      6.106233,
      3.550516,
      3.847653,
      NULL,
      1.054535,
      3.327800,
      0,
      NULL,
      42.684862,
      2,
      2,
      NULL,
      12.019170,
      8,
      22.961806,
      4.017055,
      2,
      2.188195,
      '31201',
      '44402',
      '',
      0.217098,
      '',
      '',
      NULL,
      2,
      '2222',
      '',
      '',
      3.073239,
      11.617591,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222635,
      3.565431,
      2.294809,
      0.357567,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901351,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.988692,
      NULL,
      NULL,
      4.889912,
      5.155996,
      3.525094,
      NULL,
      1.331341,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.705643,
      NULL,
      NULL,
      0.369808,
      NULL,
      NULL,
      0.998137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.383082,
      3,
      1,
      0.247928,
      2,
      NULL,
      NULL,
      NULL,
      7.693213,
      3,
      2.912961,
      1.569003,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.041592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559436,
      NULL,
      NULL,
      1.927686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.913107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.120265,
      NULL,
      NULL,
      1.579840,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.796461,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.426034,
      4.625131,
      2.466077,
      3,
      7,
      7,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0.445523,
      NULL,
      1,
      1,
      2.234309,
      0.010061,
      NULL,
      3.660205,
      3,
      1.212774,
      1.528602,
      2.565634,
      3,
      2,
      2,
      2,
      1,
      2.694227,
      3,
      3.166693,
      3.072278,
      0,
      NULL,
      4.087391,
      6,
      2,
      2.826050,
      3,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      0.954861,
      0.428024,
      NULL,
      NULL,
      NULL,
      0.536916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.619727,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.784962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895526,
      NULL,
      NULL,
      1.555277,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.858371,
      0,
      1.255103,
      1.277158,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.008177,
      NULL,
      NULL,
      NULL,
      0.331536,
      NULL,
      NULL,
      NULL,
      1.900917,
      NULL,
      NULL,
      NULL,
      1.552584,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.694805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545912,
      NULL,
      NULL,
      NULL,
      3.434834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721006,
      NULL,
      NULL,
      NULL,
      3.636880,
      NULL,
      NULL,
      NULL,
      3.153362,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202645,
      0.654884,
      0,
      0.205143,
      0.876298,
      1.944971,
      NULL,
      NULL,
      0.462370,
      NULL,
      NULL,
      1.807703,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133289,
      NULL,
      2.829733,
      NULL,
      0.664136,
      0,
      1,
      NULL,
      0.647466,
      NULL,
      NULL,
      0,
      NULL,
      0.848681,
      3.230612,
      0,
      NULL,
      NULL,
      1.193304,
      0,
      2.824571,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792196,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.510813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.060752,
      NULL,
      0.801501,
      NULL,
      1.537602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352581,
      NULL,
      0.024400,
      2,
      0.418529,
      3.811218,
      NULL,
      2,
      NULL,
      1392.814075,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950813,
      1,
      1.533780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253349,
      NULL,
      0.297302,
      NULL,
      0.708927,
      NULL,
      3.244584,
      0.295773,
      26,
      NULL,
      NULL,
      1,
      3,
      0,
      0.310488,
      NULL,
      2.628986,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.262124,
      3,
      0.906718,
      0.221839,
      1.025025,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      0.109258,
      NULL,
      NULL,
      0.388778,
      2.281356,
      NULL,
      NULL,
      0.465502,
      NULL,
      NULL,
      1,
      NULL,
      1.804524,
      1.796596,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.755088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.365124,
      NULL,
      1.396293,
      NULL,
      3,
      7,
      0,
      0.427941,
      NULL,
      NULL,
      24,
      92.188533,
      3,
      1,
      3.525775,
      '04122',
      '44320',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '2100',
      '',
      '');
commit;
end;
/


