set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000419';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7,
      NULL,
      0,
      0.712267,
      1.089099,
      2,
      1.122303,
      2.929831,
      '102',
      '43410004',
      NULL,
      61,
      '0201021',
      NULL,
      1.038097,
      3,
      2,
      '4403',
      3,
      0,
      NULL,
      NULL,
      ' 0-15-1984',
      NULL,
      215.249963,
      NULL,
      1,
      0.701643,
      ' 1- 0-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3-10-1996',
      ' 8-17-1996',
      ' 6-28-1982',
      NULL,
      1,
      0.194869,
      0.722240,
      0,
      3,
      NULL,
      NULL,
      0,
      122,
      9,
      17.248973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.130859,
      2,
      1,
      0,
      0,
      1.793116,
      NULL,
      3,
      5.164830,
      1,
      0,
      1.936904,
      2.682785,
      4,
      NULL,
      1.160967,
      1,
      1,
      0.029060,
      0.071930,
      NULL,
      0,
      0.448421,
      0,
      0,
      0.671084,
      1.095785,
      NULL,
      1,
      4.726363,
      0.219268,
      1.059597,
      NULL,
      NULL,
      NULL,
      0.896433,
      NULL,
      NULL,
      1.690169,
      1.804701,
      1.746960,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.961949,
      1,
      1,
      NULL,
      1.613897,
      2,
      1.230578,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.943792,
      2,
      1,
      5.200141,
      0,
      1,
      NULL,
      1,
      1.392985,
      1.824383,
      0.090281,
      0.874376,
      NULL,
      0.236144,
      1,
      0,
      1.207227,
      0.178541,
      NULL,
      1.881200,
      2.432010,
      1,
      4,
      5,
      NULL,
      3.869885,
      4,
      0,
      1.632290,
      4,
      1.399297,
      0.520402,
      2,
      NULL,
      6,
      9,
      NULL,
      1.864102,
      1.156259,
      0.738517,
      4.141635,
      5.145086,
      NULL,
      3,
      NULL,
      NULL,
      2,
      ' 1-23-1990',
      NULL,
      ' 4-14-1976',
      448,
      0,
      0,
      1.622908,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144121,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.581310,
      1.970286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.731050,
      NULL,
      13,
      NULL,
      1.850850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.110227,
      3,
      0.619735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.106780,
      0.627151,
      0,
      NULL,
      NULL,
      NULL,
      1.781492,
      11.746866,
      0.178313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.805912,
      1.375400,
      0,
      0.225973,
      3.449764,
      29.595904,
      2.053807,
      0.434544,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      2.918012,
      NULL,
      2.286483,
      3,
      NULL,
      3,
      0,
      2.942362,
      NULL,
      0,
      NULL,
      0.537957,
      3.054691,
      0,
      0.599685,
      0,
      1,
      0.740086,
      1,
      0,
      NULL,
      NULL,
      2.813846,
      0.210549,
      7.641181,
      NULL,
      7,
      7.945357,
      0,
      NULL,
      NULL,
      3.516108,
      4.272005,
      1,
      2.517626,
      3.423915,
      50,
      3.628702,
      1,
      75.552474,
      NULL,
      7.545040,
      68,
      1.731490,
      NULL,
      NULL,
      '04114',
      '41442',
      '',
      0.649452,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      3,
      55,
      101,
      42,
      0,
      29.871672,
      NULL,
      NULL,
      2,
      3.749981,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.787337,
      NULL,
      1.515373,
      3.689534,
      3,
      3,
      0.093496,
      3.009121,
      1.579348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.463477,
      2.541139,
      0.469574,
      NULL,
      1,
      7,
      1,
      7,
      NULL,
      1.894199,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.933009,
      3,
      2.459520,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.563464,
      2.275156,
      1.744821,
      1,
      NULL,
      2.135220,
      1,
      0.026109,
      1.516572,
      3,
      2,
      0,
      1,
      1.930768,
      2.903125,
      NULL,
      0,
      0.772137,
      0,
      1.101020,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      0,
      1.110918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978042,
      2,
      0.191711,
      NULL,
      NULL,
      0.006313,
      NULL,
      NULL,
      1.453878,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282948,
      1.561205,
      1,
      0,
      NULL,
      NULL,
      1.958204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.016161,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      1.439590,
      1.666534,
      NULL,
      NULL,
      6,
      NULL,
      0.754071,
      9,
      NULL,
      6,
      6,
      2,
      3.624958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636807,
      3.186744,
      NULL,
      3,
      11,
      9,
      NULL,
      1.719833,
      NULL,
      0.153499,
      3.987946,
      NULL,
      2,
      2,
      NULL,
      0.626929,
      1.296265,
      2,
      1,
      NULL,
      8.926473,
      6.755740,
      NULL,
      NULL,
      6,
      0.343933,
      5.903608,
      5.913641,
      0.116347,
      NULL,
      0.309857,
      0.517909,
      1.655910,
      0.319053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.235118,
      NULL,
      NULL,
      2.882007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000093,
      NULL,
      NULL,
      1,
      0.252327,
      2.382447,
      NULL,
      1.941516,
      0,
      0.979426,
      9,
      4,
      2,
      8,
      NULL,
      8,
      5.597554,
      16,
      2.713218,
      NULL,
      2.005232,
      1.735611,
      1,
      NULL,
      NULL,
      0.580507,
      NULL,
      NULL,
      1.627712,
      0.944670,
      0,
      NULL,
      NULL,
      1.830308,
      1.066077,
      1,
      NULL,
      0.617647,
      3,
      NULL,
      NULL,
      1.834559,
      0.503096,
      1.061922,
      0,
      1,
      1.337159,
      1,
      1.328041,
      1.737178,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      2.217553,
      2,
      3.017201,
      3,
      0.334241,
      1,
      0,
      0,
      1,
      3,
      NULL,
      0.360123,
      2,
      NULL,
      NULL,
      2.688326,
      1.053701,
      3,
      0.555211,
      2.200781,
      NULL,
      3,
      2,
      2,
      NULL,
      NULL,
      0,
      0.519833,
      NULL,
      11.432609,
      6,
      9.933077,
      1,
      2,
      2.716769,
      1,
      NULL,
      NULL,
      NULL,
      0.048818,
      NULL,
      15,
      0.815882,
      67.890668,
      20.286143,
      0,
      NULL,
      NULL,
      1.898101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.857262,
      9.320109,
      NULL,
      1,
      NULL,
      0,
      3,
      15,
      0,
      0.105461,
      1,
      0,
      0,
      0.607237,
      1.436526,
      0.645083,
      0,
      NULL,
      0.077121,
      1.372056,
      1.998889,
      1,
      1,
      1,
      NULL,
      2,
      NULL,
      0.254965,
      NULL,
      0.872221,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315018,
      0.507619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526776,
      3.792321,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.362014,
      0,
      NULL,
      NULL,
      1.063056,
      NULL,
      1,
      NULL,
      144,
      NULL,
      2,
      NULL,
      0.685878,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662831,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703199,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.427773,
      NULL,
      NULL,
      NULL,
      1,
      1.440858,
      0,
      NULL,
      12.261837,
      1.469304,
      0.793110,
      NULL,
      2.449514,
      3.297428,
      1.692946,
      1,
      9.098361,
      2.366523,
      0,
      NULL,
      3.058591,
      9.521734,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.009927,
      NULL,
      NULL,
      0.768238,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.423400,
      NULL,
      0.618982,
      0.927461,
      NULL,
      0.846831,
      2.698518,
      NULL,
      0.665050,
      NULL,
      NULL,
      0.356862,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068533,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      4.198347,
      7,
      0,
      2.108707,
      3,
      53.749931,
      1,
      1.960414,
      3.956751,
      1,
      '41343',
      '01023',
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      '0300',
      '',
      '');
commit;
end;
/


