set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '1132334',
      4.870825,
      0,
      4,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      23.634902,
      NULL,
      5,
      2,
      1,
      ' 0- 4-1987',
      2,
      2.904796,
      288.374241,
      84.888172,
      NULL,
      ' 9- 2-1991',
      NULL,
      ' 1- 0-1985',
      1,
      0.487915,
      1,
      0,
      1,
      1,
      3,
      0.678430,
      0,
      6.164580,
      NULL,
      2.471879,
      NULL,
      2,
      21.903773,
      NULL,
      23.158694,
      7.524346,
      NULL,
      3,
      NULL,
      2.389557,
      1,
      1.693945,
      1.052624,
      1.375400,
      NULL,
      2.053098,
      0,
      0,
      1.119911,
      2,
      5,
      4,
      NULL,
      1,
      1,
      3,
      1.770320,
      NULL,
      0,
      2,
      1.821147,
      4.703501,
      NULL,
      5,
      7.772935,
      NULL,
      3.669396,
      4,
      1.306130,
      1,
      3.584237,
      1.235697,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.321655,
      0.597328,
      1,
      0.434773,
      0,
      1,
      1.496700,
      3.611354,
      0,
      1,
      2,
      0,
      1.625339,
      1,
      1.238997,
      1.116827,
      1.253448,
      1.612480,
      0,
      NULL,
      NULL,
      0,
      2.549833,
      0,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      3.654779,
      10,
      7,
      3.721817,
      0,
      3,
      0,
      5,
      0.872969,
      2,
      NULL,
      1,
      1.304197,
      1,
      NULL,
      0.470425,
      NULL,
      0,
      NULL,
      0.488854,
      5.406087,
      2.412916,
      0.241237,
      1.274876,
      2,
      0,
      1,
      1,
      0,
      NULL,
      6,
      9.814612,
      6,
      0,
      4,
      1.743761,
      6.795019,
      10.035481,
      NULL,
      4,
      3,
      3,
      7,
      6.019429,
      4,
      1.094020,
      0.851581,
      ' 6- 5-1993',
      36,
      ' 6- 1-1981',
      NULL,
      NULL,
      1,
      3.180683,
      7.308790,
      0.820904,
      NULL,
      2,
      0,
      3,
      NULL,
      1,
      7,
      1.333174,
      NULL,
      NULL,
      0.328196,
      5,
      NULL,
      1,
      NULL,
      3,
      ' 3-23-1995',
      16.207471,
      NULL,
      NULL,
      0.558353,
      0,
      2,
      1.391193,
      NULL,
      NULL,
      NULL,
      NULL,
      4.936396,
      NULL,
      1,
      1.271706,
      3,
      3.623104,
      11.297752,
      0,
      3.790120,
      1.549468,
      3.028007,
      0.289043,
      6.308882,
      0,
      8,
      0.468461,
      NULL,
      6.189892,
      1,
      NULL,
      NULL,
      NULL,
      1,
      7.499245,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.087796,
      1.925537,
      0.270195,
      NULL,
      3,
      0,
      0,
      1.582492,
      5.438914,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.983284,
      2.552670,
      NULL,
      0,
      NULL,
      2.122387,
      2,
      NULL,
      NULL,
      2,
      NULL,
      2.236289,
      3,
      1,
      0,
      4.312402,
      0,
      0.290570,
      NULL,
      1.897815,
      1.644650,
      NULL,
      0.106356,
      NULL,
      0,
      0.299404,
      1.864951,
      0,
      0.569987,
      0,
      0.539628,
      11,
      10.574584,
      2.773586,
      7.216597,
      10.997185,
      0.775858,
      0.985753,
      2,
      6.647354,
      1.525257,
      2,
      3,
      60.608496,
      3,
      2,
      NULL,
      NULL,
      33,
      36,
      3.848859,
      0.775526,
      2,
      '34124',
      '44402',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '0224',
      '',
      NULL,
      NULL,
      16,
      NULL,
      52.452429,
      2,
      20,
      2.297398,
      0.093552,
      3,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      1.089638,
      0.158414,
      1.342673,
      2,
      2,
      1.498808,
      1,
      0,
      1.135568,
      1,
      NULL,
      NULL,
      NULL,
      3.594138,
      1,
      1,
      1,
      0,
      0,
      2,
      0.678612,
      2,
      NULL,
      NULL,
      2,
      0.971233,
      0,
      NULL,
      2.834074,
      NULL,
      NULL,
      NULL,
      3.862461,
      3.108275,
      2,
      1.564414,
      0,
      0.271516,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459310,
      18.684351,
      1.947025,
      NULL,
      NULL,
      1.098408,
      NULL,
      NULL,
      3.908450,
      0,
      1.804326,
      1,
      1,
      0.467845,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.313800,
      NULL,
      0.717781,
      0,
      1.333638,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      4,
      1.015634,
      2.639640,
      1.403743,
      NULL,
      2.995556,
      0,
      2.680309,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360226,
      NULL,
      NULL,
      2.192914,
      2.740093,
      0.067338,
      3.517990,
      3.141621,
      1.581846,
      NULL,
      0,
      1,
      9.785926,
      3,
      2,
      1,
      2,
      0,
      NULL,
      1,
      0.851292,
      8,
      8.517603,
      NULL,
      NULL,
      1.347278,
      1,
      NULL,
      NULL,
      NULL,
      0.757369,
      NULL,
      NULL,
      1.694085,
      NULL,
      NULL,
      0.343725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603026,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.233691,
      2,
      0.836642,
      1.087465,
      3,
      0.345283,
      1,
      1.366385,
      3,
      4,
      5,
      5,
      1.566767,
      NULL,
      2,
      0,
      2,
      1,
      2.952465,
      3.707856,
      0,
      1,
      2,
      0,
      NULL,
      6,
      4.985859,
      3.147286,
      NULL,
      NULL,
      3.413821,
      NULL,
      3,
      2.990771,
      NULL,
      NULL,
      1.462083,
      2,
      2,
      NULL,
      5.843346,
      1.762766,
      NULL,
      6.784557,
      9,
      NULL,
      1.968709,
      NULL,
      NULL,
      3,
      1.859985,
      NULL,
      0,
      2,
      NULL,
      3.254633,
      0.074447,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330928,
      NULL,
      NULL,
      0.379831,
      NULL,
      0,
      NULL,
      NULL,
      3.682776,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.448685,
      0,
      NULL,
      3.396931,
      0.653089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.162714,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.343595,
      NULL,
      NULL,
      15.072117,
      0.143778,
      NULL,
      NULL,
      7,
      0.139761,
      NULL,
      NULL,
      14,
      0.015723,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.075220,
      1.635295,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.754013,
      0.294419,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.738952,
      NULL,
      NULL,
      3,
      0.524321,
      NULL,
      NULL,
      1,
      1.629506,
      NULL,
      NULL,
      1,
      1.164241,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      8.129740,
      0.943006,
      1.369102,
      NULL,
      NULL,
      0.575414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.370873,
      NULL,
      NULL,
      0.490604,
      NULL,
      0,
      33,
      18.754069,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.940626,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1.548275,
      1.632160,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.378145,
      NULL,
      1,
      NULL,
      282.535715,
      NULL,
      NULL,
      8.265263,
      30,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.104302,
      NULL,
      0.782433,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374512,
      NULL,
      0.270801,
      NULL,
      NULL,
      NULL,
      1,
      3.883648,
      NULL,
      2.287285,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471752,
      NULL,
      0.995278,
      NULL,
      1.423321,
      NULL,
      0.524496,
      NULL,
      1.412352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543149,
      NULL,
      NULL,
      0.027033,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.794124,
      NULL,
      0.337903,
      NULL,
      NULL,
      1.454481,
      3.442346,
      NULL,
      1,
      NULL,
      1.536168,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.228142,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.293570,
      NULL,
      3,
      NULL,
      1,
      0,
      0.514666,
      3.249654,
      NULL,
      1,
      NULL,
      1469,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752976,
      NULL,
      NULL,
      NULL,
      1.866568,
      1.720555,
      1,
      0,
      1,
      3,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.036153,
      0,
      1,
      1.556273,
      1,
      2.810884,
      0,
      1.349925,
      3,
      1.881709,
      3.944013,
      1,
      0.630481,
      0.020470,
      NULL,
      1,
      1,
      2,
      0,
      0,
      0.812619,
      0,
      1.809544,
      3.226006,
      1.883785,
      1,
      2.481160,
      0,
      1.496099,
      3.661308,
      NULL,
      0,
      0,
      1.334423,
      NULL,
      0,
      0,
      2.973744,
      NULL,
      0.870661,
      NULL,
      0.271331,
      NULL,
      1.119389,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.896324,
      NULL,
      1.019703,
      NULL,
      0.623172,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430734,
      0,
      0,
      NULL,
      1,
      5,
      NULL,
      4.152835,
      0.777388,
      NULL,
      NULL,
      36.285099,
      14,
      7.678643,
      1.147453,
      0.264891,
      '00330',
      NULL,
      '11143',
      NULL,
      '',
      NULL,
      NULL,
      2,
      NULL,
      '',
      '');
commit;
end;
/


