set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      1.422848,
      0,
      NULL,
      3,
      '2340',
      3,
      0.579308,
      NULL,
      NULL,
      ' 8-25-1985',
      NULL,
      NULL,
      5,
      3.320221,
      NULL,
      '11-10-1977',
      7,
      0.598909,
      100.011529,
      107,
      2,
      ' 1- 6-1975',
      NULL,
      '11- 5-1974',
      1.989147,
      2,
      3.047457,
      1.391612,
      1,
      NULL,
      NULL,
      0.936766,
      0,
      NULL,
      NULL,
      7.452940,
      5.718777,
      9.771410,
      28,
      2,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      1.432479,
      0.808495,
      1,
      0.521856,
      0.996975,
      1.604336,
      0.432061,
      1.799133,
      NULL,
      3.456227,
      4.069443,
      0.477020,
      2,
      NULL,
      1.373265,
      0.207282,
      0,
      0.729055,
      0.084909,
      NULL,
      0,
      1.956767,
      0,
      NULL,
      0,
      4.405662,
      0.913434,
      1.982046,
      1.980206,
      1.859381,
      1.769094,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.068800,
      0,
      4.556396,
      2.984361,
      1,
      1,
      2.764440,
      1.193287,
      0,
      0,
      1.777876,
      1.629093,
      NULL,
      NULL,
      0.066001,
      3.173371,
      2.723576,
      0,
      3,
      1.681719,
      0,
      1,
      6.048490,
      1,
      1.921504,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067542,
      NULL,
      1,
      3.076412,
      0,
      1,
      1.414692,
      1,
      4.030104,
      0.151400,
      1.396049,
      1.391971,
      1.111788,
      0.962584,
      0,
      1,
      1,
      1.641334,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0.185552,
      2,
      NULL,
      1.882561,
      2,
      1,
      0,
      3.823909,
      1.231933,
      5,
      0,
      4,
      2,
      0,
      9,
      7,
      2.492889,
      8,
      0,
      3.994043,
      1,
      2.043348,
      ' 0-19-1986',
      240.362627,
      NULL,
      411.807281,
      NULL,
      0,
      0,
      3.697543,
      1,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.551062,
      3.374518,
      0.675210,
      1,
      0,
      0,
      0.324686,
      2.443174,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.708071,
      NULL,
      1.400245,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.014248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803070,
      0,
      1.800505,
      1,
      NULL,
      1,
      1.606113,
      0.006090,
      4.328281,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.028834,
      0.544859,
      3.286823,
      NULL,
      1,
      0.812893,
      1,
      2,
      2.650327,
      1,
      1.038223,
      2.879144,
      0,
      1,
      1,
      0.232855,
      1,
      3,
      NULL,
      NULL,
      0.311316,
      1,
      0.680434,
      1.130572,
      0,
      0.709718,
      0.016942,
      1.147996,
      3.507883,
      1,
      3.463924,
      0,
      0,
      9,
      NULL,
      5.039506,
      NULL,
      2.658053,
      0.011506,
      NULL,
      1,
      1.978433,
      18,
      1,
      1,
      NULL,
      29,
      47,
      70.591693,
      NULL,
      1,
      NULL,
      '33212',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1,
      33.816416,
      80,
      23.575920,
      NULL,
      9,
      5.880020,
      12.236301,
      7.359584,
      0,
      2.949657,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782052,
      NULL,
      NULL,
      NULL,
      3,
      1.453289,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3.415075,
      0,
      1.599998,
      0.112750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314626,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0.301567,
      0,
      NULL,
      NULL,
      NULL,
      1.224991,
      NULL,
      NULL,
      NULL,
      1.367290,
      1.645031,
      NULL,
      0.866473,
      1,
      1,
      NULL,
      0,
      2,
      0,
      1,
      1,
      0,
      1,
      1.154047,
      1,
      NULL,
      0,
      3.536091,
      2.403919,
      NULL,
      1.771612,
      NULL,
      1.933644,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.241152,
      2,
      1,
      4,
      4.762555,
      3.992569,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.870284,
      NULL,
      NULL,
      0.364351,
      NULL,
      1.106167,
      2.925755,
      3.331535,
      0.054894,
      1,
      NULL,
      NULL,
      2,
      2.556985,
      0.741939,
      NULL,
      3.715766,
      1,
      3,
      2.517695,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.407910,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.120936,
      NULL,
      NULL,
      0.399849,
      NULL,
      NULL,
      1,
      0,
      1.705847,
      NULL,
      NULL,
      NULL,
      2.891635,
      5,
      1.006892,
      5,
      4.123823,
      NULL,
      0.923433,
      NULL,
      NULL,
      1.114208,
      0,
      0.909932,
      0,
      0.675065,
      0.858931,
      NULL,
      3.211903,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3.501770,
      3,
      2.636819,
      2,
      2.068095,
      0.229158,
      1,
      1,
      2.939165,
      0.330199,
      NULL,
      NULL,
      1,
      NULL,
      0.812795,
      NULL,
      0.440958,
      0,
      1.489559,
      0,
      1,
      1.113840,
      1,
      0.788328,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952370,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.626773,
      NULL,
      NULL,
      3.959027,
      NULL,
      NULL,
      0.283688,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.785169,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      0,
      1,
      0.293680,
      NULL,
      3,
      0.644341,
      NULL,
      NULL,
      3.163700,
      NULL,
      NULL,
      NULL,
      3.287821,
      NULL,
      NULL,
      NULL,
      1.972595,
      NULL,
      NULL,
      NULL,
      1.737962,
      NULL,
      NULL,
      NULL,
      2.189120,
      NULL,
      NULL,
      NULL,
      1.818118,
      NULL,
      NULL,
      NULL,
      3.289451,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.722956,
      NULL,
      NULL,
      NULL,
      1.410603,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.341743,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.329541,
      NULL,
      NULL,
      NULL,
      3.921667,
      NULL,
      NULL,
      NULL,
      1.122118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      61.879168,
      NULL,
      1.942743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227955,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0.161218,
      NULL,
      NULL,
      0,
      NULL,
      0,
      339,
      NULL,
      0.626199,
      1,
      0.401341,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1.259328,
      NULL,
      NULL,
      1.888881,
      1.974916,
      1.010256,
      1.549148,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752098,
      NULL,
      0.673658,
      6.232144,
      0.440519,
      1.648717,
      0,
      4.553882,
      2,
      3,
      0.758546,
      0.985177,
      0,
      3,
      NULL,
      0,
      2.343740,
      NULL,
      0,
      3.787662,
      NULL,
      1,
      1.252756,
      NULL,
      3.715765,
      NULL,
      NULL,
      1.746177,
      0.143943,
      NULL,
      3,
      0.833881,
      NULL,
      2,
      3.956864,
      NULL,
      3,
      2.932215,
      NULL,
      2.674519,
      2.034297,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.841800,
      1.018205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556383,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.948467,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.869639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.240513,
      0.742827,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.046683,
      NULL,
      0,
      3.118698,
      9,
      NULL,
      3.003641,
      1,
      9.539723,
      95.303438,
      NULL,
      1.784052,
      2.363539,
      '14440',
      '43314',
      '03441',
      NULL,
      '33444',
      '',
      NULL,
      1.109887,
      '',
      '',
      '');
commit;
end;
/


