set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7108881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '1421220',
      NULL,
      0.452597,
      NULL,
      NULL,
      '4103',
      0,
      1,
      NULL,
      NULL,
      ' 1-14-1990',
      37,
      NULL,
      0,
      NULL,
      7.198409,
      NULL,
      NULL,
      2.669173,
      290,
      74.376290,
      3,
      ' 4-11-2002',
      NULL,
      ' 5-10-1979',
      NULL,
      3.576644,
      1.431094,
      2,
      0.629520,
      0.588670,
      2,
      1.817013,
      1.075763,
      66.534398,
      12,
      15.924403,
      2.671313,
      5.553095,
      5,
      NULL,
      19,
      5,
      1,
      4,
      1.496274,
      1,
      NULL,
      0,
      1,
      1.493929,
      0,
      1,
      0.599062,
      3,
      0,
      NULL,
      0.280257,
      7,
      3.397823,
      0.989822,
      1,
      1.833484,
      0.686803,
      1.097628,
      2,
      2,
      0.611056,
      0.743545,
      NULL,
      NULL,
      0.659220,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313992,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206397,
      0.349190,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.047135,
      NULL,
      7,
      NULL,
      0.600384,
      1.704669,
      NULL,
      6,
      0.666956,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0.524445,
      NULL,
      1,
      NULL,
      6.111463,
      3,
      7.209524,
      4,
      1,
      4,
      0,
      0.741627,
      0.018092,
      5.717128,
      0.912640,
      2.100759,
      0.524086,
      0,
      NULL,
      NULL,
      2.992083,
      2.333227,
      1,
      2,
      6,
      3.900148,
      4,
      0.777313,
      NULL,
      2.894285,
      ' 2-26-1977',
      NULL,
      ' 8-12-1986',
      124,
      NULL,
      NULL,
      2.079983,
      0,
      0.506788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.626335,
      1,
      1.752078,
      4.522488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044991,
      NULL,
      5,
      3.873366,
      1.535450,
      0.263231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.704141,
      NULL,
      NULL,
      NULL,
      3.218257,
      1,
      4.517039,
      4.586624,
      0.556149,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956502,
      0.976755,
      0.137816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.872571,
      0.947667,
      1.601205,
      NULL,
      1.081280,
      NULL,
      NULL,
      0.012618,
      NULL,
      0.745821,
      1.558289,
      NULL,
      NULL,
      NULL,
      2.510923,
      NULL,
      2,
      0,
      1,
      NULL,
      1.938075,
      3.976691,
      1,
      NULL,
      0,
      NULL,
      0.752323,
      NULL,
      2,
      0,
      5.317963,
      0,
      0,
      NULL,
      0,
      1.851742,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.493227,
      4,
      5.862489,
      NULL,
      6,
      1.540327,
      1.388315,
      0.462513,
      52.317909,
      1,
      3.964331,
      NULL,
      NULL,
      40.217392,
      2.507997,
      NULL,
      0,
      NULL,
      '44011',
      '32101',
      '',
      2,
      '31302',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      3.249964,
      10,
      NULL,
      22.432740,
      3,
      NULL,
      1.366145,
      1,
      1.425323,
      1.663771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.169660,
      NULL,
      NULL,
      0.283855,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.820097,
      NULL,
      NULL,
      1.018257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.750972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058376,
      NULL,
      NULL,
      1.647047,
      NULL,
      NULL,
      0.241352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3.452260,
      1.815417,
      NULL,
      NULL,
      NULL,
      3,
      2.777829,
      NULL,
      3,
      NULL,
      NULL,
      0.353473,
      NULL,
      NULL,
      1.765022,
      1.690830,
      0,
      NULL,
      NULL,
      4,
      1.701406,
      1,
      0.137647,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.298696,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.954293,
      NULL,
      NULL,
      1.705486,
      3,
      3,
      2.643672,
      NULL,
      3,
      5,
      4,
      2.742286,
      3.027920,
      6,
      7.883644,
      0,
      NULL,
      NULL,
      1,
      1.653098,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      2,
      2,
      7,
      NULL,
      3.472699,
      2.442926,
      1.360630,
      3.594201,
      2,
      NULL,
      0.683267,
      0,
      1.878067,
      1.849710,
      0,
      2,
      1.076865,
      1.205065,
      1,
      NULL,
      3.402823,
      NULL,
      0.156950,
      NULL,
      NULL,
      0,
      1,
      1,
      1.561292,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.698566,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      396.971567,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.738055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364309,
      NULL,
      NULL,
      NULL,
      0.290454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465589,
      NULL,
      NULL,
      NULL,
      0.109496,
      NULL,
      NULL,
      NULL,
      2.092286,
      NULL,
      NULL,
      NULL,
      2.082483,
      NULL,
      NULL,
      NULL,
      3.461134,
      NULL,
      NULL,
      NULL,
      1.523359,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3.412496,
      4,
      NULL,
      NULL,
      0.868411,
      0,
      0,
      NULL,
      NULL,
      0.489903,
      NULL,
      NULL,
      1.137773,
      NULL,
      NULL,
      0.134259,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5205.529492,
      NULL,
      2,
      1.843008,
      0.283984,
      0.259086,
      NULL,
      1,
      0,
      1,
      1.494680,
      0,
      3.487891,
      1.963785,
      NULL,
      1,
      0.678679,
      NULL,
      NULL,
      0,
      1.000553,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.023565,
      NULL,
      8.090000,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      0,
      NULL,
      1.885956,
      NULL,
      1,
      NULL,
      1.508486,
      NULL,
      1.083573,
      NULL,
      0,
      NULL,
      1.055085,
      NULL,
      0.647766,
      NULL,
      1.985979,
      NULL,
      0,
      NULL,
      0.668910,
      NULL,
      0,
      NULL,
      0.530320,
      NULL,
      0.325775,
      NULL,
      1.837445,
      NULL,
      2.165921,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.117122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.320034,
      NULL,
      1.187057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.171948,
      NULL,
      0,
      1.696280,
      1,
      29,
      5.441179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.645241,
      1.723312,
      NULL,
      2,
      1,
      5,
      3.815502,
      13,
      3,
      1,
      2,
      0,
      1.654966,
      1.951161,
      0,
      3.401492,
      NULL,
      NULL,
      0.022034,
      3,
      0.818170,
      NULL,
      3.274751,
      0,
      0.337192,
      3,
      1.425898,
      1,
      NULL,
      1.354093,
      NULL,
      3.928808,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1.894737,
      2,
      3.974480,
      0,
      0.650376,
      3,
      1.498932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.794274,
      1,
      0.110734,
      NULL,
      0,
      6.293722,
      7,
      0.223843,
      3.542242,
      1.145537,
      NULL,
      5,
      78,
      0,
      0.918082,
      1,
      '11124',
      NULL,
      '04104',
      3.663541,
      '21400',
      '44012',
      '',
      0.341579,
      '',
      '',
      '');
commit;
end;
/


