set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '3444322',
      NULL,
      0.065196,
      6,
      2,
      '3442',
      1.952070,
      1,
      NULL,
      NULL,
      ' 5-18-1984',
      37.162760,
      NULL,
      3,
      3.650995,
      2,
      '10- 8-1987',
      4.118847,
      NULL,
      221,
      97,
      NULL,
      '11- 5-1978',
      ' 5-22-1997',
      ' 7- 8-1986',
      2,
      1.612306,
      0,
      2,
      0.262740,
      0.516419,
      0,
      0,
      NULL,
      8.290477,
      NULL,
      15,
      7,
      NULL,
      22.637417,
      1.501414,
      12.165243,
      5,
      0.220269,
      6.174887,
      NULL,
      1,
      1,
      0,
      0.114193,
      0,
      NULL,
      0.659277,
      1,
      0.267325,
      1,
      3,
      1,
      5,
      0,
      0.556173,
      0.582260,
      NULL,
      0.983649,
      0.321326,
      1.781018,
      4.466650,
      0.567471,
      1,
      0.685747,
      0.031675,
      0.000433,
      4,
      1.265275,
      2.924243,
      1.544167,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.998262,
      1,
      NULL,
      1.846334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287752,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.485961,
      NULL,
      NULL,
      NULL,
      1.516239,
      1,
      NULL,
      4,
      0,
      NULL,
      0.376622,
      NULL,
      1,
      1,
      1.894234,
      1.180051,
      1.398841,
      1.268385,
      NULL,
      NULL,
      NULL,
      1.941915,
      1,
      1.690034,
      0.818936,
      NULL,
      0.355299,
      0.855672,
      NULL,
      1,
      1.304106,
      2.040204,
      2,
      1,
      1.393738,
      9,
      6,
      9,
      0,
      6.777055,
      3,
      11.897455,
      2,
      1,
      1.613930,
      5.254433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113686,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.811690,
      NULL,
      0.480196,
      0.087940,
      1,
      2.826178,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.411780,
      NULL,
      14.236962,
      NULL,
      2.363599,
      0.744540,
      1,
      1.523249,
      2.405840,
      3,
      NULL,
      NULL,
      NULL,
      3.093998,
      2.146748,
      1,
      1.310532,
      2.115507,
      NULL,
      5.346148,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7.625864,
      1.586555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094523,
      1.180513,
      1.218495,
      0,
      NULL,
      1.618454,
      0.612059,
      3.479384,
      2.599636,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.476272,
      1.889975,
      3,
      3.599712,
      0.883426,
      2,
      0,
      3.275484,
      NULL,
      2.453108,
      1,
      3,
      0.405824,
      2,
      1.341844,
      0,
      2,
      0,
      0.244357,
      NULL,
      NULL,
      1,
      0.312504,
      1.416600,
      0,
      1,
      1,
      NULL,
      0.702766,
      3.379893,
      1.314536,
      1,
      11.409732,
      1,
      NULL,
      NULL,
      6.941534,
      2.209914,
      5,
      NULL,
      0.084271,
      2.057523,
      3,
      2.951533,
      66.195998,
      1.275003,
      2.680971,
      NULL,
      64.909118,
      NULL,
      25,
      NULL,
      1.802678,
      2.320574,
      '42142',
      '',
      NULL,
      1.421002,
      '21300',
      '',
      NULL,
      NULL,
      '4120',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.516887,
      0.437479,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      286.528137,
      1,
      NULL,
      1,
      0.926969,
      0.125367,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      0.541251,
      0.882441,
      1.848925,
      1.152605,
      NULL,
      NULL,
      NULL,
      0.043283,
      NULL,
      NULL,
      NULL,
      1.178293,
      NULL,
      0.952640,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.134525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.821898,
      3,
      NULL,
      3.332507,
      1,
      0,
      NULL,
      15.621511,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.186558,
      NULL,
      NULL,
      1.069919,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.520927,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.168074,
      NULL,
      NULL,
      0.249070,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.944909,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.341278,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.772895,
      NULL,
      1,
      NULL,
      1.928500,
      NULL,
      2,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      18.080791,
      2,
      NULL,
      3.265288,
      1.360351,
      NULL,
      1.312578,
      NULL,
      0.229252,
      NULL,
      1.023035,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.203446,
      NULL,
      1,
      NULL,
      16.154787,
      1.435605,
      NULL,
      0.072184,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.496464,
      7,
      7.015548,
      0.447575,
      NULL,
      NULL,
      48.957778,
      124,
      NULL,
      1.513556,
      0,
      '23134',
      '',
      '',
      3.950403,
      '14210',
      '',
      NULL,
      1,
      '4304',
      '',
      '');
commit;
end;
/


