set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716945';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42',
      '11',
      37,
      29.412903,
      '1221030',
      1,
      0,
      3,
      2,
      '1422',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.896115,
      14.813360,
      NULL,
      0.572570,
      NULL,
      ' 6-10-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      2.086739,
      NULL,
      2.670909,
      NULL,
      1.757803,
      NULL,
      NULL,
      NULL,
      0.148264,
      1.452825,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      1.647484,
      3.705824,
      2,
      NULL,
      NULL,
      NULL,
      1.982085,
      1.224302,
      0,
      1.049011,
      2.446060,
      0,
      0.115917,
      2.705546,
      1,
      6,
      0.201231,
      4,
      NULL,
      1,
      2.614040,
      1,
      1.757700,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.104581,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.963632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.990078,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213415,
      NULL,
      1.774261,
      0.076804,
      0.789575,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      2.747378,
      0,
      1,
      1.897768,
      0,
      0,
      NULL,
      1,
      3,
      1.915875,
      1,
      0.527638,
      NULL,
      5.444533,
      5,
      3.112394,
      2,
      5.220111,
      0.615265,
      NULL,
      1.937838,
      0,
      NULL,
      4,
      0,
      1.125181,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.256690,
      NULL,
      ' 6- 9-2002',
      643.622193,
      NULL,
      46.890785,
      0,
      1,
      0,
      1.450866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.535943,
      NULL,
      0,
      1,
      2,
      5.433830,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.154868,
      1.598487,
      2.299179,
      NULL,
      NULL,
      2.602056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436333,
      1,
      0.999464,
      1,
      1,
      5.750108,
      0,
      NULL,
      NULL,
      NULL,
      0.201729,
      0,
      0.632654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      1.048596,
      1.647590,
      35.259152,
      0.215563,
      0.987051,
      NULL,
      NULL,
      NULL,
      0,
      0.602827,
      2.559924,
      3.102910,
      3,
      NULL,
      1.962392,
      1.325297,
      2,
      3,
      NULL,
      0,
      NULL,
      3,
      3.579163,
      0.917446,
      NULL,
      1.738861,
      0.063096,
      9,
      0.208163,
      0.691118,
      NULL,
      1.628147,
      NULL,
      3,
      1,
      NULL,
      0,
      1.848306,
      0.045378,
      1.494058,
      10.890763,
      0,
      4,
      NULL,
      NULL,
      4,
      NULL,
      0.981140,
      1.580341,
      0.961703,
      NULL,
      3.510422,
      28.913735,
      0.979781,
      0.029346,
      NULL,
      NULL,
      30.537096,
      20,
      2.050480,
      3,
      3.522409,
      '4223',
      '',
      '',
      0.477655,
      '',
      '',
      '',
      0.351625,
      '',
      '',
      '',
      0,
      14.493745,
      64,
      50,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.576284,
      0.212204,
      NULL,
      1,
      3,
      2,
      0,
      NULL,
      NULL,
      2.998255,
      1.310779,
      NULL,
      0.265356,
      NULL,
      NULL,
      0.671855,
      NULL,
      NULL,
      1.074583,
      1,
      0.961010,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.025330,
      NULL,
      NULL,
      0.971790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1.144671,
      2,
      1.108796,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670089,
      NULL,
      NULL,
      NULL,
      1.805601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104733,
      NULL,
      NULL,
      0.873532,
      NULL,
      NULL,
      2.315280,
      2.207421,
      0,
      NULL,
      NULL,
      NULL,
      2.819779,
      0,
      NULL,
      2,
      1.744040,
      1,
      1,
      NULL,
      NULL,
      3.150490,
      0,
      1.870834,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.405872,
      NULL,
      NULL,
      0.549692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.382757,
      0,
      2.273828,
      5,
      3.806390,
      3,
      0.904361,
      NULL,
      NULL,
      2,
      0.643235,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.368102,
      NULL,
      NULL,
      3.719232,
      1,
      1.019747,
      3,
      1.815414,
      1,
      0,
      1,
      1,
      NULL,
      0.840507,
      1,
      1,
      NULL,
      NULL,
      0.415547,
      NULL,
      NULL,
      NULL,
      0.016465,
      4,
      1.755295,
      1.653063,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.937188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683503,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.637551,
      NULL,
      NULL,
      11.464798,
      NULL,
      NULL,
      NULL,
      0.028516,
      1,
      NULL,
      0.469064,
      3,
      2.979538,
      NULL,
      NULL,
      1,
      1.997202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.302424,
      NULL,
      NULL,
      NULL,
      2.280917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.155152,
      1,
      NULL,
      NULL,
      0.111746,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.369904,
      0.772299,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.267736,
      NULL,
      2.570388,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      18.268183,
      1.715630,
      NULL,
      NULL,
      0,
      NULL,
      1.620742,
      66,
      69,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1.240115,
      0,
      1.302548,
      NULL,
      NULL,
      0.637155,
      0.846881,
      1.275413,
      1,
      0.123593,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256651,
      1,
      1,
      0.646889,
      1,
      NULL,
      0,
      NULL,
      0,
      3.424210,
      NULL,
      3.946876,
      NULL,
      0,
      1,
      0,
      1.458650,
      NULL,
      1,
      1.759527,
      3.153979,
      0.360422,
      1,
      0,
      NULL,
      1.373461,
      1.592655,
      0,
      0.962618,
      1,
      1.533607,
      0.378872,
      0,
      NULL,
      0,
      0.667820,
      0.680964,
      0,
      0.781767,
      0,
      1,
      1.556185,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.161529,
      1.995881,
      NULL,
      NULL,
      1.489876,
      1.894981,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      27.383615,
      0.401972,
      2.765216,
      3.608123,
      '3104',
      NULL,
      '',
      0.047313,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


