set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.503808,
      3.665998,
      0,
      3,
      2,
      0.768651,
      1.336821,
      NULL,
      '03',
      '11042413',
      17.507896,
      22.109231,
      NULL,
      4,
      0.674017,
      0,
      3,
      '3243',
      4,
      0,
      NULL,
      NULL,
      ' 9- 3-1994',
      120,
      32,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 0-1997',
      0.442179,
      0.197161,
      0,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      3.031812,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.516148,
      1.223640,
      1,
      1,
      0.881165,
      NULL,
      1,
      2.702608,
      1.061122,
      1,
      0.043999,
      0,
      0.616290,
      0.039639,
      1.961594,
      1.423227,
      1.498600,
      0.567246,
      1.937170,
      0.343691,
      1,
      NULL,
      0,
      0.412517,
      NULL,
      0,
      0,
      1.923340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.404129,
      1.874220,
      0.857780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719759,
      1.089326,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.879872,
      NULL,
      0.330905,
      2,
      2,
      6,
      1.042915,
      0,
      5.015371,
      NULL,
      0.416963,
      NULL,
      8.993476,
      1.879724,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1.506002,
      4.378726,
      1.346236,
      0,
      1.191638,
      7.528899,
      0.269580,
      0.252009,
      1,
      0,
      1.844270,
      1.888945,
      3,
      0.529036,
      3.090519,
      4,
      5,
      6,
      8,
      NULL,
      1,
      8.931955,
      5.776100,
      1,
      1.547274,
      NULL,
      2,
      ' 3-24-2002',
      NULL,
      ' 8-26-1990',
      68,
      2.010656,
      NULL,
      0,
      2.735701,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.878117,
      0.481854,
      1,
      1.457300,
      0,
      0,
      1.070901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.630319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.797070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1.150105,
      1.832873,
      2.793381,
      2.661767,
      0,
      NULL,
      NULL,
      NULL,
      1.164146,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398320,
      NULL,
      NULL,
      NULL,
      NULL,
      0.715805,
      0.100137,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358782,
      0.769843,
      2.452956,
      0.591990,
      2,
      NULL,
      0,
      2.236299,
      1.429496,
      1,
      3.103941,
      0.201120,
      2,
      2.057498,
      1.062709,
      3,
      NULL,
      0,
      NULL,
      1.877897,
      1.887225,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      3.848861,
      1.581789,
      NULL,
      7.835933,
      8.548278,
      1,
      8.255859,
      6,
      1.320122,
      2,
      NULL,
      1.268214,
      2,
      0.900308,
      NULL,
      68,
      1.531005,
      1,
      24,
      NULL,
      NULL,
      NULL,
      3,
      2.514502,
      0.732331,
      '14420',
      '44133',
      '',
      1.554247,
      '',
      '',
      '',
      1.387952,
      '',
      '',
      '',
      NULL,
      NULL,
      27,
      2.642865,
      1,
      13.725376,
      2.967256,
      NULL,
      0.221056,
      NULL,
      0.495882,
      3,
      NULL,
      NULL,
      NULL,
      0.266417,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.296698,
      NULL,
      NULL,
      0.847966,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354574,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.783946,
      1,
      2.978860,
      0.222949,
      1.155996,
      1.943327,
      3.078821,
      1.987048,
      0,
      0,
      NULL,
      NULL,
      0,
      2,
      2.739528,
      2.656138,
      2.681424,
      1,
      NULL,
      NULL,
      7.411113,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005062,
      1,
      0,
      1.876236,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.791247,
      1,
      1.237400,
      NULL,
      NULL,
      1,
      2.428237,
      1.936719,
      5.557953,
      0,
      5.486828,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.694843,
      0.679617,
      2.527002,
      3.815933,
      1,
      NULL,
      0.057816,
      3,
      6.094730,
      7,
      4.347125,
      NULL,
      4.437957,
      NULL,
      1,
      7.029673,
      0,
      0,
      NULL,
      0,
      0.194638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.713230,
      NULL,
      NULL,
      1.539077,
      NULL,
      NULL,
      1.613584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      0.090854,
      1,
      1.235316,
      NULL,
      1.504003,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.176149,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.446411,
      NULL,
      NULL,
      NULL,
      0.396974,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.738221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.002517,
      NULL,
      NULL,
      NULL,
      2.002990,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295925,
      NULL,
      NULL,
      0.694697,
      NULL,
      0,
      3,
      5,
      NULL,
      0.524839,
      1,
      NULL,
      1,
      1,
      0,
      1.716679,
      1.653416,
      0.873212,
      1,
      1,
      NULL,
      0,
      1.772603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.706317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141467,
      0.221757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.457365,
      0.418591,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.448637,
      NULL,
      0,
      NULL,
      1.983311,
      NULL,
      17.661428,
      NULL,
      2.028893,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.292713,
      NULL,
      4.262370,
      0.310611,
      2.605259,
      0,
      3.809169,
      1,
      1.659500,
      NULL,
      3.975565,
      NULL,
      8.689731,
      2.864694,
      0.213397,
      0,
      NULL,
      0.274729,
      3.593167,
      2.321332,
      NULL,
      1.397396,
      0.598154,
      NULL,
      NULL,
      2,
      1,
      0.736094,
      0.943049,
      1,
      0.502635,
      NULL,
      0.426213,
      1.201129,
      NULL,
      NULL,
      0.239077,
      NULL,
      0,
      1.720337,
      NULL,
      0,
      2.584514,
      NULL,
      3,
      3.178216,
      NULL,
      NULL,
      1,
      NULL,
      0.120568,
      0,
      NULL,
      0,
      0.097071,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570477,
      1,
      NULL,
      NULL,
      0,
      0.231563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829614,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5,
      4,
      1.785202,
      NULL,
      NULL,
      29.698860,
      118,
      2,
      5.751502,
      2.609560,
      '04323',
      '44230',
      '',
      0,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


