set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9777759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      0,
      4.593805,
      1.623037,
      3.359425,
      1,
      NULL,
      '010',
      '41144311',
      51,
      NULL,
      '0411312',
      1.163501,
      NULL,
      3,
      NULL,
      '1042',
      0,
      0.515139,
      NULL,
      NULL,
      ' 9-28-1975',
      40.804339,
      52,
      NULL,
      1,
      1,
      ' 8-10-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      0.665301,
      '11- 3-1989',
      ' 2-18-1986',
      ' 6-29-1998',
      2.683468,
      3,
      3,
      1.189266,
      0.280757,
      1,
      2,
      1.613404,
      0,
      6.881242,
      5.242918,
      6,
      5.366799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678241,
      3.187227,
      1.196706,
      1.827935,
      1.164843,
      1.996032,
      NULL,
      1.823241,
      1,
      0,
      1,
      1.941851,
      3,
      1,
      2.209573,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.685811,
      0.928241,
      1.421970,
      0.806958,
      0,
      1.942164,
      NULL,
      NULL,
      0,
      0.718715,
      1.940822,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.528756,
      1,
      0,
      1,
      0.513242,
      1.504478,
      0,
      0,
      2,
      0.655998,
      NULL,
      1,
      1,
      1.888970,
      NULL,
      0,
      0.452300,
      NULL,
      1.364491,
      1,
      1,
      0,
      1.409519,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.638754,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      9,
      1,
      NULL,
      1,
      1.584010,
      2.486507,
      1,
      0.466268,
      1.838080,
      NULL,
      NULL,
      0.475368,
      0.504355,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.274672,
      1.986861,
      1,
      0.314025,
      1.307904,
      NULL,
      1,
      NULL,
      NULL,
      0.378915,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891502,
      5.606781,
      NULL,
      NULL,
      4,
      3,
      3,
      2,
      NULL,
      1.469166,
      1.179373,
      NULL,
      870,
      NULL,
      6,
      2,
      0.169871,
      1.495740,
      3.603075,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.466471,
      3,
      1,
      1.206151,
      NULL,
      0.345415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961285,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.337875,
      NULL,
      1.846706,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.681778,
      0.434602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.828044,
      NULL,
      2.902908,
      NULL,
      0.467121,
      NULL,
      0,
      4.109096,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.686019,
      0.301351,
      NULL,
      1,
      0,
      3.916224,
      2,
      2.474782,
      NULL,
      0,
      0,
      2,
      2,
      2.458030,
      1,
      1.244499,
      0.300719,
      0,
      1,
      1.980753,
      NULL,
      1.910758,
      1.096025,
      NULL,
      0,
      1.529815,
      0.137107,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      27.337563,
      NULL,
      57,
      55.662146,
      NULL,
      2,
      0.090312,
      '34012',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3,
      15,
      176,
      NULL,
      NULL,
      27,
      1.448481,
      0.633341,
      3,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007207,
      0.562779,
      1,
      1,
      NULL,
      NULL,
      0.474584,
      NULL,
      NULL,
      1,
      0,
      1,
      1.008997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.161453,
      NULL,
      NULL,
      1.000449,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.091262,
      1.782496,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.604175,
      3.365047,
      3,
      2,
      2.916695,
      1,
      0.581274,
      NULL,
      NULL,
      2.125536,
      0.968481,
      0.514580,
      2.258696,
      1,
      1,
      0,
      3,
      NULL,
      0.656544,
      NULL,
      0,
      3,
      1.798398,
      1.883848,
      1.284448,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082484,
      NULL,
      NULL,
      2.777305,
      0.436880,
      4.392882,
      1.787242,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.263186,
      1,
      1.352057,
      NULL,
      1.313526,
      1,
      NULL,
      NULL,
      2.597835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.340185,
      NULL,
      NULL,
      1.799428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.258689,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      3.665529,
      0.386831,
      0.974566,
      3.230612,
      1.118319,
      NULL,
      NULL,
      NULL,
      3.421214,
      2,
      1.847523,
      2,
      NULL,
      7,
      5.808381,
      NULL,
      3,
      5,
      1.660276,
      NULL,
      NULL,
      NULL,
      0.966223,
      0.872076,
      1.623724,
      1,
      0.633410,
      0.282463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.782832,
      1.425160,
      1,
      0.833288,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.408928,
      NULL,
      1.866688,
      NULL,
      NULL,
      1.307862,
      NULL,
      NULL,
      0.657611,
      1,
      1,
      1.354874,
      NULL,
      NULL,
      0.308004,
      NULL,
      NULL,
      1.797804,
      NULL,
      0.079458,
      12.383526,
      NULL,
      0,
      1.323133,
      NULL,
      0,
      0,
      0,
      0.950561,
      1.612321,
      0,
      1,
      0.308882,
      0,
      0,
      0,
      NULL,
      1.434987,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.283369,
      1,
      1.064230,
      NULL,
      0.456722,
      NULL,
      1.248409,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994991,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.271221,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554326,
      2.294854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      386.425444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.213106,
      0,
      NULL,
      0.880065,
      1,
      1,
      1.324913,
      NULL,
      7,
      0.762221,
      3,
      0,
      NULL,
      1.586099,
      NULL,
      0.947700,
      0.009837,
      NULL,
      1.585287,
      NULL,
      NULL,
      1,
      0.519754,
      NULL,
      0.818630,
      1.150621,
      NULL,
      1,
      1.917249,
      NULL,
      0.989340,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.471838,
      NULL,
      0.030709,
      1,
      NULL,
      0,
      NULL,
      1.466290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674542,
      NULL,
      1,
      6,
      5,
      0.194234,
      NULL,
      NULL,
      NULL,
      1.441081,
      1.941206,
      4,
      0,
      NULL,
      '42112',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


