set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '4310434',
      NULL,
      NULL,
      5,
      2,
      '3020',
      NULL,
      1.238648,
      NULL,
      NULL,
      ' 9- 0-2001',
      44.156864,
      NULL,
      1,
      1.793243,
      1.673998,
      '10-22-1984',
      35,
      3,
      356.077631,
      67.080619,
      0.322950,
      ' 2- 0-1992',
      ' 5-20-1975',
      ' 9-16-2002',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269747,
      3.512326,
      3,
      NULL,
      NULL,
      NULL,
      10,
      4,
      8,
      NULL,
      3,
      19.888333,
      4.508567,
      7.158010,
      5,
      0,
      0,
      0.524935,
      NULL,
      NULL,
      1,
      1.116043,
      0.826926,
      NULL,
      0,
      0.540932,
      0,
      NULL,
      3,
      2.983847,
      5.793410,
      NULL,
      0,
      7,
      1,
      1,
      4,
      0,
      1,
      1,
      0.060670,
      0,
      11.339513,
      0.392886,
      3.802678,
      1,
      NULL,
      1.167645,
      NULL,
      NULL,
      1.432787,
      NULL,
      NULL,
      10,
      NULL,
      1,
      2,
      NULL,
      1,
      2.635873,
      1,
      1,
      2.985029,
      1.472642,
      1,
      3.977679,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      4,
      1.153947,
      1,
      NULL,
      1.111398,
      NULL,
      NULL,
      1.125425,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      1,
      1.051282,
      0.173056,
      0,
      0.255234,
      0.405010,
      NULL,
      1,
      1.816659,
      0,
      1.088616,
      NULL,
      0,
      NULL,
      NULL,
      0.614703,
      NULL,
      0,
      3.097913,
      4,
      1,
      NULL,
      NULL,
      0.720789,
      5,
      2.443797,
      0,
      NULL,
      1.172781,
      0,
      1.966395,
      NULL,
      NULL,
      NULL,
      1.930232,
      0.326410,
      6.533355,
      8,
      NULL,
      2,
      ' 6-10-1986',
      NULL,
      ' 2- 2-1986',
      1,
      NULL,
      1.297388,
      0.877568,
      0,
      3,
      6.479895,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      9,
      7,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.566960,
      3,
      0,
      0.952591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.881164,
      1.530860,
      3,
      1,
      1.130557,
      0.436277,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521673,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.823248,
      1,
      1.719329,
      NULL,
      1.149851,
      1,
      19,
      NULL,
      1.363461,
      NULL,
      NULL,
      NULL,
      3,
      1.748253,
      0,
      1,
      3.701440,
      1,
      0,
      NULL,
      2,
      2,
      3,
      1.808655,
      1.630982,
      1,
      1,
      0.087689,
      1,
      NULL,
      0.938867,
      3,
      1,
      1,
      1,
      1.067788,
      0,
      1.261205,
      1,
      0,
      0.135015,
      0.069208,
      2.911812,
      0.874509,
      3,
      4,
      2,
      5,
      7,
      0,
      0.917425,
      2,
      3,
      NULL,
      0,
      1.194466,
      50.907098,
      2,
      1,
      NULL,
      28,
      NULL,
      NULL,
      NULL,
      3.634650,
      3,
      '4431',
      '34023',
      '',
      2.146943,
      '1030',
      '',
      '',
      0.038439,
      '',
      '',
      '',
      0.963019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537356,
      0,
      1,
      NULL,
      NULL,
      1.094972,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.432819,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.632133,
      NULL,
      1,
      NULL,
      11.827181,
      NULL,
      1.429785,
      0.497711,
      2.078968,
      1.012109,
      3.984522,
      1.507831,
      NULL,
      NULL,
      2.692186,
      0.973277,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.575157,
      NULL,
      0.949691,
      NULL,
      1.435103,
      NULL,
      NULL,
      NULL,
      42.371604,
      1,
      19.191019,
      3.395622,
      2.139186,
      1.794897,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.040733,
      NULL,
      0.689453,
      NULL,
      0.340267,
      NULL,
      1.364063,
      NULL,
      1.904616,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.099740,
      NULL,
      1.765331,
      NULL,
      1,
      NULL,
      0.753472,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.928181,
      NULL,
      NULL,
      NULL,
      0.807511,
      NULL,
      NULL,
      NULL,
      0.570179,
      NULL,
      1.095756,
      NULL,
      0.177069,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658685,
      1.256885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528101,
      1.298252,
      1.903076,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0.899820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.458386,
      1,
      0.979013,
      NULL,
      0,
      0.497033,
      0.651496,
      2,
      0.651490,
      1.106936,
      NULL,
      NULL,
      0.595766,
      1,
      NULL,
      0.670611,
      0,
      1,
      0,
      1.979978,
      1,
      NULL,
      0.122088,
      1.832359,
      1.816411,
      0.600377,
      1,
      0,
      0.114658,
      NULL,
      NULL,
      NULL,
      1.339936,
      1.813001,
      1,
      0,
      0,
      3.041521,
      NULL,
      3,
      0.702926,
      1,
      0,
      0,
      1.302980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667124,
      0,
      0,
      NULL,
      NULL,
      0.588356,
      1,
      3.024802,
      5,
      1.459559,
      NULL,
      NULL,
      78.960445,
      102,
      NULL,
      3,
      0.525805,
      '0103',
      '04332',
      NULL,
      0.282029,
      '0114',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


