set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7727700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1431133',
      0,
      0,
      NULL,
      2,
      '0432',
      1,
      2.713387,
      1.550019,
      9.725237,
      ' 0- 4-1977',
      42.759796,
      NULL,
      1.270069,
      2.791347,
      NULL,
      '11-10-1984',
      11,
      0.934810,
      NULL,
      NULL,
      3,
      ' 1-14-1982',
      ' 4- 8-1980',
      ' 6-18-1995',
      NULL,
      0,
      NULL,
      1.906567,
      1,
      0,
      1,
      1.029226,
      NULL,
      9,
      4,
      11,
      7.450706,
      7.510724,
      22,
      3,
      NULL,
      8,
      3,
      11.388966,
      1,
      1,
      NULL,
      0,
      0.670074,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      7,
      2.768565,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      6,
      NULL,
      NULL,
      1.643914,
      0.092641,
      1,
      0.537927,
      8.915957,
      2,
      4,
      1,
      2.598012,
      1.519347,
      NULL,
      NULL,
      1.241378,
      NULL,
      NULL,
      2,
      0,
      3.169085,
      NULL,
      1,
      NULL,
      0.926513,
      0.141314,
      1,
      NULL,
      0.792892,
      0.625575,
      0,
      3,
      NULL,
      0.159570,
      NULL,
      1,
      1.797990,
      0.807334,
      1.774778,
      1,
      7,
      1.792129,
      0.472044,
      3.898009,
      1.979205,
      NULL,
      NULL,
      0.064940,
      NULL,
      NULL,
      2,
      11.113223,
      5,
      0.035138,
      4,
      4,
      3,
      0.861987,
      2,
      1.326513,
      0,
      3.503317,
      1,
      2.066883,
      2,
      2,
      0,
      1,
      2.924229,
      NULL,
      4.986349,
      7,
      3,
      1.601883,
      0,
      0,
      4.865064,
      7.523890,
      8,
      9.980077,
      5.536967,
      3.647450,
      NULL,
      8,
      3,
      NULL,
      NULL,
      1.236985,
      0.063041,
      NULL,
      3.213346,
      NULL,
      NULL,
      1.125311,
      9.270799,
      NULL,
      1,
      3,
      ' 4-25-1977',
      0,
      ' 2-12-1999',
      3.931433,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.750840,
      1.124139,
      NULL,
      5.858552,
      0.166248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.396142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      1.323744,
      0.150929,
      3.791478,
      NULL,
      1.695350,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.658343,
      1,
      0,
      1,
      1,
      3.919143,
      14.880368,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      0.277597,
      NULL,
      1.232657,
      0.941246,
      2,
      0,
      2,
      NULL,
      0.277732,
      0,
      2.161511,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1.015217,
      0.723186,
      0,
      0.145438,
      0.338944,
      NULL,
      0.210394,
      NULL,
      NULL,
      6,
      0.633894,
      8,
      NULL,
      0.794830,
      NULL,
      1,
      NULL,
      0,
      0.303457,
      3,
      67,
      2,
      3,
      NULL,
      NULL,
      15,
      0.562689,
      2.086669,
      NULL,
      NULL,
      '12434',
      '',
      NULL,
      0.240175,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.755314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.604675,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.392329,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.795568,
      NULL,
      NULL,
      1.678061,
      NULL,
      1.687946,
      48,
      2,
      0,
      0,
      0.335649,
      NULL,
      1.660007,
      1,
      0,
      0,
      0.437859,
      NULL,
      1.899364,
      1,
      NULL,
      0.563666,
      1.852316,
      0,
      1.725464,
      3.109020,
      NULL,
      0.907298,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.979508,
      NULL,
      1.174562,
      NULL,
      NULL,
      NULL,
      0,
      20.520252,
      36,
      1.325765,
      0.569189,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.140393,
      NULL,
      1.675094,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.844279,
      NULL,
      0,
      NULL,
      0.732942,
      NULL,
      0.077727,
      NULL,
      0,
      1.309691,
      0.434523,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.355820,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.983045,
      0.944338,
      0.464475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.733600,
      NULL,
      1.597393,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.777346,
      NULL,
      12.096026,
      3,
      6,
      3,
      2,
      NULL,
      3,
      0.656698,
      1.090095,
      0,
      2.817179,
      NULL,
      0,
      2.864888,
      NULL,
      0.175511,
      NULL,
      NULL,
      1,
      3.020769,
      NULL,
      2,
      1.788677,
      NULL,
      0,
      2.594075,
      NULL,
      3.972932,
      3.980425,
      NULL,
      0.461308,
      3,
      NULL,
      0,
      3.355141,
      NULL,
      0.899755,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.783936,
      0.629977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.565858,
      0,
      0,
      3,
      43.861404,
      75,
      0,
      0.236294,
      NULL,
      '44442',
      '',
      '',
      2.309583,
      '42341',
      '',
      '',
      0.933756,
      '',
      '',
      '');
commit;
end;
/


