set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9747583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      1.475477,
      0,
      0,
      2.771126,
      2,
      2.417608,
      2,
      NULL,
      '21021003',
      71,
      23,
      '0111144',
      0,
      NULL,
      NULL,
      0,
      '3313',
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 9-1980',
      227,
      134,
      NULL,
      NULL,
      2,
      ' 7-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.570309,
      1,
      1,
      2.315989,
      NULL,
      1.274297,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.640905,
      NULL,
      NULL,
      3.409678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702741,
      NULL,
      1.984982,
      1,
      0.180811,
      0.933875,
      NULL,
      1.021333,
      1,
      1,
      0,
      1.187777,
      1,
      0.948486,
      1,
      0.060986,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432582,
      1,
      1.020137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826780,
      0.442639,
      NULL,
      1.068738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.261655,
      NULL,
      0.481396,
      NULL,
      1.024249,
      0,
      1,
      0.906469,
      1.785214,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1.154989,
      1.089177,
      0,
      1.581470,
      0.015811,
      0.321728,
      0,
      0.209561,
      1.288175,
      NULL,
      0.276628,
      NULL,
      0.356172,
      NULL,
      0.256725,
      1.860304,
      0.136102,
      0.804253,
      0.196083,
      1.570733,
      1.375254,
      1,
      1,
      1.812813,
      1.949274,
      1.421940,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602496,
      NULL,
      1.482386,
      1.309002,
      0.842547,
      NULL,
      NULL,
      1.889716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.140007,
      1.697060,
      0,
      1.774483,
      1.429458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484663,
      0,
      0.132049,
      0.259615,
      1,
      NULL,
      1.578692,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.405762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.211647,
      0.322796,
      1.449602,
      0.813332,
      0,
      1,
      0.364573,
      NULL,
      3.530187,
      1.359191,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.527487,
      1,
      NULL,
      4.968723,
      NULL,
      1.573707,
      0,
      2,
      0,
      4.382200,
      NULL,
      1.262137,
      1.307866,
      3.627084,
      NULL,
      0.134151,
      1.457578,
      0,
      1.383851,
      1.818072,
      0.513985,
      NULL,
      NULL,
      0.855329,
      NULL,
      0.395954,
      0,
      0,
      NULL,
      0,
      11,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.832990,
      1.988946,
      7,
      NULL,
      3.872449,
      3,
      57,
      0,
      0.292386,
      91,
      NULL,
      NULL,
      NULL,
      1.033393,
      2,
      3,
      NULL,
      '',
      NULL,
      1.257208,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      2,
      7,
      257.606455,
      19,
      1.563878,
      6.081401,
      NULL,
      2,
      0.021256,
      2,
      0,
      0.217617,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.488125,
      1,
      0.567144,
      NULL,
      NULL,
      1.342031,
      NULL,
      NULL,
      1.975496,
      1,
      0.834904,
      0,
      NULL,
      NULL,
      0.443721,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.763533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.970714,
      0,
      1.262288,
      NULL,
      2,
      0.269820,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.771201,
      NULL,
      NULL,
      2.695923,
      NULL,
      0,
      0.516171,
      NULL,
      NULL,
      1,
      0,
      0.565876,
      1,
      2,
      1.220511,
      0.739637,
      0,
      NULL,
      5.214577,
      0.529620,
      0.056974,
      0.183706,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.169625,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.621571,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.728263,
      3,
      1.273725,
      0.001492,
      4.180252,
      6,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.517873,
      0,
      1,
      NULL,
      1.954582,
      3.317039,
      0,
      1.206445,
      1,
      3.071198,
      1,
      2,
      2.150118,
      NULL,
      2.028267,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      2,
      0.468459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.661557,
      3,
      1,
      1.935157,
      8,
      NULL,
      NULL,
      8.087121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.779024,
      NULL,
      NULL,
      2.647014,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.034901,
      NULL,
      0.466042,
      2.120926,
      2.003632,
      NULL,
      NULL,
      0,
      0,
      2.297016,
      NULL,
      NULL,
      NULL,
      6.080291,
      NULL,
      NULL,
      NULL,
      2.053900,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198847,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.176505,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.019279,
      NULL,
      NULL,
      NULL,
      1.100305,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      9.273503,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.265688,
      NULL,
      6,
      1.680027,
      97,
      6.479143,
      NULL,
      NULL,
      NULL,
      2.470572,
      0.603279,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.727850,
      95.256171,
      22.657755,
      0.923597,
      1,
      0,
      0,
      NULL,
      1,
      0.919547,
      1.252554,
      1.038585,
      NULL,
      NULL,
      0.256972,
      NULL,
      0,
      NULL,
      1,
      0.145151,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.605365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947629,
      0.133696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801485,
      1.508827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174796,
      1.922789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.619086,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.420374,
      NULL,
      1.264831,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972374,
      1,
      0.308246,
      2.370599,
      1,
      0.697000,
      2,
      1,
      1.989070,
      2,
      3,
      NULL,
      0.179098,
      0,
      0.740188,
      0,
      3,
      1.130509,
      1.200191,
      0,
      0.495716,
      0,
      0,
      NULL,
      3.334234,
      NULL,
      NULL,
      NULL,
      0.119181,
      1.689213,
      NULL,
      1.650850,
      0.116040,
      0.065389,
      1,
      0.059768,
      0.039085,
      NULL,
      0,
      1.359050,
      0,
      1,
      0.553340,
      1,
      1.445493,
      1.548669,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081143,
      0,
      0.440428,
      1.753318,
      1.626861,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      115.262742,
      149.870662,
      1,
      3.151267,
      NULL,
      '40143',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


