set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8112687';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4220432',
      0.285700,
      0,
      1,
      1,
      '2210',
      1.205751,
      1.893909,
      NULL,
      NULL,
      ' 8-23-1976',
      7,
      NULL,
      NULL,
      3,
      0.575951,
      '10- 4-1980',
      NULL,
      2.487508,
      79.524176,
      39,
      2,
      ' 9-11-1984',
      ' 8-16-1974',
      ' 4-13-1974',
      NULL,
      3.723192,
      3.507043,
      NULL,
      1,
      0,
      1.551342,
      1.144306,
      NULL,
      NULL,
      5,
      4,
      3.417422,
      NULL,
      26.438210,
      NULL,
      25,
      0,
      1,
      5.489965,
      NULL,
      NULL,
      1.074851,
      0,
      0,
      1,
      1.357961,
      0,
      NULL,
      NULL,
      0.040437,
      3,
      3,
      4.197168,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      0.723735,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.962170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037239,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931803,
      3,
      0,
      0.450666,
      1,
      1,
      1.684155,
      0.408522,
      0.686623,
      0,
      1,
      NULL,
      0,
      0.066959,
      1.277206,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.389002,
      1.172130,
      5,
      1.296578,
      1,
      7,
      1,
      1,
      2.096209,
      2.844102,
      NULL,
      0.028811,
      1,
      1.767206,
      0,
      1,
      6,
      5,
      10.690750,
      9,
      1,
      2.271173,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000681,
      1.502676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853001,
      NULL,
      0.920174,
      1.673902,
      NULL,
      1.423766,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782702,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.482218,
      7,
      3.134155,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1.441780,
      55.675621,
      1.910917,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.651769,
      2,
      NULL,
      3,
      2,
      NULL,
      1.369857,
      NULL,
      0.220125,
      1.372916,
      3.274668,
      1.125652,
      3.594116,
      NULL,
      0,
      0.665862,
      0,
      0.810097,
      0.680676,
      1,
      1,
      1.262326,
      1.172542,
      0.237394,
      1,
      0.502609,
      1.745328,
      1,
      NULL,
      0.492954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      30,
      43,
      19,
      NULL,
      0,
      2,
      '01023',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      0.803796,
      '',
      '',
      '',
      3.887759,
      24,
      105,
      4,
      1.165686,
      15,
      1,
      1,
      0.194093,
      1.225670,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.119400,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.015047,
      NULL,
      NULL,
      0.815783,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.542508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.382363,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.474153,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.086643,
      NULL,
      NULL,
      1.915692,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684079,
      NULL,
      NULL,
      0.086718,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.135073,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.590785,
      3.935759,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.984864,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.605693,
      NULL,
      NULL,
      1.408822,
      NULL,
      NULL,
      1.201092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.987668,
      2,
      NULL,
      0,
      NULL,
      NULL,
      6.205761,
      3.714728,
      NULL,
      NULL,
      4.608273,
      9.282401,
      3,
      4,
      0,
      2.768683,
      0.220464,
      0,
      0.851489,
      2,
      1,
      2.260157,
      1.514758,
      2,
      6,
      2.375081,
      1,
      0,
      1.290168,
      NULL,
      3,
      2,
      NULL,
      2,
      2,
      0,
      3.955336,
      2,
      NULL,
      1,
      6,
      NULL,
      2.199677,
      0,
      3,
      3.706321,
      7.052179,
      6.515650,
      0.659964,
      NULL,
      NULL,
      NULL,
      1.685111,
      1.564559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446836,
      NULL,
      NULL,
      0.442479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.451633,
      NULL,
      NULL,
      0.745596,
      NULL,
      NULL,
      1.643441,
      NULL,
      NULL,
      3.766587,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0.479214,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749277,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.690080,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.644607,
      NULL,
      NULL,
      0.800311,
      NULL,
      NULL,
      0.666489,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.040612,
      NULL,
      NULL,
      0,
      NULL,
      0,
      59.076865,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.471989,
      NULL,
      NULL,
      1.810334,
      NULL,
      0,
      0,
      NULL,
      1,
      0.890469,
      0.557422,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165862,
      1,
      NULL,
      0.682027,
      NULL,
      0.918230,
      NULL,
      3,
      NULL,
      2.669885,
      3,
      0.986007,
      0.265219,
      1.294471,
      1.043702,
      0,
      0.948599,
      1.163781,
      0,
      1,
      0,
      1,
      0,
      1.317320,
      1.120860,
      0,
      0.999193,
      1,
      0,
      1,
      1.952915,
      0,
      3.672995,
      0.136822,
      1.460882,
      3,
      1.415887,
      0.431606,
      0.197079,
      0.873912,
      1.722898,
      2,
      1.088405,
      1,
      1,
      0.570460,
      2.706689,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141812,
      0,
      1.271065,
      0.186904,
      0.886291,
      2.598298,
      2,
      8.094566,
      0.723678,
      0.015495,
      1.530445,
      21,
      NULL,
      3,
      1.740072,
      3.961060,
      '30204',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


