set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7211810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      '2410',
      0,
      NULL,
      NULL,
      NULL,
      ' 5-18-1979',
      40.606012,
      NULL,
      2,
      1,
      1,
      '11- 1-1994',
      9.312409,
      2.863605,
      NULL,
      NULL,
      2.596018,
      NULL,
      NULL,
      ' 9-15-1991',
      0.304292,
      0,
      NULL,
      2.194146,
      0,
      1.101027,
      2,
      0.962045,
      0,
      58.258829,
      0,
      19,
      0.568359,
      20,
      18.079197,
      4,
      NULL,
      0,
      NULL,
      4,
      0,
      0.600509,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.327425,
      0.757416,
      5.588128,
      1,
      8,
      1,
      5.461221,
      1,
      NULL,
      0.502744,
      0.154812,
      NULL,
      1,
      0.206343,
      NULL,
      0.643647,
      0,
      0,
      7.526543,
      1,
      1.468814,
      NULL,
      0.254662,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.665258,
      0.020265,
      0.208646,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.024925,
      0.193826,
      NULL,
      NULL,
      0.648458,
      1,
      2.078622,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.348405,
      0.968421,
      1,
      7.691381,
      0.228373,
      2.792689,
      0.775819,
      0,
      1.033540,
      NULL,
      NULL,
      1.801714,
      3,
      0.469697,
      1.813420,
      1,
      1.446683,
      0,
      NULL,
      0,
      4,
      0,
      1.038885,
      6.366173,
      0.885253,
      NULL,
      1,
      0.012763,
      5.302509,
      3.511447,
      2.536556,
      NULL,
      NULL,
      1.278466,
      1.048393,
      7.685305,
      NULL,
      7.105990,
      1.316311,
      1,
      0,
      10,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      373.983139,
      NULL,
      243,
      3.976999,
      1.459468,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586028,
      1,
      0,
      0,
      0,
      0,
      0,
      1.886340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.242726,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.830755,
      NULL,
      0.589374,
      NULL,
      NULL,
      NULL,
      9.328377,
      NULL,
      3.130190,
      NULL,
      1.349192,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.840794,
      NULL,
      0.608133,
      NULL,
      1,
      0.957164,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      3,
      2.058363,
      1,
      1.805999,
      NULL,
      2.257732,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.558918,
      NULL,
      0,
      NULL,
      0,
      0.609576,
      0,
      2.438660,
      1.138845,
      0,
      3.112498,
      1,
      0.918519,
      0.952509,
      NULL,
      8,
      5.418743,
      3,
      4,
      0.819315,
      5,
      3,
      NULL,
      3.878814,
      0,
      1,
      29,
      1.407916,
      0,
      31,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      '',
      '',
      '',
      1,
      '20044',
      '',
      '',
      0.117580,
      NULL,
      '',
      '',
      1,
      42,
      114.783245,
      10,
      1.508069,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500885,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.052540,
      1,
      0,
      1.425843,
      1.844294,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.900624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.280656,
      NULL,
      NULL,
      0.635787,
      1,
      2.585732,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.119027,
      3.001883,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.892691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.543270,
      0.916081,
      NULL,
      NULL,
      0.207860,
      0,
      1,
      5,
      3.352351,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.386632,
      NULL,
      NULL,
      1.280810,
      NULL,
      NULL,
      3,
      0.572474,
      3.666581,
      1.428924,
      NULL,
      NULL,
      3.783558,
      1.947556,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.960110,
      NULL,
      NULL,
      0.541933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233168,
      NULL,
      NULL,
      1.881633,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.537922,
      NULL,
      NULL,
      0,
      0.874351,
      3,
      0.897813,
      NULL,
      NULL,
      2.094932,
      NULL,
      1,
      2,
      5,
      0.418281,
      3,
      4.066159,
      1.182553,
      NULL,
      2.643597,
      0.841014,
      3,
      3.961288,
      1.031956,
      0,
      1,
      1.673516,
      6,
      2,
      4,
      2.838185,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.221947,
      0,
      1.854733,
      5.664479,
      7,
      1,
      5,
      NULL,
      3.163689,
      0,
      3.964033,
      4,
      0.894550,
      0,
      1.664048,
      1.235882,
      1.876423,
      NULL,
      NULL,
      NULL,
      0.741592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642367,
      NULL,
      NULL,
      0.455671,
      NULL,
      NULL,
      0.183384,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.410907,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.654025,
      1.184529,
      0,
      1.981346,
      3,
      NULL,
      NULL,
      NULL,
      5.834673,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.247041,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.837065,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.176914,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.951502,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.898929,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.114082,
      NULL,
      NULL,
      1.793136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.050589,
      NULL,
      1,
      541,
      0,
      0.414516,
      1,
      1.140424,
      2.862179,
      NULL,
      1.669692,
      0,
      NULL,
      1.367554,
      2,
      NULL,
      NULL,
      0,
      1.182711,
      0.469998,
      0.798324,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3.742941,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.028408,
      NULL,
      112.622956,
      NULL,
      0.737351,
      2.261747,
      25.919263,
      1.042552,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.058651,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.072400,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.599371,
      NULL,
      0.226595,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.856917,
      1.251621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.359921,
      2,
      NULL,
      4,
      NULL,
      0.258465,
      0,
      4,
      8,
      1,
      NULL,
      1,
      0.020594,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.797210,
      3,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      2,
      NULL,
      0,
      3,
      NULL,
      1,
      0.550091,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.150249,
      1.902274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.494467,
      NULL,
      1,
      NULL,
      NULL,
      0.371034,
      NULL,
      NULL,
      1,
      2,
      14.191090,
      92.161703,
      4,
      1.854229,
      0,
      '12001',
      '10120',
      NULL,
      3,
      '33321',
      NULL,
      '',
      0.789198,
      '',
      '',
      '');
commit;
end;
/


