set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6.661995,
      0.718643,
      NULL,
      3.702027,
      0,
      0.499754,
      2.667043,
      1,
      '222',
      '20320001',
      71,
      24.014762,
      '3000333',
      4,
      1,
      1,
      0,
      '4333',
      3,
      NULL,
      NULL,
      NULL,
      ' 4-19-1980',
      30.194674,
      108,
      NULL,
      1.273444,
      0,
      ' 1-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '11-14-1981',
      ' 7-28-1988',
      ' 0-16-1993',
      1,
      2,
      3,
      0,
      0.625293,
      2,
      NULL,
      0.305669,
      NULL,
      10,
      9,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.811796,
      3.019170,
      2,
      2.203205,
      7,
      NULL,
      0,
      1,
      0,
      1,
      6.517990,
      1,
      0,
      3.149801,
      2,
      1.545142,
      9.244421,
      1.321847,
      0.989579,
      3,
      3.112343,
      NULL,
      NULL,
      NULL,
      0.065068,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526682,
      NULL,
      1.967478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.993387,
      0,
      NULL,
      1.333043,
      0.952385,
      0,
      1,
      1.712703,
      NULL,
      1.207936,
      NULL,
      2,
      0,
      NULL,
      0,
      1.684214,
      1.032385,
      NULL,
      1,
      2.722725,
      4,
      1,
      1,
      NULL,
      7,
      1,
      0,
      NULL,
      1.339035,
      1.770843,
      0,
      1,
      7.715337,
      8,
      NULL,
      0.157580,
      7,
      4.648355,
      2,
      7.300598,
      0.824768,
      8.755075,
      NULL,
      3,
      NULL,
      2,
      ' 5-27-1995',
      37,
      ' 7-22-1986',
      139,
      NULL,
      0,
      NULL,
      7,
      1.525819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.649379,
      1.534308,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      2,
      2.194168,
      2.734086,
      1.036760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786361,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.575024,
      NULL,
      7,
      5.566489,
      0.531544,
      NULL,
      NULL,
      2,
      3.390196,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355927,
      0.012753,
      1,
      0.171581,
      1,
      0,
      0,
      0.975675,
      58.198359,
      0.851673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.460347,
      1.022416,
      3.810714,
      0.715348,
      3,
      1,
      2,
      1.679344,
      NULL,
      1.752368,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.334264,
      NULL,
      0,
      1,
      0.403810,
      1.921039,
      1,
      NULL,
      NULL,
      0.827304,
      0,
      NULL,
      NULL,
      4.744129,
      8,
      0.837662,
      4.861606,
      NULL,
      5.881406,
      NULL,
      2.218073,
      7.518882,
      2,
      0.021727,
      2,
      55,
      2,
      NULL,
      45.769235,
      NULL,
      45,
      9.369511,
      NULL,
      1.682742,
      0,
      '03141',
      '',
      '',
      1.311286,
      '',
      '',
      '',
      0.554562,
      '',
      '',
      '',
      NULL,
      NULL,
      40.122363,
      6,
      0,
      6.332510,
      9.132255,
      3,
      3.182316,
      NULL,
      1.205251,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.858313,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.560110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.377974,
      NULL,
      NULL,
      0.903715,
      NULL,
      NULL,
      10,
      7,
      1.347366,
      1,
      1.913987,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.767800,
      NULL,
      1.496080,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      3.233957,
      1.574013,
      NULL,
      3,
      1.849309,
      1.538534,
      0,
      1.629701,
      NULL,
      1.815133,
      2.883284,
      2.462885,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7.641517,
      1,
      0.321642,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.959299,
      1,
      NULL,
      1.412099,
      NULL,
      NULL,
      NULL,
      1.735783,
      2.992990,
      0,
      NULL,
      NULL,
      4.205917,
      NULL,
      3.972204,
      NULL,
      0,
      1,
      1.151394,
      NULL,
      NULL,
      5,
      1.714024,
      1.586791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041853,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.366238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3.602034,
      2,
      2,
      1,
      7.071819,
      2,
      5,
      6,
      5.328335,
      1,
      0,
      7,
      NULL,
      3.062825,
      1.263904,
      NULL,
      1,
      0,
      2,
      1.661059,
      2.944320,
      2,
      9.256889,
      9.392959,
      4,
      1.485522,
      2,
      0.095300,
      3,
      NULL,
      1.810546,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2,
      5,
      4,
      6,
      6.975527,
      4,
      1.311227,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.807417,
      NULL,
      NULL,
      0.025946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.540377,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.788377,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.826518,
      NULL,
      NULL,
      1.256393,
      NULL,
      NULL,
      2.306864,
      NULL,
      NULL,
      1,
      1.003735,
      1,
      0.778362,
      1,
      2.239445,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.695644,
      NULL,
      NULL,
      NULL,
      1.419383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381833,
      NULL,
      NULL,
      NULL,
      0.521995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.885214,
      NULL,
      NULL,
      NULL,
      0.788482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.411774,
      NULL,
      NULL,
      NULL,
      1.706747,
      NULL,
      NULL,
      NULL,
      0,
      1.522167,
      3,
      0,
      2.587012,
      1.589635,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.168846,
      0,
      NULL,
      NULL,
      0.460963,
      NULL,
      NULL,
      0.307258,
      NULL,
      0.672623,
      174,
      1,
      1.737013,
      NULL,
      1.288861,
      1,
      0,
      NULL,
      NULL,
      1.245449,
      0.202287,
      0,
      1.265159,
      NULL,
      NULL,
      1,
      0.073294,
      1.550935,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886202,
      0.414133,
      1.873668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372301,
      0.588764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081547,
      0.386743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254889,
      2,
      NULL,
      1,
      NULL,
      1.301099,
      NULL,
      76.853347,
      NULL,
      0.861471,
      NULL,
      2.617759,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      25,
      2.183299,
      0.730091,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      0.384588,
      1,
      4.121077,
      NULL,
      3.439689,
      3.685392,
      2.181857,
      NULL,
      1,
      1,
      NULL,
      0.575787,
      NULL,
      NULL,
      0.355739,
      0.943887,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1.723429,
      0,
      NULL,
      1.662908,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.217609,
      0,
      NULL,
      1,
      1,
      NULL,
      0.809557,
      0.268730,
      NULL,
      3.907765,
      0.231686,
      1.110641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716110,
      NULL,
      0,
      NULL,
      0,
      NULL,
      6,
      13.821427,
      11.978514,
      2,
      1.378419,
      3,
      25.276134,
      12.918047,
      1,
      1.196206,
      7,
      '23100',
      '22440',
      '03113',
      1.467630,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


