set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015749';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      3,
      NULL,
      2,
      1.049508,
      NULL,
      NULL,
      NULL,
      0.729171,
      NULL,
      3.968576,
      1.439762,
      1.811719,
      ' 5-14-1984',
      NULL,
      0.572337,
      NULL,
      140.233036,
      2,
      '10-10-1979',
      NULL,
      ' 1- 4-1976',
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.016131,
      0.047619,
      NULL,
      1,
      8,
      14.024803,
      9.470787,
      1.190386,
      NULL,
      4,
      NULL,
      NULL,
      4,
      9.623861,
      3.048153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.781238,
      2.096564,
      NULL,
      3,
      0.207260,
      1,
      2,
      NULL,
      NULL,
      NULL,
      4.826827,
      0,
      0,
      7.570786,
      1.008162,
      0.759939,
      1.332790,
      1.246336,
      2.423599,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.816514,
      1,
      NULL,
      0.888648,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028754,
      1.994272,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382467,
      NULL,
      0,
      NULL,
      0.412827,
      0,
      0,
      0,
      NULL,
      1.203398,
      0.291307,
      1,
      0.979817,
      NULL,
      NULL,
      0.854067,
      0,
      NULL,
      1.910690,
      NULL,
      2,
      NULL,
      2.375453,
      NULL,
      2,
      NULL,
      4,
      NULL,
      5,
      0.492257,
      5,
      NULL,
      1,
      1,
      7.457496,
      4,
      3,
      NULL,
      0,
      1.887149,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      ' 4- 2-1978',
      13,
      ' 0-24-1992',
      2,
      NULL,
      1.424594,
      1.572337,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857762,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1.516114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      21.205028,
      1,
      NULL,
      4.921239,
      1.343282,
      0.572878,
      1.664444,
      1,
      NULL,
      6,
      1,
      1,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      8.345781,
      0.815502,
      NULL,
      0.254458,
      NULL,
      NULL,
      1,
      9.779143,
      0.702123,
      NULL,
      3.989040,
      0,
      4.788019,
      NULL,
      4.320499,
      ' 7-19-1993',
      10.962086,
      0.818413,
      0,
      1,
      1.578764,
      0.902671,
      NULL,
      0.690487,
      0,
      1,
      0,
      0.631022,
      9.457455,
      1.051668,
      1,
      NULL,
      NULL,
      NULL,
      0.036084,
      1.789611,
      1.484904,
      3,
      3,
      0,
      0,
      NULL,
      2.115894,
      3.635700,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.001792,
      1,
      2,
      1.710561,
      1.560653,
      0.909486,
      0,
      0.882908,
      1.680063,
      0,
      0,
      NULL,
      1.286489,
      2,
      1.397739,
      0.798833,
      7.839615,
      7,
      5,
      11.414760,
      5,
      2,
      0.440805,
      NULL,
      0,
      2.508985,
      1.432854,
      NULL,
      0.301670,
      2,
      NULL,
      40.426186,
      78,
      98.629035,
      1,
      0,
      3,
      '10304',
      '21433',
      '',
      0.454548,
      '31122',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      2,
      6.291163,
      189.724105,
      0,
      1,
      NULL,
      6,
      2.792300,
      0,
      3.586527,
      0.301090,
      1.309451,
      NULL,
      NULL,
      NULL,
      3.889508,
      3,
      1,
      1.934195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173972,
      1.006538,
      1.584424,
      1.044183,
      NULL,
      NULL,
      1.112206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335655,
      NULL,
      1,
      NULL,
      0.547793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997918,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.525556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073658,
      NULL,
      NULL,
      0.922305,
      NULL,
      NULL,
      0.520215,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965672,
      1,
      0.813157,
      3,
      0,
      0.316602,
      3,
      0,
      0,
      5.595655,
      0,
      1,
      1,
      NULL,
      NULL,
      1.428860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.925487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3.428688,
      0,
      0.473663,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.043915,
      NULL,
      NULL,
      2.008343,
      0,
      0.226561,
      0,
      NULL,
      0.016250,
      NULL,
      0.149856,
      NULL,
      0.921631,
      1.759197,
      1,
      0.203908,
      1,
      0,
      1,
      NULL,
      1.185127,
      1,
      NULL,
      1,
      7,
      NULL,
      2.517164,
      4,
      1.586314,
      1,
      1.761385,
      0.149254,
      7.751642,
      1.621353,
      1,
      NULL,
      1,
      0.919880,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.941781,
      NULL,
      NULL,
      3.827314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.977832,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      22.341312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235703,
      NULL,
      NULL,
      NULL,
      0.464250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800644,
      0,
      NULL,
      NULL,
      0.176560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.234249,
      NULL,
      NULL,
      0.071445,
      3.575390,
      NULL,
      NULL,
      0.382579,
      1.093663,
      NULL,
      NULL,
      NULL,
      1.185668,
      NULL,
      NULL,
      3,
      1.653500,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      3.178125,
      NULL,
      NULL,
      1.972446,
      0.742020,
      3,
      1,
      2,
      9.079654,
      2,
      0.591305,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.695399,
      NULL,
      NULL,
      3.489955,
      11.968064,
      NULL,
      0,
      NULL,
      NULL,
      0.620594,
      NULL,
      1,
      NULL,
      2.382154,
      0.063175,
      0.455195,
      1,
      1.494644,
      0.411553,
      NULL,
      1.329666,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.906085,
      0,
      0.537581,
      NULL,
      0.062124,
      3.409581,
      NULL,
      NULL,
      NULL,
      2.144774,
      NULL,
      0,
      NULL,
      0.141755,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.724115,
      25,
      23.378120,
      0.278180,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.158651,
      NULL,
      NULL,
      NULL,
      0.184206,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.157742,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.458389,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.563918,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.797582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363756,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208942,
      1.113719,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.811814,
      NULL,
      1,
      NULL,
      1.132422,
      NULL,
      0,
      0.006717,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333885,
      1.279244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.791942,
      NULL,
      1.980317,
      NULL,
      NULL,
      1.083510,
      1.780282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441507,
      NULL,
      3,
      NULL,
      2,
      2,
      2,
      4.222904,
      NULL,
      0,
      3.525906,
      2,
      0,
      1,
      1,
      0.856149,
      3,
      0.846972,
      2.807526,
      3.905778,
      0,
      NULL,
      NULL,
      0.115485,
      0,
      NULL,
      1,
      1.221812,
      0,
      1,
      3,
      NULL,
      0,
      NULL,
      1.725687,
      NULL,
      1.529513,
      0,
      1,
      0,
      0.926474,
      0.694216,
      0,
      NULL,
      1.669721,
      2,
      2.866350,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.931120,
      0.747942,
      2,
      0.130671,
      0,
      1.260959,
      NULL,
      NULL,
      0.929583,
      2.874724,
      1.661975,
      1.636492,
      1.344251,
      NULL,
      0.021489,
      1.253285,
      1.250681,
      1.904029,
      NULL,
      0.023365,
      0,
      NULL,
      0,
      7,
      NULL,
      1667,
      NULL,
      NULL,
      1,
      1.288954,
      1.067598,
      1.357892,
      3.723744,
      5,
      NULL,
      1,
      NULL,
      NULL,
      43,
      9.827799,
      2.904270,
      0,
      5,
      NULL,
      '43102',
      '',
      1.720284,
      '03342',
      '',
      '',
      0.761517,
      '',
      '',
      '');
commit;
end;
/


