set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9675175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      '33',
      NULL,
      1.072076,
      '3041000',
      2.348064,
      NULL,
      0,
      1,
      '1444',
      5.614580,
      1.450892,
      NULL,
      NULL,
      ' 9- 8-2001',
      166.565184,
      3,
      NULL,
      0,
      1,
      ' 3- 0-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 0-15-1976',
      '10-19-1980',
      NULL,
      2,
      2.558183,
      0.193382,
      1.569954,
      1.013732,
      NULL,
      NULL,
      1.353696,
      4.889007,
      1.511681,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.589980,
      1,
      NULL,
      1,
      0,
      1.999721,
      1.960097,
      NULL,
      0.546051,
      1,
      1.870602,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      2.292518,
      0.711254,
      NULL,
      1.592335,
      0.488613,
      2,
      7.375643,
      2.084088,
      0,
      0,
      NULL,
      0.418339,
      0.574484,
      1,
      0,
      1,
      1.015433,
      1.517419,
      NULL,
      NULL,
      0.948111,
      NULL,
      NULL,
      NULL,
      0.998159,
      NULL,
      2.347424,
      0.439740,
      0.108781,
      NULL,
      1,
      2.506407,
      0.976387,
      3,
      0.770404,
      1,
      1,
      1,
      1.689656,
      0.763129,
      0,
      3.920373,
      1.642307,
      1,
      5,
      7.553343,
      1.093498,
      1.583021,
      1.648802,
      0.712159,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.139966,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.036366,
      NULL,
      1,
      1,
      NULL,
      0,
      6.137971,
      1,
      1.780883,
      0.569533,
      0.379239,
      NULL,
      NULL,
      1.542025,
      NULL,
      1,
      3,
      0,
      1,
      1.191089,
      2.863822,
      0.133474,
      1.242418,
      3.359216,
      0.153231,
      NULL,
      4.369778,
      6,
      2,
      2.897266,
      NULL,
      NULL,
      2,
      NULL,
      5,
      NULL,
      7,
      5.182840,
      3,
      3.999271,
      2,
      ' 9- 1-1976',
      710,
      ' 1-14-1978',
      3,
      0,
      0.095034,
      0.011710,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.351146,
      0,
      0,
      0,
      0.733332,
      0.961061,
      1.566013,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.926129,
      NULL,
      3.619312,
      3,
      NULL,
      0.133755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.746323,
      1,
      2.614228,
      NULL,
      1.617453,
      4.270308,
      1,
      5,
      3.196664,
      0.570349,
      2,
      0.951545,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390824,
      1.928430,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      76,
      0.476549,
      0.489857,
      NULL,
      NULL,
      NULL,
      1.257257,
      1.244636,
      NULL,
      0.163062,
      1.831999,
      3.702503,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.086823,
      3.943184,
      NULL,
      1,
      0.790700,
      NULL,
      1.328073,
      0,
      0.827259,
      0,
      1.554756,
      1.593844,
      0.891397,
      1,
      1.646747,
      0,
      NULL,
      0.783252,
      0.810046,
      6,
      1.601776,
      4,
      2,
      6,
      NULL,
      2.340763,
      1,
      3,
      1.420553,
      NULL,
      35,
      0.710358,
      NULL,
      24,
      NULL,
      38,
      36.922326,
      4,
      NULL,
      0,
      NULL,
      '',
      NULL,
      1.229371,
      '30040',
      '',
      '',
      0.323379,
      '',
      '',
      '',
      2.558348,
      31,
      65.653525,
      31,
      3,
      NULL,
      5,
      5,
      3.724262,
      NULL,
      3.593546,
      NULL,
      0.747452,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.938151,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.979600,
      3,
      3.306874,
      NULL,
      0,
      0.548593,
      0.845356,
      0,
      2.620262,
      NULL,
      1.390907,
      3.998838,
      0.310899,
      1.763040,
      0.514331,
      0,
      0,
      3,
      0,
      1,
      7,
      1,
      NULL,
      NULL,
      0.713614,
      NULL,
      NULL,
      NULL,
      1.268046,
      NULL,
      NULL,
      NULL,
      1.836502,
      1,
      1,
      2.479361,
      1.576642,
      1,
      NULL,
      0.800185,
      0.905625,
      0.650235,
      0.206734,
      1,
      2.472927,
      0,
      NULL,
      0.440396,
      NULL,
      NULL,
      NULL,
      1.948842,
      1.854960,
      0.506556,
      1.918351,
      1.014653,
      3,
      NULL,
      1,
      0.582718,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      5.802005,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.842388,
      1,
      1,
      3,
      0,
      1.123156,
      2,
      NULL,
      0,
      0.538459,
      NULL,
      NULL,
      NULL,
      1.989124,
      NULL,
      NULL,
      0.495618,
      NULL,
      1.137275,
      NULL,
      NULL,
      0.223776,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.294222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1.622501,
      0.300129,
      3.038745,
      0,
      0.085797,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.293167,
      1.631618,
      0,
      3.387261,
      1,
      1,
      0,
      0.396865,
      0.446716,
      0,
      2.288524,
      0,
      1,
      1,
      4,
      2.289000,
      2,
      0.536593,
      1.256067,
      0,
      0.491661,
      NULL,
      NULL,
      0,
      3.124055,
      NULL,
      3.254115,
      NULL,
      NULL,
      NULL,
      0.022594,
      1.292053,
      1,
      NULL,
      2,
      2.357034,
      0.917519,
      7.381828,
      1,
      1.015114,
      NULL,
      0,
      NULL,
      3.868452,
      NULL,
      NULL,
      0.276523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.796761,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.745688,
      NULL,
      NULL,
      1.528160,
      NULL,
      NULL,
      0.757868,
      NULL,
      NULL,
      3.448511,
      NULL,
      NULL,
      5.360277,
      NULL,
      NULL,
      1,
      1.239859,
      1,
      0,
      0.312516,
      3.310392,
      3,
      NULL,
      NULL,
      0,
      0.354564,
      NULL,
      NULL,
      6.046130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557907,
      NULL,
      NULL,
      NULL,
      0.176573,
      0.788827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.213492,
      1.239440,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.367259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.345317,
      1.943154,
      NULL,
      NULL,
      0.789651,
      0.237560,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3.427224,
      1.179050,
      NULL,
      NULL,
      2.279043,
      3.313093,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5,
      3,
      NULL,
      NULL,
      0.719803,
      NULL,
      5.661594,
      1,
      3,
      6.215958,
      0.651585,
      3.333408,
      0.931569,
      0,
      0,
      NULL,
      NULL,
      3.382352,
      1.208761,
      1.232317,
      NULL,
      NULL,
      NULL,
      0.431562,
      NULL,
      NULL,
      0.229230,
      NULL,
      1.043404,
      363,
      10.530558,
      1.987254,
      1,
      0,
      0,
      1.584610,
      NULL,
      NULL,
      0.419661,
      1,
      1.015082,
      1.142955,
      1.036966,
      NULL,
      NULL,
      0.238705,
      0.648095,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.519777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.257334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084531,
      3,
      NULL,
      0.603686,
      NULL,
      0.965055,
      NULL,
      NULL,
      NULL,
      1.635840,
      NULL,
      0.878376,
      NULL,
      NULL,
      NULL,
      0.424920,
      NULL,
      0.509334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664774,
      1.947850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235529,
      NULL,
      0.825697,
      NULL,
      0,
      NULL,
      1.295589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.177164,
      1.823349,
      4.343750,
      0,
      1.278180,
      0,
      1.261316,
      2,
      0.191027,
      NULL,
      0.154232,
      NULL,
      1.679870,
      1,
      1.480150,
      NULL,
      0,
      3,
      0.169646,
      3,
      1.565575,
      1.834781,
      1.876215,
      1,
      NULL,
      NULL,
      0.064921,
      NULL,
      3,
      0.153953,
      1,
      NULL,
      NULL,
      NULL,
      1.349743,
      NULL,
      NULL,
      0,
      1,
      1.063918,
      NULL,
      1.862623,
      NULL,
      0.915379,
      NULL,
      3.761851,
      0.536046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978746,
      1.293063,
      1,
      1,
      0.785277,
      3.891708,
      6,
      5,
      1,
      NULL,
      NULL,
      3.498434,
      89,
      1.057005,
      3,
      0.199178,
      NULL,
      '',
      '',
      2,
      '01214',
      '',
      '',
      0.351554,
      '',
      '',
      '');
commit;
end;
/


