set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9019484';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.926148,
      3,
      3.010405,
      8.764297,
      5,
      1.562586,
      5,
      1,
      NULL,
      NULL,
      26,
      21.318728,
      '1204013',
      3,
      0,
      1,
      NULL,
      '0222',
      4.482250,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.883848,
      ' 6- 9-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-13-1997',
      ' 0- 3-1975',
      NULL,
      0,
      NULL,
      0.596673,
      0.379717,
      1,
      2.617306,
      1.082570,
      0,
      8.255702,
      NULL,
      15.011334,
      8.270315,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.024589,
      0,
      0.851762,
      NULL,
      1.949890,
      1.697922,
      0.938612,
      1,
      NULL,
      1,
      0,
      6.458369,
      10,
      1,
      NULL,
      1,
      1.851687,
      11,
      NULL,
      NULL,
      11.447369,
      0.452857,
      3.483474,
      7,
      3.908520,
      3,
      8.610497,
      1.026598,
      2,
      1.945625,
      3,
      0,
      NULL,
      NULL,
      1.738687,
      NULL,
      NULL,
      0.303181,
      NULL,
      5.193283,
      NULL,
      2.669277,
      0,
      NULL,
      0,
      3,
      0.021371,
      0.683447,
      1.556926,
      2,
      0.518390,
      1,
      1.622358,
      0,
      0,
      2,
      4,
      NULL,
      1,
      10,
      NULL,
      2.103462,
      0.722090,
      1.260268,
      NULL,
      NULL,
      0.418786,
      NULL,
      NULL,
      NULL,
      3.136565,
      8.210665,
      0.957285,
      NULL,
      4,
      1,
      0.585768,
      NULL,
      1,
      NULL,
      2.041488,
      1.096547,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      3,
      1.655234,
      1,
      NULL,
      3,
      7.788698,
      2,
      2.625077,
      8.909302,
      NULL,
      0.768752,
      0,
      1,
      NULL,
      NULL,
      0.725514,
      1.670557,
      6,
      2,
      9.840588,
      NULL,
      6.320542,
      1.729669,
      1,
      0,
      0.292319,
      ' 3-16-1986',
      45,
      ' 3-24-1996',
      15,
      0,
      3,
      4,
      3.330095,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602989,
      1,
      NULL,
      0,
      NULL,
      1.195248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      3,
      1.743886,
      2.323526,
      4,
      NULL,
      5.385502,
      5,
      NULL,
      2,
      0.704766,
      NULL,
      NULL,
      NULL,
      NULL,
      5.717587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.005328,
      NULL,
      0.809925,
      0.660916,
      2,
      8.127932,
      1.241313,
      0.566123,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      1.024908,
      2.294635,
      2,
      1,
      1.513232,
      2.149410,
      2,
      0,
      3,
      NULL,
      NULL,
      1.525433,
      2,
      1,
      1.997740,
      1,
      1,
      NULL,
      1.911600,
      0,
      NULL,
      0.896897,
      0.306325,
      1.446636,
      NULL,
      0.635919,
      2,
      1.877545,
      10.382132,
      5.055234,
      6,
      6.429222,
      0,
      1,
      NULL,
      NULL,
      3,
      3,
      3.132671,
      1,
      12.318354,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.265002,
      2,
      '12423',
      '22131',
      '',
      2.535545,
      '1431',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      1,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.515721,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.877433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073985,
      32,
      1,
      0.029459,
      0.146333,
      NULL,
      NULL,
      0,
      0,
      3.676770,
      1,
      3,
      0.021355,
      1,
      0.758419,
      0.176125,
      1,
      1,
      1.873879,
      NULL,
      1.221203,
      0,
      NULL,
      0.679004,
      1,
      1,
      2.209430,
      0,
      3,
      3.996676,
      NULL,
      NULL,
      110.784946,
      1,
      0.438430,
      18,
      NULL,
      1,
      1.531539,
      NULL,
      1.784024,
      0.328390,
      NULL,
      0.827699,
      1.277130,
      0.377725,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1.459202,
      0.159051,
      1.626951,
      1.220865,
      1,
      0.090747,
      NULL,
      0.731725,
      1.114590,
      0.140209,
      1.016479,
      1,
      1.375627,
      1.763836,
      0.221476,
      NULL,
      1.819699,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.524265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      2.230975,
      0.949500,
      9,
      25,
      NULL,
      NULL,
      1.212095,
      1.962558,
      3,
      0,
      3,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.024807,
      NULL,
      40,
      NULL,
      23.458871,
      NULL,
      3.615706,
      NULL,
      0,
      NULL,
      3.127229,
      1,
      2.988061,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.207634,
      NULL,
      3,
      NULL,
      0.800335,
      NULL,
      2.555186,
      2,
      2.797265,
      1.974007,
      1,
      2,
      1.697957,
      2,
      687.589346,
      1.783908,
      3.927004,
      0,
      1.734325,
      2.727621,
      2.245731,
      1.723361,
      1,
      8.057741,
      NULL,
      0.629965,
      NULL,
      1,
      NULL,
      0.832478,
      0,
      0,
      1,
      3.383701,
      1.715204,
      3,
      2.559943,
      3.121006,
      2.210487,
      0.755727,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.292824,
      NULL,
      1,
      0,
      NULL,
      0,
      0.930737,
      NULL,
      1.843556,
      3,
      NULL,
      1,
      0,
      NULL,
      0.644653,
      0.207043,
      NULL,
      1.631488,
      2,
      NULL,
      0,
      1.392809,
      NULL,
      0,
      1.450791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.281592,
      NULL,
      0.718226,
      NULL,
      NULL,
      NULL,
      7.345585,
      2.852910,
      1,
      0,
      36.450648,
      NULL,
      3,
      0.265268,
      2,
      NULL,
      '44424',
      '',
      0,
      '1131',
      '',
      '',
      NULL,
      '1032',
      '',
      '');
commit;
end;
/


