set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736657';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '4444332',
      0.328995,
      0,
      0,
      NULL,
      NULL,
      1.512843,
      1.475991,
      NULL,
      NULL,
      ' 4- 4-1984',
      23,
      NULL,
      1.287157,
      1.449704,
      1,
      NULL,
      34.358692,
      NULL,
      230,
      125.996275,
      3.302521,
      NULL,
      '10-12-1976',
      ' 0- 5-1993',
      1.325656,
      NULL,
      3.903052,
      1,
      NULL,
      NULL,
      1.288775,
      0,
      0,
      NULL,
      4,
      0,
      7.861461,
      51.748951,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2.098492,
      0,
      4,
      1.850338,
      1,
      NULL,
      NULL,
      1.357350,
      0,
      NULL,
      0,
      1,
      4.777673,
      NULL,
      2,
      0,
      0,
      0.840053,
      0.319021,
      NULL,
      1,
      NULL,
      5,
      0.529193,
      0,
      NULL,
      0,
      1.694247,
      4.908644,
      1.638688,
      0.036903,
      0.131123,
      1.359910,
      NULL,
      NULL,
      NULL,
      1.653091,
      NULL,
      NULL,
      2.891305,
      NULL,
      1.789830,
      0.593018,
      1,
      0,
      1.974857,
      0,
      2.895702,
      NULL,
      0.672711,
      0,
      1,
      1.624980,
      2,
      0.152225,
      1,
      1.377620,
      1,
      0.841263,
      1,
      1.185926,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.089833,
      NULL,
      NULL,
      0.881515,
      NULL,
      NULL,
      0.775763,
      3,
      1,
      4,
      3.180997,
      1.520722,
      NULL,
      1.510027,
      1,
      1.273499,
      2.047947,
      1.605775,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      5,
      4.507636,
      NULL,
      3,
      NULL,
      3.298635,
      1,
      0,
      NULL,
      5.182001,
      NULL,
      0,
      3.297227,
      0,
      1.332728,
      2,
      9.399602,
      4,
      4.969569,
      NULL,
      9.278095,
      0,
      3,
      2,
      7,
      NULL,
      1.834739,
      ' 6-29-1982',
      128.344231,
      ' 2-27-2001',
      NULL,
      2.213632,
      0,
      1.178209,
      NULL,
      0.539765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508828,
      0.228025,
      2.414526,
      NULL,
      1.277552,
      1.396907,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9.449212,
      737,
      2,
      1,
      3.622127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.440575,
      2.800733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.342012,
      1,
      1,
      1.040942,
      0,
      0.172351,
      0,
      0.203951,
      12.216294,
      3.303573,
      NULL,
      46.912600,
      NULL,
      69,
      2.861816,
      1.885668,
      3.095871,
      NULL,
      1,
      NULL,
      3.476476,
      3.805378,
      0,
      1,
      1,
      0,
      1.514048,
      1.002003,
      1.546441,
      NULL,
      0,
      NULL,
      NULL,
      7,
      0,
      0,
      1,
      0,
      0,
      1,
      1.798548,
      0,
      1.063411,
      0.546350,
      1.963058,
      0.404058,
      0.889947,
      NULL,
      6.778452,
      11.131323,
      0.358245,
      NULL,
      3,
      0,
      5,
      0,
      2,
      1,
      23.330041,
      2,
      0,
      NULL,
      NULL,
      25,
      37.374326,
      1,
      0,
      2.579770,
      NULL,
      '44344',
      '13411',
      0,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1.534114,
      5.655090,
      NULL,
      37.947487,
      0.555475,
      3.103309,
      12,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224517,
      NULL,
      NULL,
      1.529374,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.529721,
      NULL,
      NULL,
      0.091647,
      1.484657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837939,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      0,
      1.552259,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.861498,
      3.469735,
      0,
      0.480705,
      NULL,
      NULL,
      1.773118,
      NULL,
      NULL,
      0.877057,
      1.870273,
      0.364259,
      NULL,
      NULL,
      3.552082,
      1.362567,
      1,
      2,
      1.593779,
      1.296424,
      NULL,
      1.774046,
      0.893047,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365421,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.131898,
      NULL,
      NULL,
      1.861560,
      1,
      0,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      4.632565,
      2,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.916292,
      NULL,
      NULL,
      1.105265,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      2.101510,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      7.519006,
      3,
      2.046009,
      19.590693,
      NULL,
      NULL,
      3,
      NULL,
      0.558523,
      2.387408,
      0.579922,
      2.799686,
      NULL,
      6.673970,
      1,
      NULL,
      NULL,
      0.727170,
      NULL,
      1,
      1,
      2,
      2,
      NULL,
      0,
      2,
      0,
      2,
      6.125426,
      0,
      2.414993,
      1,
      NULL,
      3.516288,
      1.421178,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776815,
      NULL,
      NULL,
      0.355840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.246873,
      3.392802,
      1.823529,
      1.130860,
      0.100802,
      3,
      NULL,
      NULL,
      4.902291,
      NULL,
      NULL,
      NULL,
      46.786162,
      40.071999,
      NULL,
      NULL,
      0,
      0.805969,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      0.249773,
      NULL,
      NULL,
      0.466569,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.419202,
      3,
      NULL,
      NULL,
      1.016806,
      0,
      NULL,
      NULL,
      0,
      1.491277,
      NULL,
      NULL,
      NULL,
      0.535381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.135557,
      0,
      NULL,
      NULL,
      3,
      2.290632,
      NULL,
      NULL,
      3.437207,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.604456,
      2,
      2.296234,
      2.116599,
      2,
      45.242418,
      19.617388,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.076362,
      NULL,
      NULL,
      1.132948,
      NULL,
      1.582215,
      8588,
      431,
      0,
      1.088294,
      1,
      NULL,
      1,
      1.055435,
      1,
      0,
      0.569220,
      1,
      1,
      1.753844,
      1.172424,
      1,
      NULL,
      1,
      1.312481,
      2.114645,
      NULL,
      1.200108,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.812145,
      NULL,
      0,
      NULL,
      12,
      NULL,
      0,
      43,
      NULL,
      1.927058,
      0.823272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273988,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.179029,
      NULL,
      0.464990,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.788747,
      NULL,
      1.288270,
      NULL,
      NULL,
      2.766243,
      1.541473,
      1.222803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.324040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.011012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.706113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.017107,
      NULL,
      2,
      NULL,
      351,
      NULL,
      2.753120,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      1.032820,
      33,
      NULL,
      1.172945,
      NULL,
      NULL,
      NULL,
      2,
      2.671295,
      0,
      7,
      2.663245,
      0.261701,
      3.764393,
      NULL,
      NULL,
      NULL,
      3,
      1.853448,
      NULL,
      1,
      0.679995,
      1,
      3.835990,
      NULL,
      NULL,
      0.294647,
      1,
      1.830080,
      1.806361,
      NULL,
      0,
      NULL,
      1,
      1.994827,
      0.009068,
      2,
      0,
      0,
      0,
      1.961495,
      0.713355,
      NULL,
      1,
      0,
      0.382811,
      0,
      0.399311,
      3,
      1,
      0.236593,
      1,
      0,
      3.897392,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.988538,
      1.990211,
      0,
      NULL,
      1.819356,
      1,
      1,
      NULL,
      0.777850,
      3.556215,
      0.102732,
      3,
      1,
      NULL,
      1,
      0,
      1.506617,
      NULL,
      0.028987,
      2.258313,
      2,
      2.446418,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.341970,
      1,
      0,
      1,
      0,
      0.596343,
      4,
      0,
      0,
      1,
      NULL,
      NULL,
      23.126207,
      39,
      5,
      1,
      NULL,
      '12303',
      '30004',
      '14040',
      0.672458,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


