set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8008059';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      3.931183,
      1,
      0,
      3,
      '0220',
      1.007537,
      NULL,
      NULL,
      NULL,
      NULL,
      29.543806,
      NULL,
      3.815768,
      NULL,
      0,
      ' 4-19-1988',
      40,
      NULL,
      NULL,
      NULL,
      1.834419,
      '11-29-1989',
      ' 4-17-1990',
      NULL,
      2.384409,
      1,
      1.443355,
      1,
      0,
      3,
      NULL,
      0.169089,
      1,
      72.735392,
      10.087249,
      3.377215,
      3.729436,
      7.534679,
      88.111434,
      NULL,
      1,
      NULL,
      8.268672,
      10.450872,
      NULL,
      1,
      0.053163,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      64,
      12,
      1.157195,
      NULL,
      2,
      10.762952,
      0.235970,
      0,
      0,
      0.919161,
      0.381504,
      8.508166,
      0,
      1,
      1.815391,
      NULL,
      NULL,
      5,
      1,
      4.132398,
      1.713888,
      0.534203,
      1,
      NULL,
      NULL,
      0.500818,
      NULL,
      NULL,
      8.620556,
      1,
      0.982787,
      2.370389,
      NULL,
      NULL,
      1,
      0.206608,
      NULL,
      0,
      1.121138,
      NULL,
      1.095459,
      NULL,
      NULL,
      1,
      2.904158,
      0.128777,
      1,
      1,
      0,
      0.574806,
      2,
      0,
      1,
      NULL,
      1.408844,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.804431,
      NULL,
      7.207481,
      0.967943,
      0,
      1.706921,
      0,
      NULL,
      NULL,
      4,
      1.678048,
      NULL,
      0.619796,
      5,
      0,
      0,
      1.396538,
      1.809565,
      NULL,
      NULL,
      1,
      7,
      0.182575,
      1,
      4.123845,
      1.969439,
      NULL,
      5,
      NULL,
      1.608883,
      6.108397,
      1.720905,
      NULL,
      6.096378,
      0.563718,
      4.690504,
      6.531473,
      5.322060,
      NULL,
      7.613312,
      6.421682,
      NULL,
      1,
      NULL,
      0.531492,
      5.742114,
      5.997268,
      2.553813,
      '11-21-1979',
      905.291625,
      ' 5-14-1976',
      492,
      3,
      0.730602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436095,
      NULL,
      NULL,
      0.697030,
      5.002622,
      1.662795,
      1.097283,
      0.799277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.613247,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      4,
      0,
      1,
      1.165605,
      NULL,
      NULL,
      NULL,
      0.989215,
      4.924590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.061015,
      0,
      1.771970,
      NULL,
      0.879878,
      NULL,
      1,
      0,
      6212.860969,
      0.346345,
      1.582956,
      NULL,
      NULL,
      NULL,
      0.724536,
      1.742969,
      0.149450,
      2,
      3,
      2,
      1,
      0,
      0,
      1,
      NULL,
      2.773067,
      1,
      1.740960,
      9,
      3.295026,
      1,
      1.569336,
      1,
      3.077953,
      1.847920,
      0.861194,
      1.375940,
      NULL,
      0,
      0,
      1.757938,
      NULL,
      NULL,
      0,
      0.443443,
      1.906542,
      NULL,
      NULL,
      0.423646,
      1.074851,
      2.825246,
      NULL,
      2,
      0,
      NULL,
      1.416648,
      0.421034,
      2.129050,
      NULL,
      1.030332,
      2.944534,
      NULL,
      24,
      18.458276,
      71,
      2,
      0.680157,
      0,
      '20111',
      '',
      '',
      0.298313,
      '',
      '',
      '',
      0.137058,
      '20111',
      '',
      '',
      1,
      23.054001,
      208.457928,
      23,
      2.313317,
      20,
      6,
      8,
      0,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      3.687033,
      1,
      0.336247,
      3.763506,
      1,
      1.029502,
      3,
      0.798129,
      NULL,
      3.966222,
      1.980570,
      1.764568,
      NULL,
      NULL,
      2.753839,
      1.008145,
      NULL,
      NULL,
      2.720616,
      3.692347,
      1,
      2,
      0,
      3.184472,
      NULL,
      1.844103,
      0,
      1,
      NULL,
      NULL,
      11.328472,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.474454,
      0.548818,
      0.191813,
      3,
      0.737290,
      1.790226,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.896487,
      NULL,
      1,
      2.905752,
      NULL,
      NULL,
      NULL,
      1.218191,
      0,
      1,
      0.373839,
      3.383366,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.109478,
      NULL,
      0.745609,
      NULL,
      NULL,
      1.035600,
      0,
      0.609777,
      8.085244,
      4.746609,
      NULL,
      1.574167,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.971089,
      0.264070,
      NULL,
      NULL,
      1,
      0.210039,
      NULL,
      0,
      3,
      3.353057,
      0,
      NULL,
      1.723601,
      4.734200,
      0.224205,
      4,
      1.330792,
      3.598865,
      NULL,
      NULL,
      NULL,
      NULL,
      5.328075,
      2.483209,
      4.896933,
      0.381123,
      NULL,
      NULL,
      1.932323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.838831,
      NULL,
      NULL,
      1,
      3.500940,
      1.735604,
      1,
      3,
      3,
      NULL,
      2.684029,
      1.883163,
      NULL,
      2.177452,
      NULL,
      2,
      4.132805,
      NULL,
      1,
      1,
      3,
      NULL,
      1,
      3,
      1,
      1,
      3,
      9.562409,
      7,
      7.020027,
      0.825946,
      0,
      2,
      2.013365,
      1.796214,
      1.273033,
      0.299407,
      NULL,
      NULL,
      0,
      0.804445,
      0,
      NULL,
      0,
      4,
      4,
      5.317935,
      2.281878,
      0.265851,
      NULL,
      9.919027,
      NULL,
      0.941591,
      0.050028,
      1,
      0,
      2.692348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.629894,
      NULL,
      NULL,
      2.504037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.004270,
      NULL,
      NULL,
      NULL,
      2.649603,
      1.621386,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.723931,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.168977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.280704,
      NULL,
      NULL,
      NULL,
      1.949666,
      NULL,
      NULL,
      NULL,
      0.386114,
      NULL,
      NULL,
      NULL,
      0.005353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      4.249209,
      NULL,
      NULL,
      NULL,
      3.420233,
      4,
      2.117108,
      3.353220,
      2,
      257.512123,
      212,
      NULL,
      NULL,
      NULL,
      1.905262,
      NULL,
      NULL,
      1.073263,
      1.310562,
      0,
      2.248902,
      56.641774,
      21.250031,
      1.465847,
      NULL,
      2.997563,
      0.734647,
      NULL,
      NULL,
      1053,
      NULL,
      1.874519,
      0.220071,
      0.273209,
      1,
      1.458200,
      NULL,
      0.964203,
      0.700160,
      0,
      0.435946,
      NULL,
      0,
      1,
      NULL,
      1,
      0.661800,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703653,
      0.444462,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030595,
      3.180607,
      NULL,
      0.893124,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1.557124,
      0.603638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997796,
      2,
      1,
      3.978243,
      2.410828,
      0.075137,
      6.108557,
      4,
      12.164158,
      1.502591,
      NULL,
      NULL,
      1.628879,
      1,
      NULL,
      1.825066,
      2.612616,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.828241,
      NULL,
      0.447390,
      0,
      NULL,
      1.559219,
      1.303911,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714525,
      0,
      NULL,
      NULL,
      1.606056,
      NULL,
      3.419359,
      3,
      NULL,
      0.762680,
      0,
      NULL,
      1,
      0,
      1.324256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.650622,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      NULL,
      14,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.339318,
      NULL,
      5.448313,
      12.035648,
      6,
      NULL,
      3,
      3.656521,
      3.091107,
      NULL,
      4.047110,
      0,
      2,
      '34043',
      '10004',
      '41414',
      0.719094,
      NULL,
      '',
      '',
      NULL,
      '41313',
      '',
      '');
commit;
end;
/


