set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '4424142',
      1,
      1.320225,
      NULL,
      NULL,
      '0023',
      0.461962,
      NULL,
      NULL,
      NULL,
      ' 0-23-1981',
      49,
      NULL,
      NULL,
      2,
      3,
      ' 4- 9-1983',
      NULL,
      3.969152,
      71,
      17.514286,
      1.931382,
      NULL,
      NULL,
      ' 7-18-1996',
      2,
      0,
      0,
      3,
      0.410086,
      3.136018,
      2.512940,
      3,
      NULL,
      NULL,
      NULL,
      0.763611,
      2,
      16,
      3.714028,
      4.301419,
      16,
      1.788421,
      2.345008,
      3,
      0.966744,
      3,
      0.160691,
      1,
      0.467118,
      NULL,
      1.735459,
      NULL,
      NULL,
      0,
      1.650463,
      0,
      1.832351,
      0.960211,
      1.284607,
      1,
      0.154983,
      0,
      NULL,
      1.555017,
      0,
      0,
      NULL,
      0,
      1.677909,
      NULL,
      4.776662,
      7,
      1,
      3,
      1,
      1.018845,
      NULL,
      NULL,
      NULL,
      0,
      3.797405,
      0.432912,
      NULL,
      0.601656,
      1.409545,
      1.773484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.300824,
      0.450107,
      0.251499,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      5.988236,
      0,
      0.061235,
      1.187438,
      2.654690,
      NULL,
      NULL,
      3,
      NULL,
      4.294463,
      NULL,
      0,
      0,
      NULL,
      1.816754,
      NULL,
      NULL,
      3.849901,
      NULL,
      3.924172,
      NULL,
      2,
      NULL,
      5.238411,
      2.277698,
      0,
      1,
      5,
      4,
      2.377125,
      1.132394,
      0.488322,
      NULL,
      3,
      4,
      6.538659,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-1996',
      19,
      ' 8-11-1996',
      NULL,
      1,
      1,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892071,
      0.480221,
      1,
      1,
      0,
      6.768183,
      1.066713,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.099875,
      NULL,
      0,
      0,
      0.401835,
      4,
      1,
      0,
      1,
      1.289405,
      0,
      2,
      2.283631,
      0.741715,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0.452153,
      2.884361,
      NULL,
      6,
      0,
      1.077491,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146807,
      3,
      2.094528,
      7,
      NULL,
      ' 0- 9-1987',
      2.609929,
      ' 3- 5-1984',
      16.250211,
      3.630762,
      NULL,
      1.854941,
      0.880527,
      0.534074,
      NULL,
      1.785048,
      NULL,
      0.188761,
      NULL,
      0.853891,
      NULL,
      2,
      1.317390,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      3,
      2.446731,
      2.618879,
      2.043168,
      3.524953,
      1.733981,
      3.061644,
      NULL,
      3,
      3.627081,
      0.175430,
      2,
      3,
      1,
      1.925826,
      2,
      0.527107,
      1.053113,
      NULL,
      0,
      0.791767,
      0.809486,
      1.567199,
      0,
      1.048241,
      3,
      2,
      0.847101,
      2.801839,
      0,
      NULL,
      8,
      7.965389,
      0.575291,
      NULL,
      3,
      NULL,
      1.993725,
      1,
      1,
      27,
      1.761369,
      1.805840,
      24.354522,
      NULL,
      NULL,
      NULL,
      0.030221,
      NULL,
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      13,
      NULL,
      3,
      22,
      0,
      1,
      NULL,
      0.617609,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.659505,
      NULL,
      NULL,
      1.214068,
      NULL,
      NULL,
      NULL,
      3.268046,
      0,
      0,
      NULL,
      NULL,
      1.952068,
      NULL,
      NULL,
      2,
      0.060146,
      2.688994,
      0.965299,
      1.395110,
      1,
      0.579280,
      NULL,
      NULL,
      2.611112,
      NULL,
      NULL,
      1.748033,
      2,
      0,
      1.424659,
      6.104407,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.267603,
      8.135418,
      1.252237,
      7.499330,
      2,
      2.359959,
      0.542608,
      NULL,
      NULL,
      NULL,
      0.838004,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.188233,
      1.983257,
      NULL,
      NULL,
      0,
      1.522360,
      1,
      3,
      0,
      2,
      NULL,
      0.556289,
      1.862663,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.498611,
      NULL,
      NULL,
      8.633075,
      9.249406,
      0.210220,
      0,
      0.311759,
      NULL,
      NULL,
      NULL,
      1.025720,
      1.412456,
      NULL,
      12,
      1.326894,
      NULL,
      NULL,
      0.503777,
      NULL,
      NULL,
      3.800488,
      0.351019,
      NULL,
      8,
      NULL,
      NULL,
      0,
      0.148508,
      NULL,
      NULL,
      3.375937,
      NULL,
      0.552277,
      1.387767,
      0.240063,
      4,
      4,
      2.417154,
      1.041046,
      NULL,
      NULL,
      0.257888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491984,
      NULL,
      NULL,
      1.076428,
      NULL,
      NULL,
      1.005215,
      NULL,
      NULL,
      0,
      2,
      0,
      3,
      NULL,
      0,
      3,
      1,
      1.976262,
      4.719147,
      0,
      6,
      1.766195,
      NULL,
      NULL,
      1.384156,
      NULL,
      NULL,
      1,
      2.382528,
      1,
      1,
      1,
      1.910428,
      8.802291,
      1.045517,
      5.899820,
      2.878408,
      2.613823,
      0.934988,
      2,
      3,
      0,
      1,
      0.224068,
      0.109579,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      3,
      1,
      0.607213,
      4.222928,
      0.645797,
      1.143067,
      NULL,
      0.831457,
      1.339309,
      2.944257,
      NULL,
      NULL,
      0.729188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.778755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.396388,
      1.254404,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5.009201,
      NULL,
      NULL,
      NULL,
      2.085775,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.423115,
      NULL,
      NULL,
      NULL,
      1.319705,
      NULL,
      NULL,
      NULL,
      0.271969,
      NULL,
      NULL,
      NULL,
      3.619196,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.300556,
      NULL,
      NULL,
      NULL,
      0.230628,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.896012,
      NULL,
      NULL,
      NULL,
      1.961847,
      NULL,
      NULL,
      NULL,
      2.459703,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.332617,
      NULL,
      NULL,
      NULL,
      1,
      2.875401,
      NULL,
      0,
      2.952138,
      1,
      0.005173,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.086954,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      52.553319,
      1.030335,
      NULL,
      1,
      0.359737,
      1,
      NULL,
      0.239152,
      NULL,
      0.215481,
      1,
      NULL,
      1.960912,
      0,
      1,
      NULL,
      1,
      0.817364,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599569,
      3.393457,
      4.057895,
      1.767381,
      1.930676,
      2,
      NULL,
      NULL,
      2.913796,
      2.585979,
      0.342920,
      NULL,
      0,
      NULL,
      1.124103,
      0,
      NULL,
      1.181244,
      NULL,
      NULL,
      0.265648,
      3,
      NULL,
      2.861447,
      3.262352,
      NULL,
      0.619641,
      1.005702,
      NULL,
      0.410720,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.908417,
      NULL,
      NULL,
      NULL,
      1.411598,
      NULL,
      1,
      1.881405,
      NULL,
      3,
      0.539395,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333595,
      NULL,
      0.180430,
      NULL,
      0.982239,
      NULL,
      NULL,
      0.137719,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.261972,
      1.630915,
      3.622621,
      '41421',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      0.273533,
      '',
      '',
      '');
commit;
end;
/


