set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      '20',
      17,
      3,
      '4222132',
      0,
      1,
      3,
      2,
      '3433',
      1,
      0,
      NULL,
      NULL,
      '10-19-1977',
      130,
      23,
      NULL,
      3,
      0,
      ' 8- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 1-18-1980',
      0,
      3.253321,
      0.501741,
      0,
      0.283078,
      3,
      0.770055,
      1.433293,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.437858,
      NULL,
      1,
      3,
      0,
      1,
      0.149326,
      NULL,
      1,
      NULL,
      0,
      0.925238,
      NULL,
      2,
      1.381080,
      3,
      0,
      5.861848,
      1,
      1,
      NULL,
      1.937775,
      NULL,
      2.768521,
      2.626373,
      6,
      7,
      7,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.421857,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.325456,
      1.067727,
      NULL,
      2.884122,
      1,
      0,
      NULL,
      NULL,
      1,
      0.666354,
      1,
      0.317789,
      1,
      NULL,
      NULL,
      3,
      3.161855,
      NULL,
      NULL,
      0,
      NULL,
      1,
      8,
      NULL,
      5.547326,
      0.335310,
      0,
      NULL,
      NULL,
      1.015102,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.360504,
      0.976584,
      4.110067,
      NULL,
      0,
      0.566161,
      0,
      5,
      4,
      NULL,
      9.824627,
      NULL,
      1.444520,
      0.450511,
      1.604160,
      1,
      NULL,
      0,
      0.618005,
      4,
      1,
      0.200094,
      1,
      5.303479,
      NULL,
      0.444368,
      0,
      0.367558,
      0,
      NULL,
      1,
      0.723205,
      0.811749,
      1.225132,
      0,
      1.685493,
      1.685690,
      1,
      0.083428,
      0,
      1.078662,
      0,
      0,
      NULL,
      0,
      ' 0- 5-1976',
      NULL,
      '10-19-2002',
      NULL,
      0.124083,
      1.690492,
      0.971813,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.111307,
      3.110710,
      2.779454,
      NULL,
      1.696168,
      1,
      3,
      1.898447,
      NULL,
      1.720818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614087,
      NULL,
      NULL,
      NULL,
      NULL,
      2.333800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266610,
      0,
      5.249754,
      1.583894,
      NULL,
      0.065342,
      0.936655,
      NULL,
      NULL,
      NULL,
      0.654992,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801246,
      0,
      NULL,
      NULL,
      1.745225,
      NULL,
      1.055774,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.246591,
      1,
      0.409482,
      NULL,
      0,
      NULL,
      3,
      1,
      2,
      0.120006,
      2,
      NULL,
      0,
      NULL,
      1,
      1,
      4.281544,
      1,
      1.633650,
      NULL,
      NULL,
      NULL,
      1,
      0.283449,
      NULL,
      NULL,
      2.080210,
      0,
      1,
      NULL,
      10.958288,
      NULL,
      3,
      11,
      2.510860,
      1,
      NULL,
      5,
      NULL,
      0.929728,
      1.246541,
      NULL,
      1.648725,
      0.251477,
      34,
      NULL,
      NULL,
      NULL,
      0.167052,
      2.178557,
      1.823368,
      '02200',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1.398334,
      '',
      '',
      '',
      NULL,
      NULL,
      2,
      29,
      1.801724,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.158440,
      3,
      2,
      0,
      0.014400,
      NULL,
      1.906720,
      NULL,
      1,
      0.243080,
      1,
      0.269129,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.972976,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.689225,
      0.139338,
      NULL,
      1,
      2.956078,
      NULL,
      3,
      NULL,
      0.961631,
      NULL,
      NULL,
      NULL,
      0.582801,
      NULL,
      NULL,
      NULL,
      3.662991,
      2,
      2.466294,
      3.582947,
      2.582043,
      NULL,
      2,
      3,
      NULL,
      1.856783,
      0,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      3.354409,
      NULL,
      1.199597,
      1,
      1,
      1.434916,
      1,
      0.434295,
      0,
      NULL,
      NULL,
      1.470305,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      2,
      5,
      0,
      1.952029,
      NULL,
      NULL,
      NULL,
      1.964324,
      NULL,
      NULL,
      NULL,
      0.093878,
      NULL,
      NULL,
      0.372078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.268117,
      0,
      0,
      3.104042,
      1.867428,
      2,
      8.897664,
      1.855556,
      NULL,
      1,
      NULL,
      NULL,
      0.264393,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017254,
      NULL,
      NULL,
      0.556258,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      3.141276,
      6,
      NULL,
      NULL,
      NULL,
      5.716319,
      1.264408,
      NULL,
      0,
      NULL,
      NULL,
      2.877202,
      0.457251,
      1.274376,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      3.594526,
      0.392053,
      0,
      1.862139,
      NULL,
      NULL,
      0.021132,
      1.440745,
      1,
      NULL,
      NULL,
      NULL,
      5.296234,
      1.084762,
      6,
      2.057947,
      NULL,
      1.533867,
      3,
      3.360294,
      0.645939,
      NULL,
      1.154332,
      NULL,
      0,
      0.542038,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366271,
      NULL,
      NULL,
      2.209528,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151631,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.250265,
      1.867269,
      0,
      1.325237,
      0,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3.439135,
      NULL,
      NULL,
      NULL,
      3.005747,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.250942,
      NULL,
      NULL,
      NULL,
      0.027040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.292759,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      11.500595,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      185.521953,
      0,
      NULL,
      NULL,
      1.330016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602385,
      NULL,
      1,
      78.737786,
      0,
      0,
      NULL,
      1,
      NULL,
      0.269013,
      NULL,
      NULL,
      1,
      0.822171,
      0.694064,
      1.223633,
      0,
      0.945403,
      NULL,
      1.497005,
      1.595053,
      0.179618,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.090192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131450,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.790676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406222,
      0.331672,
      NULL,
      1.222390,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      NULL,
      1.055870,
      NULL,
      0.081335,
      1.246156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.987792,
      NULL,
      0.995213,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.628107,
      NULL,
      NULL,
      1,
      0,
      1.319930,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.590730,
      NULL,
      2.182494,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.471293,
      NULL,
      NULL,
      1.098402,
      NULL,
      3.189641,
      2,
      NULL,
      0.387738,
      0.764288,
      NULL,
      NULL,
      0.125684,
      0.270400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045769,
      NULL,
      1.596101,
      NULL,
      0.319640,
      NULL,
      NULL,
      1.152936,
      NULL,
      1.130297,
      NULL,
      NULL,
      44,
      61.913453,
      0.735722,
      0.511540,
      1,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.315601,
      '',
      '',
      '');
commit;
end;
/


