set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9726580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.593533,
      1,
      1.900161,
      1,
      NULL,
      0,
      2.566371,
      0,
      '301',
      '41003302',
      39.879951,
      44,
      '1110042',
      NULL,
      NULL,
      1,
      NULL,
      '0301',
      4.736127,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211154,
      41,
      NULL,
      1.623899,
      1.257913,
      '11-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 2- 2-1983',
      ' 5- 4-1986',
      2.619880,
      2.494486,
      NULL,
      0,
      1,
      1.085834,
      NULL,
      NULL,
      0.572989,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.699639,
      2,
      NULL,
      1.631628,
      NULL,
      NULL,
      NULL,
      1.860135,
      0,
      1,
      1.692295,
      0.595047,
      2,
      1.033426,
      5,
      NULL,
      0,
      NULL,
      7.329272,
      NULL,
      9,
      5.862585,
      0.212193,
      0,
      1,
      NULL,
      NULL,
      10,
      1.556538,
      3.180720,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1.821031,
      NULL,
      NULL,
      0.010291,
      NULL,
      2,
      10.323316,
      0.417686,
      NULL,
      NULL,
      NULL,
      1.344511,
      2,
      1,
      2.108917,
      1,
      NULL,
      1.832394,
      1.218543,
      1.288198,
      0.007744,
      NULL,
      3.338962,
      0,
      0,
      3.467021,
      NULL,
      NULL,
      10.619630,
      1,
      5,
      3.594389,
      0,
      NULL,
      NULL,
      1,
      4.904869,
      0.468682,
      2.644498,
      3,
      5,
      1,
      3.080931,
      2,
      2.112550,
      0.624307,
      NULL,
      0.551578,
      NULL,
      2,
      0.738461,
      4.579072,
      1.482202,
      NULL,
      1.659314,
      0,
      NULL,
      NULL,
      0.522767,
      7,
      3,
      5,
      NULL,
      0,
      NULL,
      0.445254,
      0,
      NULL,
      5.976036,
      0,
      7.012741,
      7,
      1,
      8,
      3,
      8,
      2.470028,
      1.369351,
      7,
      4,
      5,
      2,
      1,
      4.826275,
      2.227318,
      0,
      ' 5-18-1999',
      NULL,
      ' 3-11-1991',
      17,
      NULL,
      1.950196,
      0.035376,
      0.829231,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159297,
      NULL,
      5.359124,
      1.261725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2,
      NULL,
      6.488188,
      1.794940,
      1.859082,
      NULL,
      3,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204782,
      NULL,
      9.803387,
      0.987649,
      9.257804,
      7,
      4.398740,
      NULL,
      NULL,
      NULL,
      0.435180,
      14,
      0,
      1.018179,
      8.028785,
      1.227167,
      NULL,
      '10-15-1975',
      214.932827,
      NULL,
      NULL,
      2,
      2,
      1.999488,
      NULL,
      0,
      1,
      1.684168,
      1.142714,
      NULL,
      0.824375,
      1.517190,
      NULL,
      2.730082,
      1.725810,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      2,
      1.959392,
      2,
      2,
      NULL,
      3.024354,
      1.920968,
      NULL,
      3,
      2,
      0.828031,
      0,
      0,
      0.034613,
      NULL,
      0,
      1,
      1.607457,
      NULL,
      NULL,
      0.405930,
      NULL,
      0,
      0,
      0.874348,
      5.909551,
      1,
      11,
      9,
      0.098267,
      3.787950,
      3.806931,
      4,
      NULL,
      0.843029,
      7,
      1.859855,
      3,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3,
      65,
      2,
      5,
      4,
      '43011',
      '32343',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '1100',
      '',
      '',
      0,
      20.453846,
      56,
      NULL,
      1.116024,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781932,
      NULL,
      1.581801,
      1,
      NULL,
      NULL,
      0.210676,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797971,
      NULL,
      NULL,
      1.463194,
      3.318915,
      0,
      0,
      NULL,
      NULL,
      1,
      2.374553,
      2,
      0,
      3.060080,
      0,
      0.496637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.900129,
      3.811019,
      1,
      NULL,
      NULL,
      NULL,
      1.509430,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.557989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.816522,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565046,
      3,
      1.798922,
      0.000437,
      3.304713,
      NULL,
      1.622612,
      3,
      1.413282,
      0,
      NULL,
      NULL,
      3.322945,
      1.084580,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064738,
      1.972185,
      0,
      0,
      NULL,
      NULL,
      NULL,
      7,
      6.938111,
      0.180754,
      5,
      4.864089,
      NULL,
      NULL,
      NULL,
      2.984083,
      2,
      3.790606,
      0.780723,
      0.445467,
      0.479805,
      NULL,
      NULL,
      1.628049,
      7.731845,
      0.869852,
      7.153179,
      2,
      1.127394,
      1,
      2.949340,
      3.334547,
      NULL,
      NULL,
      0.814897,
      2.554328,
      3,
      3.985855,
      0.868999,
      NULL,
      0.136781,
      6.241044,
      NULL,
      NULL,
      4.495066,
      2.698416,
      3.571244,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101664,
      NULL,
      NULL,
      0.156941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.555942,
      2,
      2,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.143512,
      NULL,
      NULL,
      NULL,
      1.693398,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.449115,
      NULL,
      NULL,
      NULL,
      2.081572,
      NULL,
      NULL,
      NULL,
      3.678321,
      NULL,
      NULL,
      NULL,
      3.008097,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.759002,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.441905,
      0.485067,
      5.495762,
      2,
      0,
      NULL,
      1.386807,
      1,
      3.261059,
      0.374279,
      1.814985,
      0.990789,
      NULL,
      NULL,
      0.488055,
      NULL,
      NULL,
      0.224090,
      NULL,
      NULL,
      0.958932,
      NULL,
      NULL,
      0.374352,
      NULL,
      1,
      1.640418,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1.215559,
      0,
      0.505922,
      1.098852,
      NULL,
      1.754089,
      NULL,
      0,
      1.417958,
      1,
      2,
      1,
      1,
      NULL,
      1.527209,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.259804,
      NULL,
      0,
      NULL,
      0.688428,
      NULL,
      15.428639,
      NULL,
      1.375998,
      0,
      NULL,
      0,
      NULL,
      0.447417,
      NULL,
      1.412189,
      NULL,
      0.027473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.068959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.497970,
      NULL,
      NULL,
      NULL,
      0.758058,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6.804459,
      NULL,
      13,
      1.887991,
      1.790016,
      7,
      0.839885,
      10,
      0.563155,
      3.745840,
      0.539203,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.603873,
      2,
      NULL,
      NULL,
      0.155679,
      NULL,
      1,
      NULL,
      NULL,
      1.297217,
      0.191458,
      NULL,
      NULL,
      1.413049,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.114995,
      NULL,
      0.075664,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133765,
      NULL,
      1.987046,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.669406,
      NULL,
      3.886649,
      NULL,
      2,
      NULL,
      1.591507,
      NULL,
      2,
      NULL,
      2.797572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.174880,
      1,
      33.796019,
      0.461067,
      NULL,
      0.789248,
      NULL,
      1.099742,
      NULL,
      2,
      9.088187,
      3.669737,
      NULL,
      NULL,
      NULL,
      NULL,
      49.434576,
      3,
      5,
      4,
      '02033',
      '20330',
      '10321',
      0.442777,
      '',
      '',
      '',
      NULL,
      '22031',
      '4102',
      '');
commit;
end;
/


