set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9852721';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      1,
      NULL,
      NULL,
      1.580197,
      NULL,
      2,
      2,
      NULL,
      '22430432',
      48.872982,
      52.262211,
      '3430242',
      NULL,
      1,
      1,
      NULL,
      '3211',
      6,
      1.845779,
      NULL,
      NULL,
      ' 2-23-1983',
      110.277393,
      162.265199,
      NULL,
      NULL,
      3.580471,
      ' 9-21-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 3-2000',
      ' 7- 7-2003',
      ' 6- 7-1985',
      2.087947,
      3,
      NULL,
      NULL,
      0,
      1,
      3,
      1.695773,
      0.895619,
      20,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.294669,
      NULL,
      0,
      0.347500,
      NULL,
      1,
      1,
      1.965810,
      1.564524,
      1,
      0,
      0,
      1,
      1,
      0,
      7.260520,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      0.496270,
      NULL,
      NULL,
      1.739545,
      2,
      0,
      2.370321,
      0.558173,
      NULL,
      3.767097,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      1.017493,
      1.364841,
      0.863386,
      0,
      NULL,
      NULL,
      1.372320,
      2,
      NULL,
      0.677153,
      0,
      2.086073,
      3,
      3,
      1.182946,
      NULL,
      0,
      0.786660,
      5.156603,
      1,
      2,
      0.507258,
      0.537972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.033976,
      NULL,
      5.130429,
      5.106758,
      3.679341,
      NULL,
      NULL,
      1.258102,
      1,
      5.521727,
      0.401864,
      0.280739,
      0,
      1.545645,
      0.751644,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      0.189063,
      5.973672,
      1,
      NULL,
      3.085612,
      0,
      2,
      6.561568,
      NULL,
      NULL,
      2.903905,
      5.238110,
      7.787025,
      3,
      2,
      NULL,
      1,
      7,
      3,
      2.654749,
      2,
      NULL,
      ' 7-12-1982',
      230,
      '11-25-1980',
      101,
      1.308821,
      NULL,
      5,
      NULL,
      1.759003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.545841,
      2,
      NULL,
      2.465145,
      0,
      3.424995,
      0.059948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1.692152,
      3.005635,
      2.690601,
      NULL,
      4,
      NULL,
      1,
      0.755879,
      NULL,
      0.901885,
      NULL,
      NULL,
      NULL,
      0.374442,
      2.485528,
      1.320229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310698,
      NULL,
      0.409562,
      0,
      NULL,
      0.284801,
      1.536379,
      0,
      10,
      3,
      1.339844,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.845482,
      2,
      1.202787,
      3.397712,
      NULL,
      3.688504,
      NULL,
      2.320290,
      0,
      1,
      2.963077,
      2.467944,
      0.637198,
      0,
      1,
      1.079706,
      1.337639,
      0,
      1.480390,
      0.203424,
      0,
      0,
      NULL,
      0.187929,
      0,
      1,
      0,
      0.902020,
      1,
      NULL,
      3.598466,
      0,
      9,
      NULL,
      1,
      3.844063,
      NULL,
      0,
      0,
      NULL,
      3.161917,
      1,
      NULL,
      1.644546,
      7,
      NULL,
      36.725273,
      NULL,
      4,
      3.113967,
      4.023845,
      '33010',
      '42044',
      '',
      1,
      '',
      '',
      NULL,
      0.499748,
      '',
      '',
      NULL,
      NULL,
      10.160626,
      39.623726,
      33.160409,
      3.393152,
      2,
      2.850353,
      6.575181,
      3,
      1,
      2,
      3.301483,
      NULL,
      NULL,
      NULL,
      0.046188,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.028439,
      1.605908,
      0,
      NULL,
      NULL,
      3.399729,
      3.083724,
      2.697213,
      0.652562,
      NULL,
      2.086127,
      2.615589,
      0.478952,
      NULL,
      2,
      0,
      0.670645,
      0,
      0.799226,
      0,
      NULL,
      0.569496,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.621797,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2.486692,
      0,
      0.847100,
      1,
      0.168111,
      0,
      2.283066,
      0,
      1.567029,
      1.017910,
      2,
      2.003726,
      NULL,
      1.332103,
      0.673349,
      1.360752,
      NULL,
      1.712940,
      1.367553,
      1.366483,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.843347,
      1,
      1,
      9,
      0,
      3,
      0.996205,
      1.714893,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      3,
      2.167187,
      0,
      NULL,
      NULL,
      5,
      4.000314,
      1.561530,
      NULL,
      NULL,
      0,
      0,
      0,
      1.810536,
      NULL,
      NULL,
      4,
      0.406638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192665,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.426494,
      NULL,
      NULL,
      1.916625,
      0,
      3.019490,
      0,
      1.555718,
      3.284250,
      NULL,
      NULL,
      0.797057,
      NULL,
      1,
      5.435849,
      0,
      NULL,
      NULL,
      0,
      2.287326,
      1.092554,
      1.116681,
      2.562435,
      2.472175,
      3,
      1,
      2,
      0,
      NULL,
      1.126433,
      2,
      2.830811,
      1.532467,
      3.397971,
      0,
      2.828969,
      NULL,
      1,
      2,
      3.574780,
      3,
      3,
      6,
      7,
      0.763349,
      NULL,
      3,
      NULL,
      1.783597,
      1.146205,
      0.432092,
      0,
      NULL,
      1.220850,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.928294,
      NULL,
      NULL,
      3.219723,
      NULL,
      NULL,
      1.700058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.060389,
      NULL,
      NULL,
      6.101623,
      NULL,
      NULL,
      NULL,
      1.515120,
      0,
      1,
      0.346628,
      0.202490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.920818,
      NULL,
      NULL,
      NULL,
      3.667015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.003573,
      NULL,
      NULL,
      NULL,
      0.058441,
      NULL,
      NULL,
      NULL,
      0.482807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.252828,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1.069080,
      NULL,
      NULL,
      NULL,
      3.247497,
      18,
      4.319224,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.900860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.718755,
      92.018321,
      4,
      0,
      0,
      1.542263,
      3.814167,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      3,
      0.218563,
      1,
      0,
      1,
      NULL,
      2.498530,
      NULL,
      3.521303,
      NULL,
      NULL,
      NULL,
      3.468750,
      NULL,
      2.830033,
      NULL,
      0,
      NULL,
      40,
      NULL,
      0.425160,
      16.745154,
      27,
      1.551470,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385961,
      NULL,
      1,
      NULL,
      1.736288,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.831476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059325,
      0.372239,
      1.302603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.831748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502947,
      1.167183,
      NULL,
      3,
      NULL,
      2.835717,
      NULL,
      24.649195,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.770280,
      NULL,
      0.485251,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.148252,
      NULL,
      187,
      NULL,
      1,
      NULL,
      3.905818,
      NULL,
      1,
      NULL,
      NULL,
      0.572822,
      1.126657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.360402,
      NULL,
      NULL,
      NULL,
      87.073815,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.039002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.307079,
      1,
      15.101212,
      25.805144,
      0.505616,
      NULL,
      NULL,
      NULL,
      0.539473,
      1.565071,
      0,
      NULL,
      NULL,
      0.032821,
      1.090545,
      NULL,
      1,
      1.046729,
      0.094548,
      0.529860,
      1.478994,
      NULL,
      NULL,
      1.726142,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.279019,
      NULL,
      0,
      1.530264,
      NULL,
      0.274757,
      0.714630,
      NULL,
      1.936969,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      NULL,
      2.883981,
      0,
      1.344505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066294,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3.708188,
      54,
      5,
      2.054770,
      5,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL);
commit;
end;
/


