set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '3234102',
      2,
      1,
      5,
      1,
      '0423',
      3.540966,
      1.737685,
      NULL,
      NULL,
      ' 8- 1-1984',
      31.217130,
      NULL,
      2.741301,
      0,
      0.251402,
      NULL,
      41.305146,
      0,
      333,
      57.813678,
      3,
      ' 7-19-1974',
      ' 3-24-1979',
      ' 0-13-1984',
      1.826566,
      1,
      2,
      1.347898,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      20,
      NULL,
      5.654891,
      11,
      11,
      0.229709,
      8,
      0.562536,
      5.521743,
      0,
      NULL,
      0,
      0.884559,
      0,
      0,
      0.743146,
      1.549743,
      1,
      NULL,
      2,
      NULL,
      2.566377,
      NULL,
      1.104524,
      3.626673,
      NULL,
      1.495009,
      1,
      5,
      0,
      1,
      0.296911,
      NULL,
      NULL,
      3,
      1.220380,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.861436,
      1.367243,
      1.833611,
      1,
      0,
      0.092318,
      0,
      0.170209,
      0,
      3,
      1.422134,
      0,
      0.292544,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0.698929,
      0.210790,
      2.276991,
      NULL,
      3.746398,
      0,
      1.490577,
      NULL,
      NULL,
      0.085515,
      NULL,
      NULL,
      NULL,
      1.403642,
      NULL,
      1.666783,
      1,
      4,
      0.133522,
      1.522121,
      0.454962,
      1.734023,
      NULL,
      2.771494,
      1.650635,
      4.950418,
      1.074894,
      1.497201,
      1.233580,
      0.561919,
      0.964974,
      NULL,
      NULL,
      0,
      2.573377,
      1.741161,
      4.704924,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0.678407,
      1.445564,
      4,
      0,
      2.570961,
      3.421609,
      5,
      7.148962,
      NULL,
      2.393533,
      4,
      1.917269,
      NULL,
      4.431068,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141831,
      NULL,
      3,
      0,
      1.322016,
      0.423940,
      1,
      0.567601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338525,
      NULL,
      3,
      2.517219,
      0.330835,
      2.839939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.107265,
      NULL,
      1,
      1,
      0.116144,
      1.999235,
      4.702227,
      6.148217,
      2,
      1,
      1.532825,
      NULL,
      NULL,
      NULL,
      0.003094,
      8.694178,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991474,
      0,
      0.317948,
      1,
      1,
      0.981053,
      2.182088,
      16.717977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      3.272904,
      1,
      7.503017,
      5.834154,
      2,
      2,
      2,
      3.566536,
      2.669891,
      1.936746,
      1.319733,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.465664,
      NULL,
      0.303799,
      0,
      0.188991,
      1,
      1.828388,
      0,
      1.821728,
      11.528931,
      7,
      3,
      NULL,
      11.515590,
      NULL,
      NULL,
      3.325396,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.925805,
      3.599402,
      NULL,
      59,
      10,
      45.628472,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      0,
      '42213',
      '',
      '',
      1.102934,
      '',
      NULL,
      NULL,
      NULL,
      9,
      30.980595,
      13.864574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.773979,
      0.733233,
      1,
      0.745177,
      1,
      1.799287,
      NULL,
      NULL,
      NULL,
      1.656119,
      1,
      NULL,
      NULL,
      NULL,
      1.781676,
      NULL,
      NULL,
      1.748600,
      2.870685,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0,
      0.292759,
      NULL,
      NULL,
      NULL,
      1.565750,
      NULL,
      NULL,
      NULL,
      NULL,
      3.409179,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1.217863,
      3,
      1.514836,
      3,
      1,
      NULL,
      1.751205,
      1.570728,
      0,
      1.327195,
      2,
      3,
      3.696105,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      4,
      1.305403,
      3.569455,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.340264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.920786,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.252684,
      1,
      NULL,
      NULL,
      0,
      1.599007,
      0,
      1,
      0,
      1.741846,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.207804,
      2,
      3.534706,
      2,
      NULL,
      NULL,
      NULL,
      0.205181,
      1,
      1.893935,
      2.090526,
      3,
      1,
      NULL,
      0.372880,
      NULL,
      1.491182,
      7,
      NULL,
      2.498784,
      1.738838,
      1.583806,
      NULL,
      NULL,
      0.076364,
      0,
      1,
      NULL,
      1.838291,
      2,
      4.636051,
      3,
      1.874402,
      2.880129,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.837426,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973732,
      1,
      1.351475,
      0,
      0.095416,
      1.625104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      6.172827,
      NULL,
      3,
      3.470282,
      1.359729,
      0.218296,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.414962,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.499476,
      NULL,
      NULL,
      0.886844,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.802885,
      1.565883,
      1,
      0.008529,
      0,
      0,
      2.588642,
      NULL,
      0.423740,
      NULL,
      2.831772,
      1,
      NULL,
      1.257643,
      0,
      1.870583,
      NULL,
      NULL,
      1.900055,
      NULL,
      NULL,
      NULL,
      3.964210,
      NULL,
      2,
      NULL,
      2.205423,
      NULL,
      NULL,
      NULL,
      1.007652,
      NULL,
      41.875604,
      0,
      1,
      NULL,
      NULL,
      1.624205,
      NULL,
      3.344464,
      NULL,
      NULL,
      NULL,
      3.526644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.005267,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.572521,
      NULL,
      0.725639,
      NULL,
      NULL,
      NULL,
      2.276282,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      174.767199,
      NULL,
      1.097652,
      NULL,
      NULL,
      NULL,
      1.996191,
      NULL,
      1.446909,
      0,
      3.505172,
      NULL,
      3.766326,
      NULL,
      2.167652,
      NULL,
      300.632850,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.584863,
      NULL,
      0.197585,
      0.991719,
      NULL,
      NULL,
      1.960134,
      NULL,
      NULL,
      NULL,
      1.054516,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.151841,
      NULL,
      0.834343,
      NULL,
      1.679875,
      NULL,
      290.983389,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.832603,
      NULL,
      1.556914,
      0.047753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.591987,
      NULL,
      3.554874,
      NULL,
      NULL,
      NULL,
      678.817928,
      NULL,
      NULL,
      1.030771,
      0,
      0.990257,
      0,
      NULL,
      NULL,
      NULL,
      523.612386,
      1.394458,
      NULL,
      NULL,
      3,
      1,
      1.572159,
      1,
      2,
      16.375687,
      12.561119,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.451635,
      0.072820,
      NULL,
      3,
      0,
      3,
      3,
      13,
      0,
      1.002849,
      0.548106,
      1.476020,
      NULL,
      NULL,
      1.684621,
      NULL,
      NULL,
      3.953741,
      NULL,
      NULL,
      0.597760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.409994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658089,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567972,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.780787,
      NULL,
      1.025272,
      NULL,
      0.619500,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.108899,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.008251,
      NULL,
      1.168005,
      NULL,
      21.314835,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      6,
      0,
      3.013039,
      NULL,
      2.338400,
      0.047059,
      65.499372,
      32.741090,
      9.056440,
      0,
      NULL,
      NULL,
      '42010',
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      NULL,
      NULL);
commit;
end;
/


