set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      '3214',
      0,
      0,
      NULL,
      NULL,
      ' 2-15-2001',
      9,
      NULL,
      2.921600,
      0.681612,
      0.230984,
      ' 3- 9-1975',
      46.668906,
      0.856401,
      248,
      106,
      1,
      ' 8- 8-1991',
      ' 7-20-1995',
      NULL,
      0,
      NULL,
      1.725035,
      1.182437,
      NULL,
      1.083110,
      3,
      1,
      0,
      11.687544,
      5.761356,
      15.797032,
      4.162973,
      NULL,
      NULL,
      5.155874,
      22.555256,
      3.941198,
      NULL,
      8,
      NULL,
      5.164952,
      1.956745,
      NULL,
      0.282122,
      0,
      1,
      1,
      0.629437,
      1,
      0,
      1,
      NULL,
      2,
      2.818777,
      1,
      0,
      0,
      0,
      1,
      1.306433,
      0.284038,
      1.077731,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762192,
      1,
      NULL,
      0.473568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122871,
      1.121779,
      5,
      1,
      4.116654,
      1.793140,
      NULL,
      1,
      7.504947,
      4,
      5,
      1,
      0,
      5.013975,
      NULL,
      0.087665,
      1,
      0.411245,
      0,
      NULL,
      1,
      4.661536,
      3,
      NULL,
      1.513250,
      1.956432,
      2.127238,
      0,
      0.113346,
      0.480985,
      1,
      1,
      1.365787,
      NULL,
      0.198000,
      3.798416,
      NULL,
      8,
      9.800033,
      3.600641,
      1,
      11.523885,
      1.922755,
      3.939663,
      0,
      0,
      2,
      0.428862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.859344,
      0.827023,
      0,
      0.427951,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.433097,
      3,
      0.901594,
      NULL,
      0,
      NULL,
      3.294089,
      3,
      0.019724,
      0.725550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.417069,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.469709,
      0.884937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.869994,
      0.617544,
      1.881925,
      NULL,
      0,
      NULL,
      1,
      1.903385,
      NULL,
      NULL,
      NULL,
      0,
      1.037999,
      NULL,
      0,
      NULL,
      1,
      1,
      3.502955,
      NULL,
      2.551386,
      NULL,
      1.603014,
      2.490245,
      1.877902,
      NULL,
      0.276837,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      0.010710,
      NULL,
      0.491266,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.021455,
      9.820748,
      0.744181,
      8.530974,
      1,
      2,
      1.003869,
      NULL,
      4.887260,
      2.272611,
      1,
      0.989296,
      40.278677,
      1.315626,
      1,
      NULL,
      23,
      100,
      32.164280,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      1.475953,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      30.771850,
      106,
      2,
      0,
      41.466112,
      2,
      NULL,
      5.873166,
      1,
      NULL,
      NULL,
      1.469086,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.221865,
      NULL,
      NULL,
      1,
      0.263163,
      0.014860,
      NULL,
      NULL,
      NULL,
      0.283958,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1.702827,
      0.781163,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5.186784,
      NULL,
      3.448849,
      0.073428,
      NULL,
      NULL,
      NULL,
      0.681297,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083439,
      0.563724,
      0.398180,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.736280,
      NULL,
      1.600476,
      2,
      0,
      2,
      NULL,
      1,
      1,
      1,
      1,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.887141,
      NULL,
      0,
      1,
      0.208706,
      NULL,
      NULL,
      NULL,
      1.771100,
      NULL,
      NULL,
      NULL,
      1.872984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.148730,
      1.435893,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.900862,
      0.921971,
      1,
      1.482936,
      2.223298,
      2.895629,
      0,
      3,
      0.692957,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.139912,
      NULL,
      NULL,
      0.774922,
      NULL,
      NULL,
      1.221309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.839262,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.152062,
      1.636739,
      3,
      0.142289,
      1.569513,
      3.579215,
      1,
      NULL,
      6.867356,
      2,
      NULL,
      2.095631,
      2,
      0,
      0,
      NULL,
      NULL,
      0.463826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.159190,
      NULL,
      0.569062,
      3.350763,
      3,
      0.148969,
      0,
      NULL,
      NULL,
      0,
      1.204558,
      NULL,
      NULL,
      NULL,
      1.456110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548357,
      0,
      0.825440,
      1,
      1,
      0.018226,
      1.772477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.753244,
      0.118595,
      2,
      3.700591,
      2,
      1,
      1.769286,
      NULL,
      NULL,
      1.328347,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807125,
      NULL,
      NULL,
      0.572710,
      NULL,
      1,
      NULL,
      1142.974608,
      0.724772,
      2.327613,
      0.905652,
      NULL,
      1.177328,
      NULL,
      NULL,
      1,
      1.862523,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.201783,
      1,
      NULL,
      2.154827,
      NULL,
      NULL,
      NULL,
      3.415570,
      NULL,
      0,
      NULL,
      2.676278,
      NULL,
      2.389106,
      NULL,
      20.579147,
      NULL,
      0,
      18,
      40,
      0.051939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.454481,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.386117,
      NULL,
      2.073641,
      NULL,
      1,
      NULL,
      0.350708,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0.383857,
      3,
      NULL,
      1,
      NULL,
      1.436609,
      NULL,
      1.194124,
      NULL,
      NULL,
      NULL,
      3.492185,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.304862,
      1,
      1.214356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.705896,
      NULL,
      1,
      0.011382,
      0.716769,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.131312,
      NULL,
      0.664434,
      NULL,
      0.587406,
      NULL,
      0.132310,
      NULL,
      3,
      NULL,
      2.829421,
      NULL,
      0.178897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112150,
      NULL,
      1.428724,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249226,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1417.626893,
      NULL,
      116,
      0,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      73,
      NULL,
      2.084079,
      NULL,
      0.715350,
      NULL,
      1.610642,
      NULL,
      NULL,
      14,
      11.308948,
      1,
      NULL,
      NULL,
      NULL,
      1.975195,
      0,
      0.804601,
      5,
      NULL,
      2,
      2.801616,
      NULL,
      4.186121,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.624005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.713866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.552240,
      NULL,
      1.446404,
      NULL,
      3.839839,
      NULL,
      0.194904,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2.780500,
      NULL,
      0.296560,
      NULL,
      2.259818,
      NULL,
      1.288916,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      21.635192,
      3,
      NULL,
      1.326334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.114405,
      NULL,
      0.284357,
      NULL,
      NULL,
      54.706212,
      NULL,
      5.870415,
      0.523998,
      NULL,
      NULL,
      '43311',
      '',
      2.543301,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


