set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '0303212',
      2,
      NULL,
      3,
      2,
      '2001',
      0.992905,
      1.511795,
      0.824925,
      13.808195,
      ' 1- 3-1984',
      108,
      NULL,
      NULL,
      NULL,
      0.108624,
      ' 0-20-1982',
      17.918210,
      NULL,
      273.488918,
      131.529869,
      NULL,
      NULL,
      NULL,
      '10- 5-1998',
      NULL,
      1.942607,
      1.072478,
      0.474551,
      0,
      3,
      NULL,
      0.980761,
      0,
      191.193296,
      0,
      2.470224,
      1.060961,
      9.829817,
      20,
      0,
      9,
      NULL,
      3.390139,
      9,
      0,
      0.988385,
      1.468343,
      1,
      1,
      0.669951,
      1.340959,
      0.672983,
      0,
      1.616888,
      1.530532,
      2,
      2.431527,
      NULL,
      3,
      1.357305,
      0,
      1.724233,
      1,
      1.437961,
      1,
      NULL,
      NULL,
      1.619092,
      1,
      1.704484,
      1,
      1,
      1,
      1,
      2.166494,
      3.205514,
      0.889454,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.809369,
      0.634719,
      3,
      1.284539,
      NULL,
      0.379430,
      1,
      0.137388,
      0,
      0,
      NULL,
      3.133627,
      NULL,
      1,
      0,
      0.195958,
      NULL,
      0,
      1,
      0.453221,
      0,
      0.893068,
      NULL,
      0.854311,
      1,
      5.837982,
      1.135009,
      NULL,
      NULL,
      1.475933,
      NULL,
      NULL,
      NULL,
      0,
      2.929614,
      1.481677,
      0,
      0,
      NULL,
      0,
      0.979953,
      NULL,
      NULL,
      1,
      1,
      5,
      1,
      0,
      0.075977,
      NULL,
      1.302505,
      NULL,
      0.729193,
      1,
      0,
      0.213544,
      4,
      5.714708,
      NULL,
      2.651064,
      4,
      1,
      4,
      3,
      NULL,
      3.547532,
      0,
      NULL,
      NULL,
      1,
      4,
      4,
      0,
      2,
      3,
      1.328948,
      1.026597,
      NULL,
      5,
      1.036365,
      ' 4-15-1992',
      97,
      ' 9-15-1982',
      1325,
      3.371866,
      0.513391,
      3.867275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691646,
      1.862118,
      1.868753,
      1,
      1.465334,
      1,
      0.497456,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881354,
      NULL,
      NULL,
      2,
      0,
      0.382424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667613,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.829431,
      2,
      0.240166,
      1.263092,
      0.193411,
      NULL,
      NULL,
      0.168006,
      1.912198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.314570,
      NULL,
      0,
      1,
      1.481762,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.725277,
      NULL,
      2.601138,
      0.766800,
      2.115130,
      1.781818,
      1,
      1,
      NULL,
      0.663490,
      NULL,
      2.590156,
      NULL,
      3.959353,
      NULL,
      3.791466,
      0,
      1,
      0,
      5.674285,
      1,
      1.258002,
      1,
      1,
      0,
      1.402617,
      NULL,
      1,
      0.777204,
      1,
      2,
      NULL,
      NULL,
      2.626344,
      3.763275,
      6.170220,
      9.425737,
      5,
      NULL,
      3,
      0,
      NULL,
      3.889665,
      3.311216,
      62.636693,
      3,
      NULL,
      51.673632,
      NULL,
      NULL,
      NULL,
      1,
      0.689306,
      NULL,
      '21344',
      NULL,
      NULL,
      0.370704,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      57.243610,
      1.603538,
      NULL,
      25.489130,
      7,
      NULL,
      2,
      0,
      NULL,
      1.547543,
      2.776499,
      1.962139,
      NULL,
      2,
      0,
      0,
      1.534913,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.405610,
      0.261766,
      3.060873,
      NULL,
      1.676310,
      1,
      1,
      0,
      1,
      NULL,
      1.612132,
      1,
      NULL,
      NULL,
      1.441626,
      NULL,
      NULL,
      0.645850,
      0,
      NULL,
      1.060255,
      9.574321,
      2.973615,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104930,
      NULL,
      1.143752,
      1.044917,
      0.307930,
      1,
      0,
      1.448536,
      NULL,
      NULL,
      NULL,
      0.637605,
      1.361232,
      3,
      1.371792,
      0,
      NULL,
      1,
      NULL,
      2,
      0.895307,
      3.753466,
      0,
      1.220781,
      1,
      NULL,
      0,
      0.196719,
      NULL,
      3.408305,
      NULL,
      3,
      2,
      0.923440,
      1,
      1.979931,
      3,
      0,
      NULL,
      7.503409,
      0.153999,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.808741,
      1,
      1.814588,
      2.721900,
      0,
      NULL,
      NULL,
      0,
      1.313634,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0.527450,
      2,
      1.200466,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539053,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.164407,
      NULL,
      NULL,
      1.870679,
      1.001170,
      NULL,
      0,
      1,
      NULL,
      6.294921,
      NULL,
      2,
      4,
      0,
      1,
      2,
      1.953916,
      NULL,
      2.516136,
      3.988840,
      2,
      NULL,
      1.178787,
      1.077014,
      4,
      1.183218,
      0,
      1.604725,
      1.274814,
      0.633204,
      NULL,
      NULL,
      NULL,
      3.987541,
      3.643614,
      0.562555,
      3.183473,
      3.887646,
      0,
      NULL,
      4,
      2.275224,
      NULL,
      2,
      4.059306,
      1,
      3.234545,
      3,
      0,
      0.572961,
      0,
      1,
      1.157841,
      NULL,
      NULL,
      NULL,
      1.546864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.070218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.150682,
      2.826945,
      NULL,
      1.974097,
      1,
      NULL,
      4.370029,
      NULL,
      3.799064,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.915922,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.956726,
      NULL,
      1,
      NULL,
      0.969131,
      NULL,
      NULL,
      NULL,
      1.476538,
      NULL,
      2.096013,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.799526,
      NULL,
      NULL,
      NULL,
      2.276159,
      NULL,
      0.283376,
      NULL,
      0.995014,
      NULL,
      2,
      NULL,
      1.215264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515525,
      NULL,
      0.346057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.929152,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.791999,
      NULL,
      0.922288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.880258,
      NULL,
      10.808912,
      NULL,
      3,
      NULL,
      NULL,
      4.427860,
      5,
      3,
      NULL,
      NULL,
      240.697602,
      1,
      88.748718,
      0.735306,
      0.595192,
      NULL,
      NULL,
      1.597543,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.383413,
      302,
      4,
      0.203610,
      NULL,
      NULL,
      2.753234,
      1,
      1,
      0,
      NULL,
      0.770252,
      0.289633,
      0,
      0.310570,
      0.379828,
      1,
      NULL,
      NULL,
      1.281421,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.658486,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.740703,
      33,
      3.536835,
      0,
      1.755164,
      NULL,
      NULL,
      0.072585,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.233797,
      NULL,
      0.747570,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.104490,
      NULL,
      1.978868,
      NULL,
      0,
      NULL,
      0.673675,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      2.415424,
      1.671787,
      0.206467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.340250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936032,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.741976,
      1,
      1.115155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060970,
      NULL,
      NULL,
      NULL,
      NULL,
      2.374511,
      NULL,
      46.683811,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      137.107684,
      NULL,
      2,
      NULL,
      2.447139,
      NULL,
      1.381638,
      0.899807,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      5.188064,
      2.838072,
      3.433159,
      NULL,
      4.773708,
      2,
      3,
      1.206246,
      NULL,
      1.442138,
      0.649825,
      1,
      0.267473,
      0,
      1.371635,
      1,
      0.926698,
      NULL,
      NULL,
      0,
      1.581827,
      0.683104,
      1,
      3.588285,
      3,
      3,
      3.236722,
      1,
      1,
      NULL,
      1,
      0.465265,
      1,
      3.455576,
      1,
      2,
      1,
      1,
      0.797517,
      0,
      0.515093,
      3,
      1.558905,
      0.885169,
      1.317369,
      2.966467,
      0.873122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060824,
      0.400439,
      1.152323,
      1.592893,
      1.990407,
      NULL,
      9.281570,
      3.341629,
      3,
      NULL,
      3.692403,
      23.428361,
      62.475769,
      4,
      0.685454,
      0.214849,
      '34314',
      '14312',
      '34103',
      1.679080,
      NULL,
      '',
      '',
      2.568634,
      '144',
      '0143',
      '1342');
commit;
end;
/


