set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016189';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '3314343',
      2.780629,
      0,
      1,
      2,
      '3441',
      2.227883,
      1.583629,
      NULL,
      NULL,
      ' 6- 7-2000',
      60,
      NULL,
      0.459665,
      1.348444,
      NULL,
      '10- 8-1993',
      70,
      1.507119,
      2,
      61.909615,
      2.153216,
      ' 6-11-2001',
      ' 9-13-1996',
      ' 9-15-1993',
      3.032619,
      3.972724,
      0,
      0,
      NULL,
      1.830567,
      2,
      NULL,
      1.540369,
      0.701321,
      2,
      10.691204,
      NULL,
      12.806302,
      1,
      7,
      17.532250,
      3.140014,
      1,
      7.445666,
      0,
      1.904399,
      1,
      1,
      NULL,
      0.104832,
      0,
      1.687641,
      1.579416,
      0.377758,
      137,
      5,
      9,
      NULL,
      1.623151,
      7.439108,
      0,
      NULL,
      NULL,
      3,
      7,
      9.421061,
      NULL,
      7.073650,
      1.891008,
      1,
      1.407077,
      8,
      1,
      3.768492,
      1.828113,
      0,
      NULL,
      NULL,
      NULL,
      1.825092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257401,
      0.803165,
      NULL,
      NULL,
      1.291544,
      NULL,
      NULL,
      3.938400,
      NULL,
      0.230142,
      NULL,
      1.095054,
      0.280090,
      0,
      NULL,
      0.067327,
      4.991440,
      1,
      NULL,
      5.767582,
      0.245655,
      5.085313,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      1,
      0.467447,
      4,
      3.834610,
      NULL,
      0.861446,
      NULL,
      5,
      0.644894,
      1.509985,
      NULL,
      5.070943,
      NULL,
      0,
      1,
      NULL,
      1.415260,
      NULL,
      1,
      5,
      5.029218,
      NULL,
      2.177169,
      2.484033,
      NULL,
      NULL,
      NULL,
      3,
      2,
      5,
      6,
      1.341183,
      3.531344,
      4.003115,
      7.041138,
      NULL,
      NULL,
      5.142724,
      10,
      NULL,
      5.051265,
      10.027935,
      0,
      NULL,
      3.321171,
      2.419930,
      ' 6-10-1978',
      645,
      NULL,
      1006,
      NULL,
      0,
      0.167210,
      0.481915,
      1.696105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.645873,
      1.491841,
      0.908301,
      0.529807,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.632481,
      2.599692,
      NULL,
      1.021618,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904514,
      3,
      NULL,
      NULL,
      0.243026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.054917,
      0.217883,
      0,
      NULL,
      3,
      4367.760026,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200366,
      NULL,
      0.509381,
      1.284013,
      3,
      NULL,
      0.302718,
      NULL,
      1,
      0,
      2.825963,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1.041741,
      0.503191,
      3.097389,
      0,
      NULL,
      NULL,
      0.184084,
      1.977591,
      NULL,
      1,
      1,
      0.326148,
      19.883310,
      1,
      0.217471,
      5,
      NULL,
      5.872615,
      0.343771,
      NULL,
      4,
      5,
      0,
      NULL,
      3,
      2.721686,
      0.216292,
      22,
      2,
      0.836151,
      NULL,
      20.616578,
      53.007131,
      67.449508,
      0,
      1.612573,
      0,
      NULL,
      '',
      '',
      0.118649,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.888215,
      38,
      29,
      4,
      NULL,
      22,
      2.135447,
      105.888083,
      11.220948,
      2.147404,
      3.632650,
      3,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3.305889,
      3.066704,
      3,
      0,
      1.339024,
      NULL,
      NULL,
      NULL,
      2.139548,
      1.610892,
      3.173668,
      3.087533,
      1,
      0.615509,
      1.983630,
      NULL,
      3.445623,
      3.643590,
      1.584027,
      0.820336,
      3,
      0.878259,
      NULL,
      0,
      NULL,
      NULL,
      0,
      8,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746155,
      0,
      1,
      2,
      13.460334,
      NULL,
      0.351853,
      NULL,
      NULL,
      3.809139,
      0,
      0,
      2.558737,
      1.481127,
      2,
      2.413736,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      1,
      0.920223,
      2,
      1,
      12,
      0.656231,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1.178613,
      0.705522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      0.669478,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.504370,
      0.755720,
      2.469411,
      2,
      3,
      3,
      0.316377,
      3,
      2.575548,
      7,
      3.017879,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216314,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3.764176,
      1.198968,
      3.285575,
      1,
      0,
      2.188061,
      1,
      5.455197,
      NULL,
      7.448615,
      6.422289,
      4.972697,
      0,
      1.860034,
      0.926600,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      5,
      6.978177,
      NULL,
      2,
      NULL,
      1,
      0,
      0.751252,
      0.710542,
      0.818278,
      NULL,
      2.851883,
      3.056421,
      NULL,
      2,
      3,
      6.711188,
      2.928131,
      2,
      0.230228,
      5.276604,
      3,
      2,
      1,
      1.113110,
      NULL,
      1.268309,
      0,
      1,
      2.369486,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.436935,
      NULL,
      NULL,
      1.083983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.793379,
      NULL,
      NULL,
      0,
      1.323795,
      1,
      0.233451,
      0.030677,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.241505,
      NULL,
      NULL,
      NULL,
      1.428927,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727615,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      1.107861,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      189.091894,
      0,
      NULL,
      4.369207,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634822,
      NULL,
      NULL,
      2,
      NULL,
      1,
      35,
      21,
      0.662455,
      0.201145,
      1.038581,
      1,
      0.749573,
      0.438292,
      0,
      1,
      1.266607,
      NULL,
      0,
      0,
      NULL,
      1,
      0.839497,
      1,
      0.806098,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.102752,
      4.997433,
      5.320362,
      0.955310,
      5,
      3,
      13,
      0.175704,
      1.865600,
      3,
      0,
      1.173749,
      NULL,
      2.687703,
      0,
      2,
      3.351930,
      1,
      NULL,
      NULL,
      0.080091,
      1.110105,
      3,
      1.468708,
      0,
      NULL,
      0.100780,
      0,
      1,
      1,
      0.836350,
      1,
      NULL,
      1.363379,
      1.539006,
      1.334838,
      1,
      0,
      1,
      0,
      0,
      0.996517,
      1.281881,
      0.683618,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.833184,
      0.038566,
      0.632133,
      1.222305,
      9.275287,
      6,
      1,
      NULL,
      0.188013,
      NULL,
      56,
      37.427373,
      0,
      NULL,
      0.085691,
      '24211',
      '24134',
      '20341',
      NULL,
      '',
      '',
      '',
      0.823516,
      '',
      '',
      NULL);
commit;
end;
/


