set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3100242',
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      1.165188,
      NULL,
      NULL,
      ' 0-25-1990',
      25,
      NULL,
      2.134327,
      1,
      NULL,
      ' 7-21-1980',
      20,
      0.826770,
      363,
      NULL,
      3,
      NULL,
      ' 9- 8-1982',
      '10-16-1982',
      NULL,
      NULL,
      3.283882,
      1.514068,
      0.700482,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6.130240,
      NULL,
      NULL,
      22.916082,
      6.830266,
      23.729838,
      NULL,
      3.422616,
      2.326848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.006282,
      3,
      1.815947,
      0.199611,
      2.265741,
      0,
      1.467978,
      1,
      0,
      1.916347,
      0,
      1,
      NULL,
      0,
      0.836675,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.558037,
      1.909528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970023,
      1.459359,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.807492,
      2.572874,
      1.064436,
      0.474187,
      3.163533,
      0,
      5.911593,
      NULL,
      0,
      4,
      0.139217,
      4.091263,
      1.706185,
      1.802491,
      NULL,
      NULL,
      0.281324,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      4.954603,
      3.700208,
      NULL,
      NULL,
      4,
      0.756455,
      1.712113,
      0,
      5.567365,
      2,
      0,
      NULL,
      2.324401,
      9,
      8,
      NULL,
      7.709685,
      0.153109,
      4.926700,
      NULL,
      NULL,
      4.337570,
      7.555926,
      0,
      1,
      ' 0-18-1976',
      278.353414,
      ' 6-27-2003',
      NULL,
      3,
      0,
      0.635176,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.206757,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1,
      1.546983,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.327771,
      0.399096,
      NULL,
      0,
      2.956955,
      NULL,
      1,
      1,
      6.549158,
      1,
      0,
      5,
      0.242573,
      NULL,
      NULL,
      NULL,
      0.371724,
      2.484882,
      1.577874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.027005,
      0,
      NULL,
      0,
      1.151659,
      NULL,
      2.840925,
      52,
      0.152704,
      2.666279,
      NULL,
      63,
      282.318241,
      1,
      0.385268,
      1,
      0,
      0.718473,
      1.034135,
      3.383168,
      NULL,
      1,
      3.182537,
      3.752433,
      1.246740,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      1.864720,
      1,
      0.498651,
      0,
      1.798463,
      NULL,
      0,
      1,
      1.260727,
      1.047491,
      2,
      1,
      2.549882,
      8.855280,
      3.342646,
      0.641225,
      6,
      1.224232,
      1.477285,
      1.459692,
      NULL,
      3,
      2,
      1.290008,
      56,
      0.716091,
      3.315705,
      NULL,
      67.280664,
      11,
      9,
      5.948675,
      1.167997,
      0,
      '40432',
      '',
      '',
      0.651527,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3.599494,
      29.965469,
      148,
      5,
      2.444547,
      2.987430,
      7,
      1.144303,
      1,
      2,
      3,
      1,
      0,
      NULL,
      NULL,
      2,
      3.061857,
      1,
      1.186809,
      NULL,
      NULL,
      0,
      1,
      1.380565,
      NULL,
      NULL,
      1.402663,
      2,
      2,
      1.795085,
      1,
      NULL,
      NULL,
      1.619966,
      1,
      1,
      1.025391,
      0.669805,
      NULL,
      1.261282,
      NULL,
      NULL,
      0.179736,
      NULL,
      NULL,
      NULL,
      7.154299,
      0.316535,
      1.493355,
      1.405989,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.989920,
      2,
      0,
      0.236807,
      1.530807,
      NULL,
      2,
      2.296208,
      NULL,
      3,
      2,
      2,
      1,
      1.451360,
      2,
      3,
      NULL,
      3.223882,
      1.663315,
      2.828877,
      0.068782,
      1,
      2.417963,
      3,
      3.830435,
      1,
      NULL,
      NULL,
      0.181645,
      NULL,
      NULL,
      1.803042,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.455497,
      NULL,
      0.315011,
      NULL,
      1,
      NULL,
      0.438754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.736164,
      2,
      1.304386,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      3.196347,
      0.266603,
      1.228874,
      NULL,
      0.175241,
      3,
      2,
      1.776362,
      0,
      NULL,
      NULL,
      1.345328,
      NULL,
      NULL,
      0,
      2.678655,
      0.334991,
      6.237478,
      NULL,
      1.026378,
      2.294517,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.079498,
      NULL,
      NULL,
      2,
      4,
      2,
      0,
      0.046441,
      NULL,
      1,
      1.814502,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5,
      3.822859,
      1,
      0.762567,
      1.141172,
      NULL,
      2,
      0.038886,
      0.660495,
      1.637224,
      0,
      NULL,
      NULL,
      1,
      3.459567,
      5.685532,
      3.012165,
      5,
      4.702362,
      0.990250,
      1,
      0.610990,
      1.831409,
      NULL,
      0,
      1.947677,
      1,
      0.208225,
      0,
      3.695638,
      NULL,
      NULL,
      3.759548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.756466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425529,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.936195,
      NULL,
      NULL,
      0,
      0,
      1.358411,
      0.198757,
      0,
      2.775837,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.326446,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.766496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.151701,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.249553,
      NULL,
      NULL,
      NULL,
      2.333075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.329282,
      0,
      0,
      NULL,
      NULL,
      0.286970,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.463234,
      152,
      3,
      1.606101,
      NULL,
      NULL,
      0.081611,
      NULL,
      NULL,
      0,
      NULL,
      1.789872,
      205.961030,
      29.830361,
      0,
      NULL,
      0.908929,
      1,
      0,
      0.450890,
      1.652630,
      0,
      0.433854,
      1,
      0.429098,
      1.347825,
      0,
      0,
      0.573105,
      NULL,
      1.802979,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.498767,
      NULL,
      1.265271,
      NULL,
      0.098890,
      NULL,
      3.864363,
      NULL,
      NULL,
      2.444596,
      NULL,
      NULL,
      NULL,
      3.073645,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.619539,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.759334,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.290152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.027369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684809,
      NULL,
      2,
      NULL,
      1.513493,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512533,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      0.958417,
      NULL,
      2,
      NULL,
      1,
      0,
      2.068171,
      18.377280,
      52,
      1.736239,
      NULL,
      NULL,
      NULL,
      0,
      1.696501,
      NULL,
      1,
      1,
      0,
      0,
      2,
      0.278282,
      2.317182,
      3.628764,
      1.832781,
      0.197745,
      3.531567,
      3.962682,
      NULL,
      0,
      2,
      0,
      3.162342,
      0.365453,
      1.054807,
      0.232697,
      1.822114,
      NULL,
      0.041432,
      1.235369,
      1,
      0,
      NULL,
      0,
      1.341127,
      0,
      1,
      0,
      0,
      0,
      0,
      0.167760,
      1.033537,
      0.769730,
      2,
      1.978230,
      1,
      NULL,
      1,
      1.119200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.600678,
      0.044312,
      2.536518,
      1,
      0,
      1.593258,
      1.282089,
      0.426205,
      2,
      0,
      0.054805,
      0,
      1,
      0.840397,
      0,
      3,
      0,
      0.811540,
      1,
      NULL,
      2,
      1,
      NULL,
      2.998496,
      0,
      1.170733,
      45.948560,
      NULL,
      3.973609,
      0.735565,
      0.229051,
      0.169946,
      0,
      1,
      1,
      4.886254,
      4.233316,
      NULL,
      1,
      NULL,
      NULL,
      89.030618,
      45.181660,
      NULL,
      1,
      NULL,
      '30123',
      '11312',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


