set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3341024',
      3.390430,
      0.390548,
      1,
      3,
      '0232',
      1.362135,
      1.865900,
      NULL,
      NULL,
      ' 2- 6-1996',
      25.748483,
      NULL,
      NULL,
      2,
      0.904660,
      ' 6- 2-2003',
      NULL,
      0.207760,
      NULL,
      7,
      1.358988,
      NULL,
      NULL,
      ' 1-10-1975',
      1,
      0,
      3.730918,
      0.175648,
      0.247982,
      0.473075,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.086345,
      3.257780,
      26,
      1.816074,
      1.719915,
      3.714307,
      2.788079,
      NULL,
      0.625958,
      2,
      0.154116,
      0.165129,
      0.479112,
      1.840927,
      0.606829,
      2.968019,
      NULL,
      0.856627,
      0.067427,
      0,
      NULL,
      3.189768,
      NULL,
      1.936486,
      1.212998,
      0,
      0.972987,
      0,
      1.678035,
      1.711741,
      1.468843,
      0,
      NULL,
      1,
      1,
      0.485354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193293,
      1.323143,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381881,
      0,
      0.763469,
      1.945053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.604432,
      1,
      1.711343,
      NULL,
      1.225819,
      0,
      1,
      1,
      0.603359,
      1,
      NULL,
      1,
      0,
      0.300033,
      1.242411,
      1,
      1,
      0.983350,
      NULL,
      1,
      1,
      1,
      1.835676,
      0.773100,
      0,
      0.003679,
      1,
      NULL,
      0.616450,
      NULL,
      1,
      1,
      2,
      1.767737,
      0.696260,
      2,
      NULL,
      1,
      0,
      5,
      NULL,
      NULL,
      3.052138,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.610541,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354641,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.337057,
      0,
      0.270453,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.304249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894904,
      1.706742,
      1,
      1,
      0.992573,
      0.477773,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.661570,
      1,
      2.362815,
      1,
      2.678367,
      0,
      0,
      1.586674,
      1.448276,
      2.479333,
      1,
      NULL,
      0,
      2.298068,
      3,
      3.226420,
      NULL,
      1.040861,
      1,
      NULL,
      0,
      0,
      0.757412,
      1,
      1,
      1,
      1.065973,
      NULL,
      0,
      1.839730,
      NULL,
      1.407673,
      2.872451,
      10,
      1.057908,
      1.384001,
      7.324848,
      7,
      3.255246,
      2.606387,
      4.404383,
      2,
      1.832652,
      2,
      35.088511,
      1,
      0.514036,
      42.310522,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.604383,
      '',
      NULL,
      '',
      2.929711,
      43.669361,
      34.020492,
      43,
      0.438282,
      53,
      NULL,
      0.709314,
      5.743139,
      1,
      NULL,
      NULL,
      2,
      0.890248,
      0,
      0.557118,
      3.175243,
      3,
      1,
      NULL,
      NULL,
      3,
      2.644384,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.228867,
      3,
      1.748411,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.686873,
      0,
      4.227813,
      1.867276,
      1,
      NULL,
      NULL,
      NULL,
      0.398173,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.061311,
      0.490408,
      NULL,
      0.283146,
      NULL,
      NULL,
      0.644853,
      NULL,
      NULL,
      7.703676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276748,
      NULL,
      NULL,
      NULL,
      0.724562,
      NULL,
      NULL,
      1.644176,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.359825,
      NULL,
      NULL,
      NULL,
      0,
      0.802394,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.367036,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      4.528049,
      NULL,
      1.068707,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.369635,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      1.316079,
      1.049605,
      NULL,
      NULL,
      5,
      NULL,
      0.628252,
      1.388404,
      NULL,
      NULL,
      2.306651,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      6.667397,
      2,
      3,
      3,
      1,
      4.734514,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.649063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757459,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.401609,
      NULL,
      NULL,
      0.370115,
      NULL,
      NULL,
      1.028467,
      NULL,
      NULL,
      5.639117,
      NULL,
      NULL,
      3.077073,
      0.430504,
      0.345817,
      1.330098,
      NULL,
      3.171964,
      0.416880,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.514679,
      NULL,
      NULL,
      NULL,
      1.161740,
      1.643000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.809152,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.261457,
      0.020278,
      NULL,
      NULL,
      1,
      0.995665,
      NULL,
      NULL,
      1,
      0.245980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184713,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      6.582742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045667,
      2,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.129059,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.509898,
      NULL,
      NULL,
      1.390796,
      NULL,
      1.551422,
      1168.642674,
      1332,
      0.952238,
      1,
      NULL,
      0,
      0.458000,
      1.268135,
      1,
      1.039390,
      1.368924,
      0,
      1.119501,
      1.986897,
      0,
      1,
      1.141781,
      0.467951,
      0.509535,
      1.965446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0.004868,
      0.629488,
      0.793998,
      3.378075,
      2,
      2.062739,
      1.035493,
      0.900832,
      0,
      1.367653,
      1,
      0.648063,
      NULL,
      0.636292,
      1.735219,
      1.224688,
      3,
      1,
      2,
      NULL,
      1.019936,
      1,
      1,
      1.257832,
      0,
      NULL,
      0.611313,
      NULL,
      0,
      1.934768,
      1.761309,
      0.600235,
      1.513425,
      0,
      0.391288,
      NULL,
      0,
      1,
      NULL,
      0.573536,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631982,
      1,
      0.541590,
      NULL,
      0.433451,
      1,
      3.737321,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      122,
      96.608074,
      5,
      0,
      3.810346,
      '23400',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.002101,
      '',
      '',
      '');
commit;
end;
/


