set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '2313431',
      5.165823,
      0.317567,
      6,
      0,
      '0242',
      3.369300,
      2,
      3.132187,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      3.247470,
      NULL,
      ' 1-11-2002',
      NULL,
      2,
      296.881878,
      61.539311,
      3.592101,
      NULL,
      NULL,
      '10- 2-1991',
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.796992,
      NULL,
      0.220681,
      NULL,
      1.433631,
      0,
      4.963972,
      NULL,
      1.697886,
      NULL,
      28.886912,
      1.229289,
      3,
      2.882940,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.719862,
      4,
      3,
      1.754226,
      1.390527,
      NULL,
      0.578385,
      1.587890,
      1,
      0.572090,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991344,
      0.543351,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691290,
      NULL,
      0,
      1.636704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060797,
      1.494095,
      0,
      1,
      1.863119,
      0.121210,
      1.586605,
      NULL,
      1.808008,
      0.427166,
      1,
      1,
      1,
      0,
      NULL,
      1.420636,
      0,
      1,
      1.545981,
      NULL,
      NULL,
      3.719323,
      NULL,
      0.479443,
      1,
      1.863394,
      NULL,
      2.540104,
      1.188134,
      5,
      1,
      1.219395,
      4.384693,
      NULL,
      0.556040,
      3,
      5.629793,
      NULL,
      6,
      5,
      6.315744,
      0,
      NULL,
      NULL,
      NULL,
      0.465115,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.743155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287315,
      0,
      1.534065,
      1.753229,
      1.631114,
      0,
      1.683821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.206865,
      NULL,
      1.617501,
      2.323145,
      0.515362,
      NULL,
      0,
      2,
      1,
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.073392,
      NULL,
      1,
      4.211876,
      1,
      5.404098,
      1.062016,
      NULL,
      NULL,
      NULL,
      NULL,
      2.230855,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.242030,
      0,
      NULL,
      1,
      0.838035,
      0.038597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.097113,
      NULL,
      NULL,
      1,
      1.575144,
      3.594243,
      0.127707,
      3.518878,
      NULL,
      0.639163,
      2,
      2,
      1,
      0,
      0.988936,
      0.664765,
      2,
      1,
      0.130002,
      1.015763,
      NULL,
      1,
      0.546593,
      0,
      0,
      1,
      1,
      0.240297,
      0.182846,
      9,
      7,
      5,
      1,
      8.311201,
      6,
      0,
      3.843966,
      NULL,
      NULL,
      2.609894,
      3.916325,
      66,
      3,
      1,
      89,
      NULL,
      NULL,
      NULL,
      2.171195,
      0.674153,
      1.887424,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      35,
      NULL,
      23,
      1.359710,
      9.843359,
      12,
      9.674006,
      5,
      1.785501,
      3.201219,
      1,
      0,
      NULL,
      NULL,
      1.567715,
      NULL,
      NULL,
      2.200130,
      3,
      0.738066,
      1.902017,
      0,
      1,
      1.833334,
      NULL,
      NULL,
      0,
      5.360594,
      2,
      0,
      3,
      1.691608,
      0.197044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.540488,
      0,
      NULL,
      NULL,
      10.549492,
      11,
      0.747005,
      NULL,
      1.319828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.610295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.526326,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.716349,
      NULL,
      0.830069,
      NULL,
      1.236934,
      NULL,
      NULL,
      NULL,
      0.639961,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490687,
      2.632540,
      5,
      NULL,
      1.786552,
      0,
      1.673337,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.561627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.395449,
      0.782206,
      1.314987,
      0.619575,
      1,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      3,
      1.414956,
      NULL,
      NULL,
      NULL,
      2,
      2.223438,
      0.678758,
      NULL,
      3.799276,
      NULL,
      3.138929,
      3,
      0.971910,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.806639,
      1,
      NULL,
      NULL,
      0.446274,
      0.030801,
      1,
      NULL,
      3.535672,
      6,
      3.015727,
      2,
      2,
      NULL,
      0,
      NULL,
      2,
      4.209752,
      0,
      0,
      1,
      1,
      1,
      1.887436,
      NULL,
      NULL,
      1.221255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770506,
      NULL,
      NULL,
      1.882634,
      NULL,
      NULL,
      1.976707,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.571262,
      NULL,
      NULL,
      0.181829,
      NULL,
      NULL,
      18.241295,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.265600,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.383047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.921137,
      1.473763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.118703,
      NULL,
      NULL,
      NULL,
      1.146169,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.826806,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.733828,
      0.150730,
      NULL,
      NULL,
      0,
      1.011397,
      NULL,
      NULL,
      NULL,
      1.951080,
      NULL,
      NULL,
      1.290972,
      1.568784,
      NULL,
      NULL,
      0.261270,
      1.084570,
      NULL,
      NULL,
      1.869498,
      1,
      NULL,
      NULL,
      11,
      1,
      NULL,
      NULL,
      0.232364,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      47.157322,
      1.353095,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.856360,
      0,
      0.741941,
      3,
      11.124199,
      13.272445,
      1.396810,
      6.354167,
      0,
      0.033429,
      NULL,
      1,
      NULL,
      289,
      0,
      0,
      1.838771,
      1.355247,
      NULL,
      1.683841,
      1.231046,
      1,
      0,
      0,
      0.488614,
      1.698982,
      1,
      0.401616,
      0,
      1,
      1.662743,
      1.301509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.216899,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.467291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738368,
      1.983002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.613012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.168714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644984,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.559848,
      1.776682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283913,
      7,
      3.637287,
      0.725329,
      NULL,
      NULL,
      0.624625,
      2.108271,
      NULL,
      2.107087,
      1.777135,
      0,
      1.228827,
      2.804970,
      NULL,
      0.519419,
      1,
      0.041946,
      0.901090,
      0.117678,
      0.340319,
      NULL,
      3,
      1.070695,
      0.041173,
      0,
      0,
      1.010504,
      1,
      0,
      NULL,
      1.693798,
      NULL,
      1,
      1,
      2.337664,
      0.177681,
      1.541119,
      0,
      2,
      0,
      1,
      0.736575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.450410,
      NULL,
      0,
      0,
      0,
      1,
      4.043952,
      1.989739,
      3.113250,
      1.559556,
      NULL,
      NULL,
      46.378960,
      NULL,
      1.116748,
      1,
      2,
      '40440',
      '',
      '',
      1.493799,
      NULL,
      '',
      '',
      0.028489,
      '',
      '',
      '');
commit;
end;
/


