set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9510460';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      0,
      7.528954,
      '3244123',
      3.467758,
      0.928931,
      5,
      3,
      '0241',
      3.284394,
      0,
      NULL,
      NULL,
      ' 6- 9-2003',
      76,
      37,
      NULL,
      3.775275,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.186881,
      NULL,
      '11- 6-2000',
      ' 8-23-1980',
      NULL,
      1,
      NULL,
      1.504847,
      NULL,
      NULL,
      3,
      1,
      1,
      2,
      9,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      1.919492,
      0,
      1,
      1.420071,
      0.853503,
      NULL,
      1.689348,
      NULL,
      3,
      1,
      0,
      6.395378,
      2,
      0.488531,
      NULL,
      0,
      0.906114,
      0,
      1,
      1.766816,
      7,
      NULL,
      1.714668,
      NULL,
      3,
      1.312357,
      9.478016,
      1.754721,
      2.800225,
      1.386969,
      0.636698,
      1.202904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      NULL,
      0.214667,
      2,
      2,
      2,
      1.978717,
      2,
      3,
      0.357737,
      0,
      NULL,
      3.754996,
      NULL,
      0.742868,
      NULL,
      1.604021,
      NULL,
      2,
      1,
      NULL,
      3,
      0,
      4,
      1,
      0,
      NULL,
      NULL,
      1.811846,
      NULL,
      NULL,
      0,
      1.617153,
      0,
      0,
      1,
      1.548881,
      2.147867,
      1,
      1,
      0.553607,
      1,
      0.595708,
      NULL,
      2.666447,
      1.339366,
      0.294591,
      NULL,
      1,
      1.009854,
      NULL,
      NULL,
      1.822312,
      1,
      0,
      1,
      0,
      1.591824,
      NULL,
      0.328287,
      0,
      0.720555,
      0,
      1.721392,
      2,
      1.372411,
      NULL,
      NULL,
      0,
      2.096443,
      3,
      2,
      5,
      NULL,
      2,
      1,
      NULL,
      2.886299,
      1.187429,
      NULL,
      345,
      ' 9-21-1998',
      211.600860,
      0.142784,
      0.211027,
      1.087927,
      3,
      1.077964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.645616,
      1,
      NULL,
      NULL,
      NULL,
      0.390113,
      1.798484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.826750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      3.447275,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.002248,
      1,
      3,
      2.177606,
      NULL,
      3.379738,
      1,
      1.828057,
      1,
      0,
      0,
      4,
      3,
      1,
      1,
      1.697841,
      0.219782,
      0.706893,
      0.912053,
      NULL,
      0,
      NULL,
      0.707461,
      0.554422,
      1.697543,
      0.205684,
      0,
      3.671130,
      NULL,
      10.970661,
      5,
      0,
      6.913134,
      NULL,
      3.734552,
      2.800842,
      1,
      5.871108,
      1,
      3.840699,
      NULL,
      42.733918,
      3,
      3.587781,
      52.040058,
      NULL,
      20.667978,
      NULL,
      0,
      4,
      NULL,
      '03120',
      '34223',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      29,
      62,
      28.585714,
      NULL,
      NULL,
      NULL,
      NULL,
      4.795280,
      3.973828,
      0.408104,
      3.581336,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.682289,
      3,
      2.841033,
      NULL,
      2,
      0.656481,
      NULL,
      NULL,
      NULL,
      NULL,
      3.499244,
      3,
      2,
      0.248291,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.736436,
      0.959347,
      0,
      3.511301,
      1,
      0.657335,
      1,
      3.775461,
      3.933498,
      0.367145,
      1.300444,
      NULL,
      NULL,
      NULL,
      1.667869,
      NULL,
      NULL,
      NULL,
      1,
      2.442697,
      1.455730,
      0.948817,
      NULL,
      NULL,
      3.250937,
      2,
      NULL,
      3.827501,
      2.254893,
      NULL,
      2,
      2.873371,
      3.149414,
      2.370426,
      NULL,
      3.754556,
      0.885748,
      1,
      1.387885,
      1.440433,
      1.022739,
      0.564970,
      3.276013,
      3.946887,
      1,
      0.939304,
      1,
      NULL,
      NULL,
      1.359539,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.063834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.539019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.753938,
      NULL,
      NULL,
      0.924107,
      NULL,
      NULL,
      0.040172,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.519956,
      2.488013,
      7,
      6.605044,
      0,
      1.057799,
      NULL,
      NULL,
      0.202919,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      3.736852,
      NULL,
      NULL,
      NULL,
      6.504010,
      3,
      NULL,
      2,
      0.210841,
      3,
      NULL,
      3.646832,
      3,
      NULL,
      NULL,
      2,
      2.875852,
      1,
      2.768572,
      0.164732,
      0.608428,
      6,
      NULL,
      NULL,
      NULL,
      2,
      1.311164,
      1.269735,
      0,
      0,
      NULL,
      0,
      0.903040,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047955,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.411812,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.888420,
      NULL,
      NULL,
      0,
      0.089895,
      0.612849,
      NULL,
      NULL,
      3,
      0.808043,
      NULL,
      5,
      3,
      NULL,
      NULL,
      2,
      17,
      NULL,
      NULL,
      1.116305,
      3,
      NULL,
      NULL,
      0.943507,
      1.900369,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.839323,
      0,
      NULL,
      NULL,
      3.212951,
      NULL,
      NULL,
      NULL,
      1.526474,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.254444,
      NULL,
      NULL,
      NULL,
      1,
      3.962722,
      NULL,
      NULL,
      1,
      1.454880,
      NULL,
      NULL,
      0.698964,
      NULL,
      NULL,
      NULL,
      0.261866,
      0,
      NULL,
      NULL,
      2.058802,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.994335,
      NULL,
      NULL,
      NULL,
      NULL,
      2.156235,
      0,
      3,
      NULL,
      19.770578,
      12.754876,
      2,
      42.867766,
      1.685243,
      NULL,
      NULL,
      NULL,
      2,
      13,
      1,
      0,
      NULL,
      NULL,
      0.284159,
      NULL,
      NULL,
      1,
      NULL,
      0,
      70.317114,
      15,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1.905695,
      0.277331,
      0,
      1.681622,
      1.243915,
      1,
      0.540537,
      0.053871,
      1,
      0.542028,
      0.485874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576533,
      0.982014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.897395,
      NULL,
      1,
      NULL,
      3.268059,
      NULL,
      25,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.893863,
      1,
      2.200769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      200.929321,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.965074,
      NULL,
      1,
      NULL,
      1.131491,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.624605,
      NULL,
      21.005070,
      NULL,
      NULL,
      NULL,
      0.972991,
      NULL,
      1,
      0,
      3.824820,
      6.575031,
      NULL,
      0.182996,
      NULL,
      NULL,
      NULL,
      1.043958,
      NULL,
      0.676659,
      5,
      1,
      NULL,
      4,
      1,
      6.726642,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526589,
      1.551983,
      NULL,
      0.296269,
      0.849746,
      NULL,
      NULL,
      0,
      NULL,
      1.295574,
      0,
      NULL,
      0.119697,
      NULL,
      NULL,
      1.227835,
      0,
      NULL,
      1,
      1,
      NULL,
      0.149275,
      0,
      NULL,
      1,
      1.883939,
      NULL,
      0.989634,
      0.447165,
      NULL,
      NULL,
      0.328308,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      6.247933,
      0,
      0,
      NULL,
      NULL,
      NULL,
      37,
      3,
      3,
      5,
      '13003',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


