set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9103077';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '2320404',
      1.084895,
      NULL,
      1,
      2,
      '4234',
      0,
      0.750725,
      NULL,
      NULL,
      '11-18-1999',
      35,
      NULL,
      0,
      1,
      1,
      ' 8- 5-1976',
      54,
      5.114815,
      261,
      103.019019,
      0.210481,
      ' 7-28-1983',
      ' 8-11-1995',
      ' 7- 9-1984',
      1.083630,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0.435298,
      NULL,
      NULL,
      4.461567,
      18.396464,
      NULL,
      NULL,
      17,
      6.827730,
      0.832309,
      4.187520,
      2.441284,
      7.783764,
      1.280228,
      NULL,
      1,
      0.764082,
      NULL,
      1,
      0,
      0,
      1.059728,
      NULL,
      1,
      1.349577,
      4,
      1,
      1,
      5.380080,
      NULL,
      1.923671,
      NULL,
      0.269455,
      0,
      6,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      3.001729,
      0.340460,
      1,
      3.728900,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.483645,
      1,
      NULL,
      1,
      0.534464,
      NULL,
      0.630645,
      0,
      3.015869,
      0.664998,
      0,
      1,
      1,
      NULL,
      1.473723,
      NULL,
      3.671130,
      0,
      1,
      1,
      0.697436,
      0,
      2,
      0.712662,
      2,
      NULL,
      1.613438,
      NULL,
      NULL,
      1.398419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.524597,
      5.229174,
      1.637860,
      1.860823,
      1,
      0,
      NULL,
      0,
      5.346011,
      NULL,
      1.674936,
      0.313091,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.767859,
      NULL,
      1.062241,
      0,
      1.454564,
      3.023474,
      1.199460,
      2.909519,
      0,
      3,
      NULL,
      1.544716,
      1.800942,
      0,
      5.192881,
      6.361282,
      6,
      NULL,
      7.306660,
      0,
      3.585959,
      NULL,
      1.113891,
      6,
      NULL,
      2,
      ' 4-20-1977',
      NULL,
      ' 4- 7-2000',
      399,
      3.240793,
      1.839510,
      1,
      0.758215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.683006,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.547761,
      2.945477,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.267908,
      3.950257,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.004667,
      NULL,
      0,
      5,
      1.818949,
      NULL,
      NULL,
      NULL,
      0.977357,
      0.646105,
      0.573688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.733272,
      NULL,
      0,
      NULL,
      1.292100,
      0.336739,
      0,
      3.536744,
      129,
      2.795893,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823541,
      1,
      3.284208,
      5.524709,
      3.590625,
      4.820196,
      NULL,
      2.903311,
      2.906492,
      3.632026,
      1.042811,
      5.459278,
      1.604775,
      0.156875,
      1.309639,
      NULL,
      1.916408,
      1,
      2.347598,
      NULL,
      0.239585,
      0,
      0.914551,
      NULL,
      1.823737,
      0.970588,
      1.453302,
      0,
      0,
      1.308889,
      1.493495,
      NULL,
      0,
      4,
      2,
      11,
      3.214006,
      0.287696,
      0,
      NULL,
      0.249906,
      2.983473,
      2,
      46,
      2,
      NULL,
      NULL,
      31.738126,
      18.192237,
      61.396521,
      4.867276,
      1.267337,
      0,
      '32022',
      '40300',
      '',
      NULL,
      '',
      '',
      '',
      1.549502,
      '',
      '',
      '',
      1.127081,
      NULL,
      63,
      1,
      2.205589,
      21,
      5,
      7,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.606921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238712,
      NULL,
      NULL,
      0.912685,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133705,
      2.549682,
      1,
      1.806960,
      3,
      2.006051,
      0,
      2.031354,
      0,
      NULL,
      NULL,
      NULL,
      1.063114,
      0.000626,
      NULL,
      0.304368,
      6,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      3,
      0.083563,
      0,
      0.622370,
      NULL,
      NULL,
      0.872699,
      NULL,
      NULL,
      2,
      0.970911,
      0,
      NULL,
      2.814169,
      3,
      0.580104,
      0,
      0.024713,
      1.567240,
      NULL,
      NULL,
      1,
      3,
      0.899415,
      1,
      0.901733,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.752441,
      5.986189,
      5.449164,
      1.832143,
      0.792768,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621736,
      0,
      0,
      0.044232,
      NULL,
      NULL,
      3.762743,
      0.870181,
      NULL,
      1.319383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      1,
      1.400344,
      0,
      1.519710,
      NULL,
      NULL,
      2,
      2.576090,
      2.010100,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.239358,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.154229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.264940,
      9,
      4,
      2.497325,
      4,
      0.211405,
      NULL,
      0.482068,
      0,
      1,
      3.129700,
      0.694614,
      1,
      3.925182,
      3,
      NULL,
      NULL,
      9,
      3,
      0,
      2,
      0,
      2,
      0,
      2,
      3.657292,
      3.017296,
      2,
      0,
      0.840413,
      1,
      5.528254,
      7.870100,
      1,
      1.150354,
      NULL,
      2.662271,
      3.157104,
      4.747959,
      1.407040,
      0,
      1,
      NULL,
      NULL,
      3.029857,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325677,
      NULL,
      NULL,
      0.455450,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.689912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.849702,
      1,
      0.545733,
      2,
      0,
      NULL,
      7,
      5.840744,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.181631,
      0.118247,
      NULL,
      NULL,
      NULL,
      0.034684,
      NULL,
      NULL,
      0.441525,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.387477,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.084443,
      0.836306,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.922546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.688023,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.775490,
      0,
      NULL,
      NULL,
      10,
      7,
      NULL,
      NULL,
      NULL,
      0.404018,
      NULL,
      NULL,
      NULL,
      1.877692,
      24,
      5.467199,
      1.461942,
      38,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.296078,
      0.802899,
      1.554694,
      NULL,
      NULL,
      1.084522,
      NULL,
      0,
      0,
      NULL,
      0.937433,
      69,
      26.448176,
      0.200644,
      0.314275,
      0,
      NULL,
      1.647774,
      0.484457,
      1.704471,
      1.713120,
      1,
      0.672988,
      1,
      0.963284,
      NULL,
      0.332699,
      1.382983,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.150331,
      NULL,
      0.019281,
      NULL,
      0,
      NULL,
      3.255222,
      NULL,
      NULL,
      NULL,
      3.181923,
      NULL,
      35.844533,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635108,
      NULL,
      0.077028,
      NULL,
      0.159220,
      NULL,
      1.117237,
      NULL,
      0.184614,
      NULL,
      2.000834,
      NULL,
      0.295553,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.688637,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.577570,
      1,
      0.892957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.868236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.681828,
      0.497685,
      0,
      2.744933,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065589,
      0,
      0.657166,
      0.874047,
      1,
      1.178111,
      0,
      NULL,
      0,
      0.740337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965869,
      2,
      NULL,
      1.262543,
      NULL,
      1.937750,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.489947,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.233580,
      1,
      4.792531,
      4.244544,
      4,
      3.499689,
      3,
      1.841733,
      0,
      1.046319,
      NULL,
      0.153815,
      0.930220,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510986,
      NULL,
      NULL,
      3.750539,
      0.867498,
      NULL,
      0,
      0.411887,
      NULL,
      1.054993,
      1.964715,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1.279917,
      1.493921,
      NULL,
      0,
      1.321086,
      NULL,
      3.405612,
      0,
      1.870909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806634,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.424518,
      4,
      NULL,
      3,
      1.467510,
      1,
      8,
      NULL,
      5.351543,
      1,
      3,
      '04412',
      '03311',
      '',
      1.857475,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


