set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42',
      NULL,
      25.742362,
      13,
      '0223242',
      3.486724,
      0.730653,
      2,
      1,
      '0314',
      5.664850,
      0,
      NULL,
      NULL,
      ' 1-23-1980',
      NULL,
      38,
      NULL,
      1.710378,
      NULL,
      ' 3- 1-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      2.348288,
      ' 2- 3-1985',
      ' 5-18-1999',
      ' 9-16-1978',
      0,
      3,
      3,
      NULL,
      0.596390,
      3,
      1,
      NULL,
      NULL,
      8,
      8,
      19.830203,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246507,
      1,
      NULL,
      1.281282,
      7,
      1,
      1.493180,
      NULL,
      1.473862,
      0,
      NULL,
      1,
      0.002088,
      NULL,
      3.916906,
      NULL,
      4,
      3.823646,
      NULL,
      1,
      1,
      6,
      0.766889,
      NULL,
      4,
      NULL,
      6.311559,
      0.188526,
      1.530624,
      1.960375,
      6.821801,
      1,
      2.123759,
      NULL,
      0.911689,
      1,
      NULL,
      NULL,
      0.024824,
      NULL,
      NULL,
      NULL,
      1.167992,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.684668,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656818,
      4.037093,
      1.847853,
      5,
      NULL,
      1.709384,
      0,
      0,
      NULL,
      0.715814,
      0.764207,
      0.306698,
      0,
      NULL,
      0,
      0.847030,
      1,
      NULL,
      NULL,
      0.602187,
      0,
      2,
      1,
      1,
      0,
      2.316833,
      7,
      1,
      0.660135,
      NULL,
      2.469969,
      1,
      4.635944,
      0,
      4.076172,
      6,
      1,
      5,
      4.542254,
      2,
      2,
      NULL,
      6.877597,
      NULL,
      0.159388,
      2.703855,
      3,
      ' 1-26-2002',
      283,
      ' 7-16-1978',
      94,
      3,
      1,
      0.362027,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522036,
      1.416150,
      4.569807,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      11.195193,
      1.795130,
      1.627908,
      1.631684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310575,
      3,
      NULL,
      0,
      0,
      1.490959,
      1,
      NULL,
      NULL,
      0,
      6.518600,
      2,
      1.717100,
      NULL,
      NULL,
      NULL,
      8.972341,
      1.504992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.632088,
      1.535301,
      NULL,
      0,
      1.809783,
      1.126406,
      0.737706,
      4.463102,
      1,
      1.570440,
      NULL,
      NULL,
      NULL,
      1.637333,
      0.447775,
      1.492694,
      0,
      3,
      NULL,
      0.856470,
      NULL,
      1.313842,
      2.847643,
      NULL,
      0.240594,
      3,
      3.971215,
      3,
      2,
      1,
      0,
      0.952628,
      0.653720,
      NULL,
      1.681955,
      1.334638,
      1.427763,
      0,
      0.331355,
      NULL,
      0,
      0,
      0.527142,
      NULL,
      0.909256,
      1.690853,
      9.212550,
      7.685001,
      NULL,
      2,
      4.103351,
      2,
      3.523219,
      0.609608,
      1.405248,
      1.258623,
      0.396839,
      55.010068,
      3.771732,
      2,
      41.748476,
      NULL,
      9.168751,
      44,
      1,
      5.411404,
      NULL,
      '30244',
      '',
      '',
      1.227055,
      '',
      '',
      '',
      3.509065,
      '440',
      '0140',
      '',
      NULL,
      15,
      NULL,
      NULL,
      0,
      41.078240,
      0,
      0,
      NULL,
      NULL,
      1.816555,
      3.572113,
      1.009244,
      NULL,
      NULL,
      0.749487,
      NULL,
      NULL,
      3.955617,
      2.716918,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      1.380306,
      2.128225,
      3.693133,
      2.427542,
      1.186532,
      1.584814,
      1.482240,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.456733,
      NULL,
      NULL,
      2.420118,
      5,
      NULL,
      1,
      1.702815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199975,
      1.056736,
      NULL,
      0.300366,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.253829,
      0.952663,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.558469,
      NULL,
      NULL,
      0.660795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535748,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.460919,
      NULL,
      1.590752,
      3.852043,
      1.587290,
      NULL,
      2.111197,
      NULL,
      NULL,
      0.805050,
      5,
      0.191215,
      1,
      NULL,
      NULL,
      0.077421,
      3.790866,
      0,
      1,
      NULL,
      3,
      3.245379,
      0.413517,
      0,
      0,
      4.291860,
      NULL,
      1.537815,
      2.551051,
      NULL,
      1.351337,
      NULL,
      3.274473,
      3,
      0,
      2.319561,
      NULL,
      3.874506,
      3.796532,
      1.514994,
      7.240638,
      4,
      NULL,
      NULL,
      NULL,
      0.205944,
      NULL,
      2.793432,
      NULL,
      1.559825,
      0,
      0,
      1.575235,
      3.535768,
      NULL,
      NULL,
      0.221980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716084,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.299307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212914,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373329,
      0,
      NULL,
      3.563091,
      1.618698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498495,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.493159,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348945,
      2.923968,
      160.700439,
      NULL,
      NULL,
      NULL,
      0.343017,
      NULL,
      NULL,
      0.832675,
      NULL,
      NULL,
      1.416186,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.778576,
      226,
      1,
      1,
      NULL,
      1.174378,
      0.988018,
      NULL,
      0,
      0,
      0.423729,
      1,
      0,
      0.327430,
      2,
      0,
      1.813737,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      80.079263,
      NULL,
      2,
      7.387818,
      NULL,
      1.336324,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.975488,
      NULL,
      3.337142,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544749,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.341210,
      11,
      3.398205,
      NULL,
      2,
      2,
      NULL,
      3.779369,
      0,
      NULL,
      NULL,
      0.875543,
      NULL,
      2,
      3,
      NULL,
      3,
      2,
      NULL,
      0.915747,
      NULL,
      NULL,
      1.412359,
      NULL,
      NULL,
      1.983308,
      0.343087,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.956663,
      NULL,
      1.408401,
      1,
      NULL,
      0,
      1.530348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524554,
      NULL,
      1.862123,
      NULL,
      0.744892,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.230100,
      NULL,
      3.868485,
      NULL,
      2.936378,
      NULL,
      3,
      NULL,
      1.559972,
      NULL,
      0,
      NULL,
      2.220170,
      NULL,
      0,
      NULL,
      11,
      2,
      NULL,
      NULL,
      NULL,
      1.785573,
      NULL,
      0,
      NULL,
      2.925692,
      9,
      11.798728,
      NULL,
      0,
      3,
      NULL,
      97,
      0,
      NULL,
      2,
      NULL,
      '23204',
      '',
      NULL,
      '',
      '',
      '',
      2.793432,
      '022',
      '2144',
      '');
commit;
end;
/


