set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9936906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.713696,
      3.019122,
      NULL,
      1.697976,
      4.342583,
      2.947865,
      2.521108,
      0,
      '434',
      '10231302',
      12.583678,
      NULL,
      '4342430',
      0,
      1.511542,
      0,
      NULL,
      '1332',
      1,
      1,
      NULL,
      NULL,
      '10-17-1980',
      231.108362,
      14,
      NULL,
      3.086635,
      NULL,
      ' 0-10-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      1.747979,
      NULL,
      ' 7- 5-2000',
      ' 0-28-1982',
      3,
      2.022447,
      0.960701,
      3,
      1,
      NULL,
      0.076630,
      1.426547,
      0,
      0.520531,
      2,
      4,
      9.512674,
      NULL,
      NULL,
      NULL,
      NULL,
      4.453132,
      1,
      NULL,
      1.780661,
      NULL,
      1.370511,
      0,
      0,
      0,
      0,
      0.531830,
      0.267607,
      NULL,
      NULL,
      3,
      NULL,
      1.978754,
      0.310903,
      1,
      0,
      NULL,
      1,
      1.254191,
      0,
      11.232732,
      0.028117,
      2,
      1,
      0,
      0,
      3,
      0.279672,
      4.530589,
      1.522875,
      3.378549,
      1.540219,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.250406,
      0.718649,
      1,
      1,
      NULL,
      0.651196,
      NULL,
      0,
      1,
      0.787032,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.948623,
      NULL,
      0.597796,
      5.751559,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.368043,
      0.313027,
      9,
      0,
      4,
      1,
      1,
      7,
      1,
      3.697376,
      1.629576,
      0,
      1.882721,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.523861,
      0,
      1,
      5.632645,
      2,
      NULL,
      NULL,
      0.772589,
      1.199178,
      0.587267,
      NULL,
      2,
      NULL,
      3,
      NULL,
      7,
      2.114055,
      0,
      1.049759,
      NULL,
      4,
      1.194192,
      1.980764,
      0,
      NULL,
      NULL,
      287,
      ' 1-16-1999',
      195,
      2.843676,
      0.305110,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.839196,
      5.879388,
      6.755955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      10,
      2.737353,
      1,
      2,
      NULL,
      NULL,
      1.542549,
      0.705053,
      NULL,
      4.574154,
      NULL,
      3,
      1.576249,
      1.190882,
      0.422028,
      0,
      3.309464,
      NULL,
      6.038988,
      0.203306,
      1.681639,
      4.761379,
      1.578793,
      NULL,
      NULL,
      1,
      NULL,
      1.814378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.412336,
      NULL,
      0,
      1.642310,
      2.250841,
      0,
      1.859800,
      NULL,
      NULL,
      NULL,
      1.610100,
      0.712899,
      NULL,
      NULL,
      3.153094,
      1,
      NULL,
      NULL,
      0.021166,
      2,
      NULL,
      2.233572,
      0.482840,
      3.182441,
      1,
      3,
      3,
      0.703484,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.304029,
      0,
      1,
      0.003569,
      NULL,
      0.912151,
      5.559144,
      3,
      0.831186,
      5.937020,
      10,
      2,
      2,
      1.085890,
      0.029216,
      2,
      NULL,
      0.490051,
      38,
      2.962016,
      3.154827,
      NULL,
      NULL,
      22,
      71.141164,
      3.666954,
      NULL,
      3.664668,
      '10243',
      '42410',
      '',
      1,
      NULL,
      '',
      '',
      0.141303,
      '',
      '',
      '',
      1,
      17,
      NULL,
      11,
      NULL,
      14,
      0.177144,
      4.103573,
      0,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.417578,
      NULL,
      NULL,
      0.113493,
      NULL,
      NULL,
      1.014781,
      0,
      2.477031,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822957,
      1.314102,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.205625,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988747,
      1.586293,
      3.672722,
      1,
      0,
      1,
      NULL,
      0.403466,
      0.298482,
      1,
      0,
      NULL,
      3,
      2,
      1.777102,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.746115,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.833510,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      3,
      0.640184,
      1.938925,
      NULL,
      1.895089,
      NULL,
      NULL,
      7.906746,
      NULL,
      0.977340,
      0.314378,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360858,
      NULL,
      NULL,
      0.086044,
      NULL,
      NULL,
      1.439399,
      NULL,
      NULL,
      3,
      0.588361,
      0.115970,
      NULL,
      NULL,
      NULL,
      0.501230,
      1,
      1.882474,
      4.417243,
      0.191284,
      1,
      5.028147,
      0.273910,
      NULL,
      3,
      0,
      0.947926,
      2.048012,
      0,
      1.091589,
      1.836151,
      NULL,
      0.989088,
      5.359742,
      4,
      5,
      NULL,
      0,
      1.700825,
      NULL,
      3,
      2.934159,
      2,
      0,
      2,
      1,
      1.393213,
      1.327399,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      6.321778,
      0,
      1.948720,
      1,
      1,
      0,
      3.583952,
      NULL,
      NULL,
      0.610274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121922,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.250505,
      0,
      1.128193,
      1,
      0.768597,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.793220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670886,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.717366,
      NULL,
      NULL,
      NULL,
      1.432208,
      NULL,
      NULL,
      NULL,
      1.614734,
      NULL,
      NULL,
      NULL,
      1.272028,
      NULL,
      NULL,
      NULL,
      0.497007,
      NULL,
      NULL,
      NULL,
      0.150952,
      NULL,
      NULL,
      NULL,
      1.999688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.957439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.694195,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      5.865267,
      0,
      NULL,
      12.438795,
      3.833725,
      NULL,
      1.970194,
      1,
      NULL,
      NULL,
      0.443554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.293808,
      NULL,
      NULL,
      0,
      NULL,
      0.751291,
      NULL,
      5,
      0.435908,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.871921,
      0,
      0,
      0.459459,
      0.552186,
      1,
      0.061597,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.768004,
      NULL,
      0,
      NULL,
      5,
      NULL,
      3.181105,
      14.523329,
      15,
      1,
      2.525321,
      NULL,
      NULL,
      0.797221,
      NULL,
      NULL,
      NULL,
      1.535640,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.196691,
      NULL,
      0.616022,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.740969,
      3.786480,
      0,
      1.143670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987844,
      0.821534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.096559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667364,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.522982,
      3.903954,
      NULL,
      2.875645,
      NULL,
      28.983329,
      NULL,
      0,
      NULL,
      3.157394,
      NULL,
      NULL,
      NULL,
      2.258280,
      1.173450,
      6,
      NULL,
      1.652778,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0.427822,
      0,
      1.876867,
      0,
      2.766603,
      NULL,
      NULL,
      0.626009,
      NULL,
      NULL,
      0,
      NULL,
      0.482155,
      1.536320,
      NULL,
      0,
      1.083586,
      NULL,
      1.065328,
      1,
      NULL,
      3.643709,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.013202,
      NULL,
      1.617828,
      3.241601,
      NULL,
      1,
      NULL,
      NULL,
      1.676363,
      NULL,
      NULL,
      3.292770,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.834945,
      NULL,
      3.639860,
      2,
      4.082745,
      1.929520,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      1,
      NULL,
      '23124',
      '02212',
      '01323',
      0.983918,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


