set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9706710';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '11',
      1,
      5,
      '1100441',
      3,
      0.946381,
      NULL,
      NULL,
      '1430',
      2,
      1,
      NULL,
      NULL,
      NULL,
      15.005842,
      0.791754,
      NULL,
      NULL,
      1,
      ' 8- 0-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      3.854117,
      '10-14-1991',
      ' 8-19-1997',
      ' 4- 5-1990',
      0,
      3.853507,
      0.275334,
      0,
      0,
      1,
      NULL,
      1.202760,
      NULL,
      NULL,
      NULL,
      11,
      3.106939,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.687535,
      NULL,
      0,
      5.339789,
      0.070847,
      0,
      NULL,
      1,
      0.112153,
      1.868794,
      0,
      0.453199,
      0.459013,
      0.251107,
      5,
      2.900011,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      1.604378,
      0.855878,
      1,
      1,
      1.085172,
      0.167564,
      NULL,
      3.402234,
      NULL,
      0.050043,
      3.375346,
      0,
      1.555411,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      0,
      1.248837,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      0.711511,
      NULL,
      0.375683,
      NULL,
      1,
      0,
      1,
      0.458671,
      1,
      NULL,
      0.373954,
      NULL,
      4.474927,
      NULL,
      NULL,
      NULL,
      0.268090,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      0,
      4.241024,
      6.195959,
      0,
      2,
      NULL,
      3,
      1.588234,
      0,
      6,
      1.260470,
      0.108865,
      0.162458,
      0,
      0,
      0.950018,
      2,
      1.840974,
      3.394787,
      0,
      NULL,
      1.746485,
      4,
      1.761863,
      1,
      1,
      NULL,
      1,
      1,
      0.616116,
      NULL,
      NULL,
      3.130070,
      1,
      NULL,
      1.188991,
      7,
      9,
      8,
      NULL,
      1.844482,
      0,
      1.207537,
      3,
      NULL,
      NULL,
      '11-19-1995',
      19,
      NULL,
      1,
      1.377593,
      5.696100,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.048651,
      5,
      NULL,
      4,
      1,
      0,
      0.371197,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.576036,
      5.548425,
      1,
      NULL,
      1,
      0.349569,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.196462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.621420,
      1.868121,
      NULL,
      0,
      1,
      NULL,
      1.618159,
      NULL,
      45,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.172057,
      0,
      2.995318,
      0,
      0.293983,
      NULL,
      1.917381,
      NULL,
      2.778604,
      NULL,
      NULL,
      0.046866,
      3.198199,
      2,
      1.026461,
      1.774209,
      0.208548,
      1,
      0,
      2.089787,
      1.010192,
      1.276578,
      NULL,
      0.468740,
      NULL,
      1.265528,
      1.911931,
      NULL,
      0,
      1,
      3,
      1.287027,
      4.251098,
      6.571676,
      2.996330,
      6,
      1,
      1,
      2,
      1.380676,
      2.662758,
      0.394822,
      0,
      3,
      59.722339,
      2,
      3,
      63,
      NULL,
      NULL,
      75.559464,
      5,
      NULL,
      0.594544,
      '34000',
      '01201',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.423915,
      NULL,
      27,
      47.024848,
      NULL,
      17.120714,
      NULL,
      3.587572,
      4.841353,
      1,
      2,
      1.960308,
      0,
      NULL,
      NULL,
      1.350868,
      NULL,
      NULL,
      3.904225,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.218646,
      NULL,
      NULL,
      0.555139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.493178,
      NULL,
      NULL,
      1.119031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163273,
      NULL,
      NULL,
      8.350011,
      4.583842,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.780695,
      NULL,
      NULL,
      NULL,
      0,
      0.594863,
      0.659855,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.523116,
      1,
      0,
      1.106947,
      NULL,
      0,
      0.083138,
      0,
      2.761250,
      0,
      1.879864,
      NULL,
      NULL,
      3,
      0.011693,
      NULL,
      1.784081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.346930,
      0,
      4,
      1,
      2.336252,
      1,
      1.762990,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787913,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.430677,
      0.908507,
      NULL,
      3.162269,
      3,
      1,
      0.764651,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.343398,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      6.441781,
      3.363555,
      NULL,
      1.937654,
      NULL,
      NULL,
      0,
      2,
      2.599633,
      1,
      5.221472,
      1.071773,
      3,
      NULL,
      2,
      3.493543,
      2.709444,
      0.840215,
      2.988282,
      3.185959,
      0,
      NULL,
      0.685311,
      2.576784,
      1,
      NULL,
      NULL,
      2.531457,
      0,
      2,
      0.742235,
      NULL,
      0,
      2.753960,
      1.023635,
      3,
      1.306614,
      NULL,
      NULL,
      3,
      0.677363,
      NULL,
      9.237464,
      2.558014,
      NULL,
      0,
      3,
      0,
      1.792626,
      3,
      4,
      1.332480,
      1.691085,
      NULL,
      1.339995,
      1,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      1.350834,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.676703,
      NULL,
      NULL,
      3.814000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.652092,
      NULL,
      NULL,
      1.161395,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.578947,
      0.746220,
      0.525101,
      1,
      NULL,
      NULL,
      5.687503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.343158,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488548,
      NULL,
      NULL,
      NULL,
      1.395882,
      NULL,
      NULL,
      NULL,
      3.156629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.687908,
      NULL,
      NULL,
      NULL,
      0.733143,
      NULL,
      NULL,
      NULL,
      0.922189,
      10,
      15,
      2.394550,
      8,
      0.059920,
      NULL,
      NULL,
      NULL,
      3.581786,
      0.159615,
      0.323080,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364591,
      NULL,
      NULL,
      722.589808,
      48.624590,
      0.465223,
      1.667626,
      1.448393,
      0.053213,
      NULL,
      0.390246,
      1.079241,
      1,
      NULL,
      2,
      1,
      0.719377,
      NULL,
      1.679300,
      NULL,
      NULL,
      1,
      2.242290,
      NULL,
      0.270223,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.682843,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      27,
      21,
      0.965235,
      0.589187,
      NULL,
      NULL,
      2.590990,
      NULL,
      1,
      NULL,
      1.102124,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.422522,
      NULL,
      1.872383,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.100165,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.526002,
      2,
      NULL,
      7.586439,
      0.635195,
      1.928410,
      NULL,
      2,
      2,
      NULL,
      1,
      0.462128,
      1.370860,
      0.424970,
      NULL,
      NULL,
      1.056942,
      NULL,
      0.261024,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.606119,
      NULL,
      0,
      1.626954,
      NULL,
      0,
      0.813594,
      NULL,
      0,
      1,
      NULL,
      2.086157,
      0,
      NULL,
      0,
      1,
      NULL,
      0.331640,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958397,
      NULL,
      1,
      NULL,
      1,
      NULL,
      7,
      NULL,
      11,
      NULL,
      1,
      NULL,
      57.927162,
      NULL,
      5,
      NULL,
      NULL,
      '00324',
      NULL,
      '',
      0.518316,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


