set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0003302',
      3,
      0.317945,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-13-1979',
      4,
      NULL,
      NULL,
      2,
      1,
      ' 5-11-1977',
      33.049504,
      1,
      310,
      76.751349,
      1,
      ' 1-19-1993',
      ' 0- 6-1993',
      ' 9-22-1990',
      0.593585,
      1,
      2.162697,
      NULL,
      0,
      3.877794,
      NULL,
      0,
      1.553348,
      1,
      5.232531,
      1.039049,
      NULL,
      3.733599,
      6.605105,
      8,
      16.426674,
      NULL,
      3.937167,
      10.015466,
      NULL,
      NULL,
      NULL,
      0,
      0.655962,
      NULL,
      1.118989,
      10.607094,
      NULL,
      0.600533,
      1,
      1,
      NULL,
      4.067825,
      NULL,
      11,
      0.640863,
      0.395419,
      2.261017,
      5.791414,
      NULL,
      11.167081,
      1,
      1,
      NULL,
      6.747009,
      1.915216,
      8.533189,
      0.916153,
      2.920947,
      0,
      1,
      1.625059,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.822614,
      3,
      2,
      2,
      1,
      3.990665,
      1.602572,
      NULL,
      0,
      NULL,
      0,
      1,
      0.727043,
      2,
      3,
      1,
      2,
      NULL,
      2.049873,
      0.969220,
      1,
      1.513823,
      4.777916,
      NULL,
      5.067609,
      0,
      0.004678,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.258282,
      5,
      4.339230,
      4.660326,
      0.639648,
      NULL,
      NULL,
      NULL,
      3,
      0.807890,
      3.816381,
      0,
      1,
      1,
      1,
      0,
      0.116770,
      0.752698,
      0.669644,
      NULL,
      1.783750,
      3.999146,
      NULL,
      1,
      4.451319,
      NULL,
      3.765977,
      NULL,
      1.106573,
      NULL,
      NULL,
      1.817758,
      0,
      5.229211,
      NULL,
      0.431505,
      NULL,
      5.989009,
      1,
      5,
      7,
      1,
      NULL,
      NULL,
      2.187652,
      NULL,
      1,
      1.162111,
      ' 1-18-1976',
      233,
      ' 1-18-2003',
      52,
      1,
      0.659105,
      NULL,
      4.474545,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.694906,
      4.483032,
      3.245300,
      8,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.147750,
      3.091847,
      2,
      0.452971,
      1,
      2.438990,
      3,
      NULL,
      NULL,
      1,
      2,
      1.393751,
      4.426723,
      0.683420,
      0.923793,
      3.283603,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646729,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.973728,
      0.442981,
      2,
      1,
      0,
      NULL,
      1,
      93.774426,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.089222,
      2.225965,
      NULL,
      3,
      1,
      NULL,
      3.610738,
      1,
      NULL,
      1.113080,
      NULL,
      2,
      1,
      0.886543,
      NULL,
      NULL,
      0.291293,
      NULL,
      1.184875,
      0,
      1,
      0.221334,
      0.044551,
      0.660399,
      NULL,
      0.289826,
      1.572673,
      0.419904,
      0.112183,
      1.397982,
      0.106086,
      NULL,
      NULL,
      7.707890,
      0,
      3.022676,
      4,
      2,
      0,
      5.036127,
      3,
      1.101886,
      NULL,
      38.361462,
      0.646319,
      2,
      NULL,
      35.678552,
      NULL,
      5,
      1.766839,
      1.488220,
      2,
      NULL,
      '',
      '',
      0.596679,
      '',
      '',
      '',
      0.967172,
      '',
      '',
      NULL,
      NULL,
      NULL,
      28.700281,
      9.953520,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.496730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.710466,
      1.129593,
      2,
      NULL,
      1.096632,
      0.847123,
      3.226458,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.982719,
      NULL,
      NULL,
      3,
      0.749112,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      NULL,
      NULL,
      1.869530,
      9.271757,
      7.966341,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.391142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.394909,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.116417,
      0,
      NULL,
      0.705962,
      0.270937,
      NULL,
      1,
      2,
      3,
      NULL,
      1.926705,
      3,
      2.253674,
      0,
      3.011611,
      0.981334,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.371435,
      6.623830,
      1.237437,
      8,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776720,
      0,
      1.881998,
      0.305857,
      2,
      0,
      1.812949,
      3,
      6.788055,
      2.774440,
      7.373808,
      0.200432,
      0,
      2,
      2.641361,
      2.790187,
      2,
      0.483187,
      5,
      2,
      0.122802,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.920787,
      1.247680,
      0,
      0.532356,
      NULL,
      3.660690,
      3,
      5,
      1.789509,
      NULL,
      NULL,
      NULL,
      2,
      1.720861,
      1.379798,
      NULL,
      NULL,
      0,
      1.739396,
      0.115243,
      1,
      3.526277,
      0,
      6,
      1,
      8,
      3.755636,
      0.240873,
      NULL,
      2,
      1,
      2,
      1,
      0.046563,
      0.447225,
      2.663275,
      2,
      3.443072,
      8,
      0.298054,
      6.546124,
      1,
      NULL,
      7.585637,
      1,
      3,
      8.160142,
      NULL,
      0,
      0.352242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025176,
      NULL,
      NULL,
      1.657813,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.295162,
      NULL,
      NULL,
      1,
      1.176464,
      1.097720,
      1,
      0.295399,
      0.060053,
      0.309599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.734060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421889,
      NULL,
      NULL,
      NULL,
      3.131734,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.445264,
      NULL,
      NULL,
      NULL,
      3.090229,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.119794,
      NULL,
      NULL,
      NULL,
      0.817102,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.274781,
      NULL,
      NULL,
      NULL,
      1.992310,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      63,
      6.106698,
      2.908366,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.688093,
      1,
      1,
      NULL,
      NULL,
      1.788391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      1.247857,
      0.755197,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.047086,
      1,
      1,
      1.523159,
      0.432595,
      1.624579,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.457140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.969738,
      3.040803,
      0.890909,
      NULL,
      4,
      2,
      1,
      4.404371,
      0.109382,
      0.324764,
      3.999013,
      0.170801,
      1.071248,
      0,
      NULL,
      1,
      3,
      NULL,
      1.514533,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.657551,
      2,
      NULL,
      0.779606,
      NULL,
      NULL,
      0.744858,
      2,
      NULL,
      1.082350,
      NULL,
      NULL,
      1,
      0.554668,
      NULL,
      0.665132,
      0,
      1.934486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191052,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.730277,
      2.859926,
      0,
      3,
      0.741290,
      2,
      4,
      47,
      NULL,
      1,
      1,
      '34442',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1.817336,
      '',
      '',
      NULL);
commit;
end;
/


