set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7224559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '1402300',
      NULL,
      NULL,
      NULL,
      2,
      '3241',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      NULL,
      3,
      1.069792,
      0,
      ' 2- 7-1975',
      20,
      1,
      114,
      27,
      0,
      ' 7- 2-2000',
      ' 7- 5-2001',
      ' 1-29-1988',
      2.915217,
      1,
      3,
      2,
      1,
      3.790066,
      NULL,
      0,
      NULL,
      0,
      10.508534,
      2,
      1,
      14,
      9.674652,
      3,
      20,
      0.423561,
      0.466397,
      3.415440,
      1.803071,
      4.817195,
      NULL,
      0.633884,
      1.376906,
      NULL,
      0.194324,
      0,
      1,
      1,
      0.582799,
      3,
      5,
      5.714568,
      3,
      4.170426,
      0,
      1,
      2,
      3.310217,
      5.190432,
      3.531910,
      1,
      0,
      0,
      0,
      1.713184,
      4,
      0.489239,
      3.416888,
      NULL,
      0.232948,
      1.890570,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.079307,
      1,
      1.468573,
      1.686204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914029,
      0.844869,
      1,
      1.090505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.081481,
      6.154101,
      NULL,
      3,
      2,
      9,
      9.823273,
      7.140906,
      4.013798,
      6.889740,
      0.506467,
      0.950574,
      4.884730,
      NULL,
      0,
      1.407123,
      NULL,
      1.336627,
      3.718617,
      3.162485,
      0.896291,
      3,
      6.303810,
      NULL,
      7.096504,
      1,
      5,
      0,
      1.248917,
      9.578200,
      6,
      0.583690,
      5,
      8.342020,
      2,
      6,
      8.536488,
      4,
      NULL,
      2.285951,
      6.699899,
      4.887558,
      NULL,
      NULL,
      7.214686,
      NULL,
      4.308031,
      3.790447,
      ' 9-19-1976',
      463.460121,
      ' 5- 2-1979',
      160.148195,
      3.009563,
      0.054761,
      1,
      2.554700,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.475385,
      0.533034,
      12,
      7.385800,
      0,
      NULL,
      3,
      3,
      0,
      7.399179,
      NULL,
      1.649127,
      7.856927,
      3.275085,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152645,
      0.470647,
      NULL,
      1,
      1.890952,
      0.804100,
      1.606676,
      0.478292,
      113.643676,
      0.253162,
      0,
      34.350973,
      NULL,
      45,
      1,
      0.948827,
      NULL,
      2,
      3,
      1.858714,
      0.995256,
      3,
      0,
      0.788577,
      2,
      1,
      1,
      0.031416,
      2.776855,
      2,
      1.253560,
      1.979342,
      1,
      1,
      1.798427,
      0,
      0.388256,
      1.396116,
      1,
      0.988835,
      0,
      NULL,
      1.596953,
      1.625527,
      NULL,
      1,
      NULL,
      8,
      6.533227,
      2,
      9.042128,
      5,
      2,
      NULL,
      7.288568,
      NULL,
      0,
      NULL,
      39.524339,
      2.788476,
      3,
      NULL,
      9.000304,
      NULL,
      68,
      5,
      0,
      2.187254,
      '20311',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.329183,
      '13442',
      '',
      NULL,
      NULL,
      27,
      42,
      31.762970,
      NULL,
      9.432744,
      NULL,
      7.158909,
      1.727531,
      NULL,
      0.227121,
      2,
      0.460896,
      NULL,
      NULL,
      1.500703,
      NULL,
      NULL,
      0.390942,
      0.678454,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.005476,
      1,
      2.154499,
      0,
      NULL,
      NULL,
      0.616488,
      NULL,
      NULL,
      0.432643,
      NULL,
      NULL,
      1.387383,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533618,
      2,
      0,
      2.660403,
      2.835022,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.262106,
      0,
      1.964715,
      1.609645,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.151386,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0.963727,
      3.175970,
      0.294663,
      1.366256,
      2,
      1.038216,
      1.851175,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.019693,
      7.346999,
      1.437440,
      0.313559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.268465,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      1.702068,
      0,
      6,
      NULL,
      1.825734,
      2.892519,
      1.347428,
      1,
      NULL,
      NULL,
      3,
      9.518919,
      6,
      1.282153,
      NULL,
      NULL,
      0.023714,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.524358,
      NULL,
      NULL,
      3,
      0,
      0,
      3.479570,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.405177,
      0,
      0.712221,
      8,
      3.772001,
      7,
      3,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1.114356,
      1.063356,
      3.478998,
      2.102113,
      1.145017,
      1,
      1.825424,
      3,
      2.289077,
      10,
      10,
      8.404538,
      1,
      1.212835,
      0.711588,
      2,
      2.813103,
      0,
      NULL,
      NULL,
      3.705472,
      2,
      2,
      3.109389,
      3,
      2,
      1.569668,
      6,
      8,
      4,
      NULL,
      1,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.763267,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.613989,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.321890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.550038,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1.392151,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923002,
      NULL,
      NULL,
      NULL,
      3.334130,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.031204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.873203,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7.573947,
      NULL,
      1.029218,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.005409,
      3,
      1.080505,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.120575,
      NULL,
      1.087542,
      394.450662,
      5,
      1.632342,
      0.685153,
      1.749337,
      1.395779,
      0,
      1,
      1.493264,
      NULL,
      0,
      NULL,
      0,
      0.474771,
      1.575642,
      NULL,
      0.347644,
      0.332645,
      0.024270,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.713418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.303524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.112156,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.832214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.030184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1.363417,
      NULL,
      NULL,
      NULL,
      1.969387,
      NULL,
      1.609955,
      NULL,
      1.024975,
      NULL,
      0.641091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.413665,
      9,
      0.707100,
      4.733718,
      5,
      5,
      12.196480,
      1,
      2,
      1.323544,
      1,
      1.243941,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.283324,
      NULL,
      NULL,
      2.089531,
      NULL,
      1.858636,
      2.685044,
      NULL,
      3.402547,
      NULL,
      NULL,
      0.009178,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.789218,
      1.360325,
      0.786961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511057,
      NULL,
      1,
      NULL,
      0,
      NULL,
      6,
      3,
      11,
      1.197233,
      0,
      NULL,
      26,
      85,
      5.111661,
      1.740545,
      1,
      '33100',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      3,
      '04314',
      '',
      NULL);
commit;
end;
/


