set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714445';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '0142440',
      2,
      0,
      0,
      NULL,
      '3133',
      0,
      2.110512,
      5,
      5.250848,
      NULL,
      15.482288,
      NULL,
      5,
      0.487722,
      1.253068,
      NULL,
      119,
      0.122026,
      276,
      120,
      0.971665,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.419824,
      1,
      1,
      0.472616,
      4.658004,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      5.846235,
      1.750842,
      0,
      23,
      0,
      NULL,
      6,
      1,
      1,
      3,
      0.306821,
      1.138536,
      1.424480,
      0.859435,
      NULL,
      0.553352,
      0,
      NULL,
      0,
      3.893215,
      NULL,
      0.314035,
      2.562526,
      1,
      NULL,
      1.494839,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1.565768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418605,
      1.958188,
      1.016617,
      1.956063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090540,
      0.807301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007540,
      1.066034,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0.480826,
      0,
      0.223854,
      0.518473,
      NULL,
      NULL,
      1.922056,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.494290,
      0.241945,
      NULL,
      0.890988,
      NULL,
      1,
      0.287063,
      1,
      1.121055,
      NULL,
      0.888806,
      0,
      1,
      1,
      NULL,
      4.192448,
      6.276165,
      0,
      6.290717,
      NULL,
      0,
      0,
      1.833200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223609,
      1.610713,
      1,
      0,
      1.253289,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      4.976511,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.119596,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.997856,
      0.077497,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      1.828268,
      NULL,
      1.869115,
      5.629046,
      0.605829,
      5,
      5.246224,
      NULL,
      3.007856,
      NULL,
      4.111967,
      0.701860,
      1,
      4.934076,
      1.848269,
      1,
      NULL,
      0,
      1.664719,
      5.111949,
      1.323198,
      1,
      0.420285,
      NULL,
      1,
      1,
      7.506518,
      NULL,
      0.363596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      35,
      NULL,
      NULL,
      NULL,
      6.723804,
      1,
      0,
      '24212',
      '01020',
      NULL,
      0.816746,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      3.047490,
      8,
      722.652674,
      32,
      2,
      56,
      6,
      6,
      2.814295,
      0,
      12,
      NULL,
      3.675231,
      4.939599,
      3,
      1.402514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794865,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.931486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.536169,
      1,
      5.207554,
      0.781472,
      0.432266,
      NULL,
      NULL,
      NULL,
      1.136712,
      2.404204,
      NULL,
      16.369958,
      0.948396,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881862,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.108023,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.874992,
      NULL,
      NULL,
      0.060945,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594872,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.327848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      8.235736,
      1.552596,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      3,
      4,
      NULL,
      1.692756,
      NULL,
      NULL,
      3.516337,
      5.494122,
      19,
      3.569003,
      2,
      NULL,
      2.952074,
      1,
      0,
      2.016612,
      1.518307,
      2.620684,
      7,
      1.819883,
      1,
      1.673992,
      NULL,
      NULL,
      0,
      0.170037,
      0.060068,
      0.661555,
      0.369807,
      0.992279,
      0,
      1,
      0.117128,
      NULL,
      NULL,
      1.031077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984657,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.252040,
      2,
      2,
      1,
      NULL,
      1.674584,
      0.368245,
      NULL,
      3.203562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.882164,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.663110,
      NULL,
      NULL,
      NULL,
      9.005842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.265291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.783435,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.356199,
      NULL,
      NULL,
      NULL,
      1.781127,
      1,
      1,
      1.772541,
      705,
      1450.222241,
      NULL,
      NULL,
      NULL,
      0.450335,
      NULL,
      NULL,
      0.231091,
      0,
      0.578259,
      0,
      NULL,
      NULL,
      3.965740,
      NULL,
      0,
      15001.332558,
      0.064732,
      0.306139,
      1.282335,
      1.109122,
      1,
      1,
      1.882160,
      NULL,
      1.009303,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1.377218,
      NULL,
      1.956167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.959206,
      2.745131,
      1.442459,
      7.584619,
      1.309150,
      1.555288,
      3,
      3,
      8.294402,
      1,
      2,
      1.090924,
      1,
      1,
      1.778051,
      18,
      0,
      2,
      7,
      4,
      NULL,
      1.954137,
      0,
      0.990117,
      13.200940,
      5.448212,
      1,
      1,
      NULL,
      1.951427,
      0.900133,
      1.161931,
      1.080893,
      NULL,
      NULL,
      0.467162,
      NULL,
      1,
      0.711778,
      6,
      5,
      16,
      1,
      NULL,
      0.204181,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.779443,
      0.773633,
      1,
      0.446402,
      2.829656,
      2,
      10.969405,
      2,
      0,
      1,
      57.204979,
      NULL,
      9.034274,
      0,
      3.940197,
      NULL,
      '41234',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


