set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9756185';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      0,
      0.406917,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      47,
      NULL,
      '4021403',
      1,
      0.772680,
      NULL,
      2,
      '4412',
      1.577179,
      1,
      NULL,
      NULL,
      ' 8-10-1975',
      1.930933,
      14,
      NULL,
      2,
      0,
      ' 3- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 2-12-1992',
      0,
      0.576795,
      0,
      1.636968,
      0.982856,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      6.328704,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.830419,
      1,
      NULL,
      2.120515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.151860,
      NULL,
      1.634457,
      NULL,
      0.960537,
      0,
      1.535367,
      NULL,
      1,
      5,
      NULL,
      4.349552,
      0,
      2.137945,
      0,
      4.620298,
      0,
      1.784125,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.734076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3.298617,
      NULL,
      NULL,
      0.824100,
      0.340306,
      NULL,
      NULL,
      0.601645,
      NULL,
      NULL,
      1.743929,
      1.865563,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1.711269,
      1,
      1.120655,
      0,
      0,
      NULL,
      0.830972,
      0.283667,
      0,
      NULL,
      0,
      7,
      1,
      1,
      0,
      1,
      7,
      2,
      6.864682,
      0,
      1.838520,
      1,
      NULL,
      7,
      NULL,
      1,
      0,
      NULL,
      5.746581,
      4.101888,
      6.506652,
      3.304848,
      7.868187,
      NULL,
      3,
      1,
      4.871516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.564330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1.081947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362768,
      0.227795,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.778854,
      0,
      1,
      1,
      3.463334,
      5.848757,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.945317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.714889,
      0,
      0.111283,
      1.900715,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.632304,
      1,
      3.322781,
      3,
      0,
      3.649671,
      NULL,
      NULL,
      0.607077,
      NULL,
      0.890625,
      1,
      0.937484,
      3,
      0.414136,
      1.839315,
      1,
      0,
      NULL,
      1.898336,
      0.979426,
      NULL,
      1,
      0,
      0,
      0.098537,
      NULL,
      0,
      NULL,
      0.592864,
      1,
      NULL,
      NULL,
      1,
      0,
      9,
      3,
      NULL,
      NULL,
      3.564295,
      1.967813,
      NULL,
      3.291923,
      0.628256,
      21.230058,
      NULL,
      NULL,
      8.431503,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.376610,
      '4143',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      0.244281,
      '',
      '',
      '',
      1,
      NULL,
      19.255206,
      19,
      1.435972,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.126897,
      NULL,
      1,
      NULL,
      NULL,
      0.293704,
      NULL,
      NULL,
      0.257832,
      NULL,
      NULL,
      0.314219,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373142,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.409502,
      4,
      1.431026,
      1,
      NULL,
      NULL,
      NULL,
      0.918281,
      NULL,
      NULL,
      NULL,
      3,
      1.274949,
      NULL,
      0,
      NULL,
      NULL,
      0.846393,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605041,
      NULL,
      NULL,
      0.951521,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.550652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194077,
      NULL,
      NULL,
      0.949475,
      NULL,
      NULL,
      0.793032,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.763481,
      NULL,
      NULL,
      1.831711,
      NULL,
      NULL,
      1.308325,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.399917,
      NULL,
      NULL,
      0.595541,
      NULL,
      NULL,
      1.300623,
      NULL,
      NULL,
      2,
      NULL,
      1.601693,
      1,
      NULL,
      NULL,
      2,
      5.937967,
      3,
      1.027639,
      NULL,
      7,
      1.812098,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.473544,
      NULL,
      NULL,
      3.210627,
      3.441723,
      0.561961,
      NULL,
      NULL,
      4,
      0.830222,
      0.863308,
      NULL,
      NULL,
      3,
      0,
      2,
      NULL,
      3.724457,
      2.451737,
      1.310073,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      5.046076,
      NULL,
      NULL,
      NULL,
      1.543368,
      1,
      0.489027,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.278385,
      1,
      1,
      0,
      0,
      0.492825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440514,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.558715,
      1,
      NULL,
      NULL,
      1.993135,
      NULL,
      NULL,
      0.934288,
      NULL,
      NULL,
      0.658350,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.051662,
      NULL,
      0,
      23,
      1.052833,
      1.143819,
      1,
      0.917135,
      0.575879,
      0.501753,
      1,
      1.827833,
      NULL,
      NULL,
      0,
      0.516422,
      NULL,
      1,
      0.771261,
      0.084986,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.486082,
      1,
      0,
      NULL,
      NULL,
      1.103054,
      1.186360,
      NULL,
      NULL,
      0,
      0.688635,
      1.944881,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.473096,
      NULL,
      NULL,
      0.579977,
      NULL,
      NULL,
      0.758881,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.793467,
      NULL,
      NULL,
      1.806322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.316755,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.737792,
      NULL,
      0.144075,
      0.804099,
      3.130176,
      NULL,
      NULL,
      NULL,
      91.100791,
      NULL,
      4,
      2,
      0,
      '4010',
      '',
      NULL,
      1.647350,
      '',
      '',
      '',
      0.737634,
      '',
      '',
      '');
commit;
end;
/


