set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      '13',
      25.809473,
      34,
      '0244111',
      1,
      NULL,
      5,
      1,
      '3304',
      1.777933,
      1.677455,
      NULL,
      NULL,
      NULL,
      NULL,
      9.705577,
      NULL,
      2.456992,
      2,
      ' 9-10-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 1-27-1983',
      1.685360,
      1.525418,
      3.554337,
      3,
      0.395003,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.051097,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.164108,
      2.424223,
      1.622830,
      1.311975,
      0,
      0.338060,
      0.951314,
      NULL,
      7.296595,
      NULL,
      1.512176,
      0.895516,
      0.379098,
      1.813707,
      6,
      0,
      2,
      1.939240,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.884728,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122575,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652500,
      1.047570,
      0,
      1.425934,
      1.393453,
      NULL,
      1.163851,
      0.184134,
      0.928563,
      0,
      0,
      NULL,
      1.684080,
      1,
      NULL,
      1.899221,
      0,
      0,
      NULL,
      1.103194,
      5,
      NULL,
      0.635317,
      NULL,
      NULL,
      2,
      2.931227,
      1,
      0.287753,
      NULL,
      1.447115,
      NULL,
      NULL,
      0.120249,
      5.572493,
      NULL,
      0,
      NULL,
      6.036305,
      1,
      NULL,
      6,
      4,
      0,
      5.351482,
      NULL,
      0,
      ' 3-23-1992',
      112.636185,
      ' 2-25-1977',
      93.963082,
      1,
      0.121552,
      1,
      NULL,
      1.416288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.779262,
      1,
      1,
      0.509783,
      1.391590,
      0.352147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.302669,
      NULL,
      9.878258,
      0.405531,
      1,
      1,
      2,
      3.477593,
      0,
      1,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839438,
      6.121897,
      5.337392,
      2,
      1,
      0.839315,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.958577,
      0.389603,
      0.660972,
      1.608334,
      NULL,
      0,
      0.326262,
      0,
      NULL,
      2.474130,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      2.671812,
      0.378493,
      NULL,
      2.017489,
      1.613045,
      NULL,
      NULL,
      2.348030,
      1.943030,
      NULL,
      NULL,
      1,
      0.770027,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      2.128949,
      1.893566,
      3,
      NULL,
      6.545435,
      NULL,
      9,
      6,
      3.708425,
      0.245611,
      NULL,
      0.628302,
      3,
      1,
      6.040262,
      3.940407,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.796502,
      2.937543,
      1,
      '02244',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.664774,
      34,
      85.909645,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1.196214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.644284,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.365321,
      NULL,
      NULL,
      3.083594,
      3,
      1,
      0.755750,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.663498,
      NULL,
      NULL,
      0.885815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      5.438963,
      4.863766,
      0.327396,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904639,
      NULL,
      NULL,
      NULL,
      1.682845,
      NULL,
      NULL,
      0.086244,
      NULL,
      NULL,
      0.535416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.674686,
      NULL,
      NULL,
      1.408640,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841956,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.451061,
      NULL,
      NULL,
      0.143974,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.318435,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.844261,
      2.584291,
      1.840898,
      0.405519,
      NULL,
      NULL,
      5.623149,
      1,
      0,
      1.573542,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.896301,
      1.359931,
      1.699768,
      3,
      0.140158,
      0.682103,
      3,
      4,
      1,
      1.525752,
      3.980864,
      3.615388,
      0,
      2,
      2.794312,
      2.610731,
      NULL,
      0.998462,
      2.643964,
      0,
      0.054679,
      1.253917,
      1,
      7.656122,
      6,
      4.880806,
      4.212360,
      NULL,
      NULL,
      1.100710,
      2.367639,
      1,
      0.858290,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.451252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.776667,
      NULL,
      NULL,
      3.509362,
      NULL,
      NULL,
      2.932538,
      3.160649,
      2,
      0,
      0.432384,
      1.945287,
      0.058848,
      NULL,
      7,
      1.577414,
      NULL,
      NULL,
      231.671301,
      NULL,
      NULL,
      NULL,
      1.509455,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.538395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457535,
      3.295225,
      NULL,
      NULL,
      NULL,
      0.004395,
      NULL,
      NULL,
      NULL,
      0.179291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.169348,
      NULL,
      NULL,
      NULL,
      1.311890,
      1.550164,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.431159,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0,
      2.537896,
      NULL,
      NULL,
      0,
      0.290238,
      NULL,
      NULL,
      2.878940,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      26.537328,
      3,
      0,
      4.479880,
      NULL,
      1.097176,
      NULL,
      NULL,
      0.328060,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      496,
      1.361495,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.344558,
      1,
      0,
      1.308448,
      0.180006,
      0,
      NULL,
      0.431250,
      1.345410,
      0,
      0.842901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      0.240647,
      0.517647,
      4.875863,
      3,
      NULL,
      0,
      1,
      0.775105,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.009257,
      3.807820,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.192324,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2.852405,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0.642860,
      2,
      NULL,
      3.634227,
      1.425449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795679,
      NULL,
      NULL,
      1.048088,
      NULL,
      0.955955,
      NULL,
      3,
      NULL,
      1.439410,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.867622,
      NULL,
      NULL,
      NULL,
      0.685455,
      NULL,
      3.427128,
      NULL,
      1,
      NULL,
      29.942386,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.396517,
      NULL,
      4,
      4.045051,
      0,
      1,
      NULL,
      NULL,
      55,
      55.120955,
      0.787564,
      NULL,
      3.936603,
      '21213',
      NULL,
      NULL,
      0.683434,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


