set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630558';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.025001,
      3,
      6.518024,
      2,
      1,
      0.541074,
      NULL,
      2,
      NULL,
      '20004301',
      42.167038,
      69,
      '2322212',
      2.848519,
      1,
      0,
      2,
      NULL,
      4,
      1,
      NULL,
      NULL,
      ' 3-22-1976',
      20,
      35,
      NULL,
      NULL,
      1,
      ' 4-22-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3- 9-2001',
      ' 0-20-1985',
      ' 2-20-1981',
      1,
      NULL,
      0.361025,
      1,
      1,
      1.904096,
      2.668602,
      3.170818,
      NULL,
      NULL,
      NULL,
      9.789662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.224085,
      2,
      NULL,
      NULL,
      0.239743,
      0.742620,
      1.653151,
      1,
      1,
      0,
      1.680189,
      NULL,
      1.534054,
      0.333627,
      3,
      4,
      2.997101,
      2.873100,
      6,
      1,
      4,
      1,
      0,
      1,
      6.653052,
      3.722191,
      3,
      NULL,
      0.878054,
      NULL,
      7.403472,
      0.451046,
      NULL,
      3,
      5,
      1,
      NULL,
      NULL,
      0.709579,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      NULL,
      1.985511,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.573613,
      NULL,
      3,
      1,
      1.664302,
      3,
      0.816050,
      3,
      0.807796,
      1,
      NULL,
      2.728651,
      1,
      4.267367,
      3,
      0.249854,
      NULL,
      NULL,
      1.663067,
      NULL,
      NULL,
      0.074361,
      5,
      0.439071,
      5,
      6.913412,
      2.028945,
      5.656453,
      1.165868,
      1,
      2,
      0,
      4.584668,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.877748,
      1,
      1,
      5,
      1.889319,
      0,
      NULL,
      1.372520,
      0.015555,
      3.025175,
      0.172095,
      NULL,
      4.014814,
      5.076187,
      6,
      5.759140,
      2.705816,
      3,
      1.230846,
      5,
      NULL,
      NULL,
      0,
      3.029625,
      ' 2-11-1995',
      407,
      ' 0-10-1997',
      45,
      3,
      0,
      0,
      1.195842,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.506603,
      0,
      0.563323,
      0.943819,
      0.203181,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.886959,
      NULL,
      2.053662,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.328701,
      2,
      1.373631,
      NULL,
      NULL,
      NULL,
      1.094430,
      NULL,
      0,
      NULL,
      1,
      7.613462,
      2.442571,
      1.870691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384479,
      2,
      1.623877,
      2.592481,
      3,
      0,
      NULL,
      3,
      4.070023,
      1,
      0.389693,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.594813,
      3.444500,
      NULL,
      1,
      3.747251,
      3,
      0,
      3,
      2,
      2.970232,
      2.851458,
      3,
      1.633247,
      3,
      2,
      1.949330,
      0.617068,
      0.697893,
      0.013221,
      NULL,
      1,
      0.444799,
      0,
      1.647031,
      1.056795,
      NULL,
      1,
      0,
      3,
      0.162670,
      10.305792,
      10.052234,
      0,
      8,
      NULL,
      2,
      3,
      1.354957,
      4.203108,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      4.459719,
      NULL,
      42.082301,
      9.561732,
      5.904682,
      0.249471,
      NULL,
      '31141',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1,
      29,
      50,
      18,
      0.345475,
      28.387177,
      1.581644,
      NULL,
      3.485957,
      2.597748,
      1.253799,
      0,
      0.236059,
      NULL,
      NULL,
      3.743708,
      0.541381,
      1.456105,
      0.257605,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      0.280081,
      1,
      0,
      1.822811,
      0,
      1.669081,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.210726,
      7.820628,
      NULL,
      1.611504,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.608947,
      0.626098,
      2,
      1,
      NULL,
      NULL,
      1.625498,
      0,
      0,
      0.907503,
      1,
      0,
      0.869264,
      0.993961,
      NULL,
      NULL,
      0.753715,
      0,
      1,
      2.115530,
      0,
      0,
      0.136897,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.046293,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5.022150,
      4.508403,
      1.215492,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647799,
      NULL,
      NULL,
      NULL,
      NULL,
      2.988279,
      3.110192,
      NULL,
      NULL,
      0.413329,
      NULL,
      0.129118,
      0,
      1.411669,
      NULL,
      NULL,
      NULL,
      5,
      4.850001,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.527541,
      6.370427,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522072,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.056383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.629330,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      2.878083,
      1,
      NULL,
      NULL,
      7,
      3.373082,
      3,
      3.682314,
      3,
      3.394703,
      0,
      3,
      2,
      2.135381,
      3.911687,
      2.885805,
      NULL,
      NULL,
      1.037038,
      0.983871,
      2.351838,
      NULL,
      4,
      2.341559,
      1.124212,
      2,
      2,
      3,
      1.946901,
      1.658077,
      0.435868,
      0.325650,
      NULL,
      1.748402,
      NULL,
      NULL,
      5.530015,
      NULL,
      NULL,
      16.936966,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797756,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.044060,
      NULL,
      NULL,
      1.447027,
      NULL,
      NULL,
      1.874749,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2.569631,
      1.908632,
      0,
      1.629710,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934905,
      NULL,
      NULL,
      NULL,
      3.573492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.078170,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355890,
      NULL,
      NULL,
      NULL,
      1.792754,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.689233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.914492,
      NULL,
      NULL,
      NULL,
      0.442941,
      NULL,
      NULL,
      NULL,
      1.252277,
      NULL,
      35.166678,
      3.197128,
      0.638840,
      6,
      NULL,
      NULL,
      NULL,
      3,
      17.189402,
      2,
      0,
      21.581366,
      4,
      0.722170,
      NULL,
      NULL,
      0.862696,
      NULL,
      1,
      1,
      0.567391,
      NULL,
      0,
      1.286846,
      0,
      0,
      0,
      1.177656,
      0,
      0.627558,
      NULL,
      1.607596,
      NULL,
      0,
      1.834327,
      0,
      1,
      0,
      1.344566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.572066,
      1.458451,
      NULL,
      4,
      NULL,
      2.134452,
      NULL,
      5,
      1.077760,
      3,
      1.984662,
      1,
      0.453571,
      2,
      NULL,
      1.167140,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0.773436,
      NULL,
      0.586231,
      0.163029,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.382668,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.997617,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.257860,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.838862,
      NULL,
      0.634011,
      NULL,
      1,
      NULL,
      1.056191,
      NULL,
      19.103058,
      0.258164,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239368,
      NULL,
      1.222972,
      NULL,
      0,
      NULL,
      1,
      NULL,
      7.286830,
      NULL,
      NULL,
      NULL,
      67,
      16.353130,
      1,
      NULL,
      2.516078,
      '44211',
      NULL,
      '',
      1.145815,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


