set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9879235';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      3,
      5.079390,
      1.292181,
      5,
      1,
      1,
      NULL,
      '232',
      '23244430',
      49,
      44.157340,
      NULL,
      3.816444,
      NULL,
      NULL,
      0,
      '2002',
      4,
      0.402260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.161333,
      ' 7- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1983',
      ' 5-23-1976',
      NULL,
      2,
      NULL,
      0,
      1,
      1.122490,
      0.241573,
      NULL,
      0,
      1.615832,
      NULL,
      11,
      2,
      1.581659,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835382,
      1,
      NULL,
      1.774050,
      2,
      1.531996,
      1.308871,
      1.292704,
      1,
      0,
      0,
      7.582973,
      NULL,
      0.730811,
      2.129313,
      NULL,
      NULL,
      0,
      0.113227,
      NULL,
      0.914468,
      0,
      1.604888,
      NULL,
      2.195246,
      1.732519,
      NULL,
      0.783956,
      0.883921,
      0,
      3,
      0.698138,
      3,
      0,
      0.378291,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.823392,
      1.534103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.690882,
      NULL,
      3,
      2.943336,
      0.344698,
      1.529501,
      1,
      0.842955,
      0,
      NULL,
      1,
      0.887123,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0.056358,
      5,
      NULL,
      0.901299,
      1.566177,
      0.361425,
      1.878623,
      4,
      0.738134,
      NULL,
      1,
      4.039944,
      NULL,
      4.909407,
      0,
      3,
      9.836511,
      7,
      7,
      8.061235,
      7.093140,
      NULL,
      1.422299,
      4.842604,
      2,
      3,
      4.670781,
      3,
      ' 8-15-1978',
      56.881215,
      ' 4- 9-1982',
      NULL,
      1.889548,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.520055,
      0.638517,
      0.589996,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.891034,
      NULL,
      5.720719,
      0.669595,
      1,
      2.387612,
      1,
      1.225095,
      NULL,
      1.387313,
      2,
      2,
      1.056951,
      0.842598,
      0.587440,
      2.858938,
      1.057887,
      1,
      0,
      0,
      6.091736,
      0.561045,
      NULL,
      0.885445,
      NULL,
      NULL,
      NULL,
      3.956352,
      4.450397,
      0.626451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.578080,
      0.155811,
      NULL,
      3,
      0.402176,
      0,
      0.520239,
      1.752596,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.590343,
      0.975638,
      3.944031,
      3.386499,
      2,
      2,
      NULL,
      3,
      NULL,
      1.732136,
      2.312630,
      2,
      NULL,
      2.513139,
      3.787005,
      0.592557,
      NULL,
      NULL,
      0.133670,
      NULL,
      0,
      NULL,
      0,
      1.938105,
      1.135942,
      0.498915,
      1,
      1.126863,
      NULL,
      1.730189,
      0.685573,
      1.529057,
      1.725557,
      0,
      5,
      NULL,
      10,
      0,
      NULL,
      NULL,
      3.443715,
      1.376344,
      2.375843,
      2,
      31,
      2,
      1.468005,
      NULL,
      NULL,
      NULL,
      27.073285,
      4.913919,
      NULL,
      0,
      '01421',
      '',
      '',
      3.678351,
      NULL,
      '',
      '',
      3,
      NULL,
      '',
      '',
      NULL,
      8,
      0.599325,
      NULL,
      0.558499,
      NULL,
      NULL,
      NULL,
      NULL,
      3.194231,
      2,
      2,
      0,
      NULL,
      NULL,
      1.080045,
      NULL,
      NULL,
      0.670222,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.044244,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.092652,
      2.796441,
      2,
      0.942856,
      0.899104,
      NULL,
      NULL,
      NULL,
      1.070489,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227426,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776369,
      NULL,
      NULL,
      1.283760,
      NULL,
      NULL,
      3.788044,
      NULL,
      0.718802,
      0.410744,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.858173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.012249,
      3.256393,
      1.677365,
      1.938640,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.790804,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.273877,
      3.980140,
      3,
      5.143672,
      7,
      2.638041,
      3.407580,
      2.840699,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1.974465,
      0,
      2,
      6.627688,
      5,
      3,
      0,
      NULL,
      5.794858,
      NULL,
      0,
      3,
      NULL,
      0.985060,
      1.271496,
      1,
      1.624379,
      1.082961,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.003611,
      NULL,
      NULL,
      0.247492,
      NULL,
      NULL,
      0.358831,
      NULL,
      NULL,
      0.106037,
      NULL,
      NULL,
      1,
      1.491872,
      1,
      0.032671,
      1.875960,
      0.224551,
      3.465594,
      NULL,
      NULL,
      5.076059,
      6.779530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.541212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.534669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.746465,
      NULL,
      NULL,
      NULL,
      0.993047,
      NULL,
      NULL,
      1.000992,
      1,
      NULL,
      NULL,
      0.161233,
      1,
      NULL,
      NULL,
      2,
      2.873598,
      NULL,
      NULL,
      0.965044,
      0.746054,
      NULL,
      NULL,
      0.615192,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      1.595291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.593435,
      1,
      NULL,
      NULL,
      NULL,
      0.054934,
      NULL,
      NULL,
      2.292959,
      0,
      1,
      1.586072,
      NULL,
      NULL,
      1.769001,
      NULL,
      NULL,
      0,
      NULL,
      0.854428,
      1.742307,
      0.710098,
      0,
      NULL,
      0.765042,
      1.525783,
      1.535238,
      1,
      0,
      1,
      0.560158,
      0,
      0,
      1.367888,
      0,
      0.980301,
      0,
      0,
      1,
      0.904173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.705857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656663,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427504,
      1.449473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344106,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883234,
      2.021317,
      NULL,
      1,
      NULL,
      1.609799,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.397120,
      NULL,
      NULL,
      0.400559,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.246645,
      NULL,
      3,
      3.607436,
      2.621406,
      5,
      11,
      2.477329,
      0.476280,
      3,
      0,
      1,
      0,
      1.984652,
      0.100372,
      0.667324,
      NULL,
      NULL,
      1.249297,
      0,
      1,
      1.505882,
      0.654683,
      3,
      3,
      3.364784,
      NULL,
      1,
      0.723611,
      0,
      2.722634,
      3,
      1,
      2.947499,
      0.647798,
      0.350821,
      0.646570,
      1.148284,
      NULL,
      0,
      1.125319,
      NULL,
      3,
      3.734054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.100218,
      0,
      0,
      1,
      NULL,
      4,
      8.520299,
      0,
      NULL,
      NULL,
      67.851089,
      34,
      5,
      2.455266,
      NULL,
      NULL,
      '',
      '',
      3.147232,
      '13004',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


