set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '0432221',
      2.691689,
      1,
      2,
      1,
      '1312',
      3.441731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.049601,
      1,
      1,
      ' 3-14-1984',
      18.798718,
      4.245285,
      206.996726,
      16,
      2.604268,
      NULL,
      NULL,
      ' 1-21-1987',
      2.555233,
      1,
      1.943446,
      NULL,
      0,
      1,
      0,
      2.553935,
      NULL,
      NULL,
      NULL,
      2,
      6,
      8.489355,
      1.523258,
      NULL,
      11,
      3,
      1.665878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492490,
      NULL,
      NULL,
      6,
      1.198283,
      0.437883,
      0,
      0.295819,
      2.713421,
      6.162229,
      0.413444,
      0,
      0,
      0.486297,
      1,
      5.395524,
      NULL,
      NULL,
      0.253674,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.166074,
      3.786438,
      NULL,
      0,
      1.402273,
      1,
      NULL,
      1,
      0,
      2.496652,
      2.361252,
      0.736525,
      NULL,
      3.563461,
      1.473970,
      0.686637,
      1,
      2.294531,
      0,
      2.669011,
      3,
      1.713749,
      9.113195,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.978929,
      7.157687,
      2.392796,
      1,
      6,
      NULL,
      7.942543,
      0,
      0,
      0,
      NULL,
      1.691242,
      0,
      4,
      1.876130,
      0,
      0,
      0,
      1.031769,
      NULL,
      NULL,
      2.985635,
      NULL,
      0,
      0,
      0.670525,
      2,
      7,
      0,
      3,
      1.528371,
      0.201131,
      3.237269,
      2.632816,
      3.914905,
      6.505683,
      9,
      2.014097,
      1.992620,
      9.866353,
      8.220470,
      1.418937,
      9,
      2,
      5.770528,
      0,
      1.329926,
      NULL,
      ' 3-26-2002',
      877.208305,
      NULL,
      653.734881,
      1,
      NULL,
      0.930517,
      3.371910,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.969760,
      0.110886,
      2,
      0.049341,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      0.478285,
      NULL,
      NULL,
      NULL,
      3.286838,
      2.415917,
      3,
      5,
      3.849350,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569800,
      NULL,
      1,
      0.421701,
      0,
      0.284141,
      0.418408,
      1.302569,
      31.326677,
      0.280901,
      0,
      NULL,
      NULL,
      NULL,
      1.497115,
      0.897408,
      0,
      2.014659,
      2.478935,
      0.427798,
      NULL,
      1,
      2.638989,
      2.406349,
      2.766996,
      0.752869,
      1.135232,
      1.396773,
      3.810327,
      1,
      2.935205,
      0,
      0,
      NULL,
      NULL,
      1.214250,
      0.544642,
      0.040446,
      NULL,
      0,
      0,
      1.628323,
      NULL,
      NULL,
      1,
      0,
      11.806437,
      0,
      7.543524,
      11,
      3.218890,
      7.232016,
      0.910435,
      1.980400,
      0,
      2,
      2.270575,
      NULL,
      66.265145,
      3.947188,
      3,
      NULL,
      59.361609,
      28.131368,
      18.439924,
      3,
      1,
      2,
      '20104',
      '',
      NULL,
      2.939602,
      '00242',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      8,
      271.184752,
      47.404300,
      0.733626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.450428,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.490002,
      1.603517,
      1,
      1.872513,
      3.448853,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.486785,
      2.477549,
      0,
      0.848987,
      3.687402,
      1.402184,
      NULL,
      NULL,
      7.919624,
      2,
      7,
      1.483462,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310842,
      NULL,
      NULL,
      NULL,
      2,
      0.017632,
      NULL,
      NULL,
      1.342593,
      0.609742,
      0.314085,
      1,
      3.646404,
      NULL,
      1,
      0.161821,
      0.738463,
      0,
      2,
      0,
      0.914208,
      1,
      2,
      2,
      2,
      NULL,
      NULL,
      1.481329,
      2.099636,
      1.476774,
      1.293193,
      2,
      1.887772,
      NULL,
      NULL,
      1.997786,
      NULL,
      NULL,
      NULL,
      2.083050,
      5,
      1.872962,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.157183,
      3.662063,
      NULL,
      1,
      1,
      0.442565,
      NULL,
      NULL,
      5.086831,
      NULL,
      1.422138,
      2,
      1,
      1.470555,
      0.751785,
      NULL,
      NULL,
      1,
      0,
      3.707182,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.558016,
      NULL,
      NULL,
      1.845084,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.212464,
      NULL,
      NULL,
      4,
      3,
      3.935317,
      2.048447,
      5,
      5,
      1,
      NULL,
      NULL,
      0,
      0,
      0.730648,
      1,
      1,
      NULL,
      1,
      2,
      1,
      0.317421,
      2,
      NULL,
      1.992041,
      1.701228,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      NULL,
      9,
      6.531963,
      0.125653,
      0,
      0,
      NULL,
      2,
      0.008911,
      0,
      NULL,
      1.906380,
      0,
      2,
      NULL,
      NULL,
      0.054176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.336951,
      NULL,
      NULL,
      2.565011,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.933266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.791958,
      NULL,
      NULL,
      1.868679,
      0.316506,
      1.537450,
      0.571249,
      0,
      2.841474,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.278633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745473,
      NULL,
      NULL,
      NULL,
      0.303262,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.332423,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.909733,
      NULL,
      NULL,
      NULL,
      3.388229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.514193,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.985359,
      0.590122,
      NULL,
      NULL,
      0.717967,
      NULL,
      NULL,
      1.769085,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.839367,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.126822,
      0.651227,
      0.913277,
      0,
      0.804115,
      1.534275,
      0,
      1.398181,
      0,
      0,
      NULL,
      0.378873,
      0.372217,
      0.570189,
      NULL,
      0.302447,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.297917,
      3,
      4.122005,
      10,
      5,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.558530,
      0.434491,
      0,
      NULL,
      1,
      1.743421,
      NULL,
      2,
      NULL,
      NULL,
      0.553448,
      0,
      NULL,
      1.994947,
      0,
      NULL,
      3.105723,
      1.946474,
      NULL,
      1,
      2.125932,
      NULL,
      0,
      2,
      NULL,
      1.908870,
      0.808420,
      NULL,
      0,
      1.990379,
      NULL,
      1.203306,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424857,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.816634,
      8,
      7,
      3,
      0,
      NULL,
      NULL,
      0.482200,
      3.590656,
      NULL,
      2.006882,
      NULL,
      '12142',
      NULL,
      1.415615,
      '20133',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


