set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9681977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      2.656205,
      3,
      3.876811,
      0.910373,
      1,
      NULL,
      1,
      '042',
      '24431420',
      41.134517,
      3.188242,
      '1023244',
      NULL,
      1,
      0,
      0,
      '3041',
      4.554217,
      1.970607,
      NULL,
      NULL,
      '10- 9-1983',
      34,
      47,
      NULL,
      0.955771,
      0,
      ' 3-25-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      0.446843,
      NULL,
      NULL,
      ' 9- 8-1998',
      2.738454,
      0.337211,
      1.332487,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      12.748632,
      1,
      3,
      1.744859,
      1,
      NULL,
      1.736705,
      0.680684,
      4,
      NULL,
      NULL,
      2,
      4,
      1.837099,
      4,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.923243,
      6.401689,
      3.783963,
      NULL,
      2,
      NULL,
      NULL,
      0.065803,
      0,
      3.466584,
      0.982036,
      NULL,
      1.292295,
      NULL,
      1.190173,
      3.376504,
      NULL,
      0,
      1.247589,
      4,
      NULL,
      9,
      NULL,
      0,
      3.057841,
      1.462358,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.383069,
      1.622258,
      1.949722,
      1,
      0.664009,
      1.053753,
      5,
      0,
      1.333992,
      5.928026,
      0.948558,
      0,
      0.610142,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008091,
      NULL,
      1.608443,
      0.423628,
      1.837873,
      NULL,
      1,
      NULL,
      3.414784,
      1.861337,
      1,
      NULL,
      0,
      0.271521,
      0.645168,
      1.900861,
      NULL,
      NULL,
      2,
      0.848874,
      NULL,
      1.521031,
      2,
      NULL,
      2.063123,
      2,
      NULL,
      0.166092,
      NULL,
      2,
      ' 2-28-1985',
      61,
      ' 4-24-1989',
      39,
      0,
      NULL,
      1.974678,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.646694,
      4,
      1,
      2.681280,
      NULL,
      1.914603,
      3.991787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.094805,
      NULL,
      7,
      1,
      1.044283,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661707,
      NULL,
      3.467014,
      1,
      1,
      1.297309,
      NULL,
      NULL,
      1.247299,
      NULL,
      2.856499,
      3.855405,
      NULL,
      NULL,
      NULL,
      1.367775,
      1.553193,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.218628,
      0,
      0,
      0,
      1,
      1,
      0.969738,
      NULL,
      1,
      1.765840,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044867,
      1,
      5,
      0.060290,
      3.375197,
      4.834997,
      4.094031,
      5,
      1,
      4.544402,
      0.599813,
      7.982468,
      NULL,
      2.960495,
      NULL,
      3.784538,
      0.051783,
      0.117623,
      NULL,
      1.799960,
      1,
      1.400132,
      0,
      1.284232,
      NULL,
      1.850002,
      0,
      1,
      0.154414,
      1.561102,
      1,
      9.717144,
      4.987887,
      0,
      1,
      NULL,
      2.476337,
      4.666844,
      NULL,
      2,
      2,
      2.613694,
      1.911238,
      60.598207,
      2,
      1.436919,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      '20144',
      '20004',
      '14402',
      1,
      '',
      '',
      '',
      1.465777,
      NULL,
      '',
      '',
      3.404416,
      NULL,
      NULL,
      36.007037,
      0.361017,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074059,
      NULL,
      1.694615,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.857284,
      0,
      0.592472,
      1.685854,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.754220,
      0.932585,
      1,
      2.221528,
      1.724464,
      1.263280,
      3,
      1.609906,
      0,
      2.056007,
      0.688113,
      NULL,
      NULL,
      1.365210,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.660770,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      3,
      2,
      0,
      1.912490,
      2,
      1.129502,
      0.356111,
      2.067648,
      NULL,
      0.911773,
      2,
      2,
      2.603275,
      1.655798,
      NULL,
      NULL,
      0,
      0,
      1,
      1.129439,
      0.424967,
      1,
      1.454406,
      5.821620,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.837377,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.761153,
      NULL,
      NULL,
      1.914859,
      NULL,
      NULL,
      0.859821,
      NULL,
      NULL,
      1.325521,
      NULL,
      NULL,
      2,
      0,
      1,
      0.718395,
      NULL,
      NULL,
      2.450700,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.266593,
      NULL,
      NULL,
      1.789392,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.499728,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.526759,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.552438,
      0,
      0.856691,
      0.977859,
      NULL,
      NULL,
      0,
      0.404471,
      NULL,
      1.178004,
      1.934428,
      0,
      3,
      NULL,
      0,
      3,
      0,
      1,
      3,
      1.035033,
      NULL,
      1.995252,
      1,
      0.509417,
      1.080066,
      NULL,
      NULL,
      1.277938,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.091026,
      2.571606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485578,
      NULL,
      NULL,
      1.546360,
      NULL,
      NULL,
      1.920389,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.314546,
      1.941737,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      36.235462,
      NULL,
      NULL,
      NULL,
      2.306638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.685561,
      NULL,
      NULL,
      NULL,
      1.157900,
      NULL,
      NULL,
      0.684933,
      NULL,
      NULL,
      0.852203,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.542364,
      NULL,
      NULL,
      0.472069,
      NULL,
      NULL,
      0.894301,
      NULL,
      0,
      1316,
      NULL,
      1.745583,
      NULL,
      0.158078,
      1.184400,
      0.772480,
      0,
      3,
      1,
      2.223193,
      1.281559,
      3.672698,
      1.377615,
      1.005009,
      0.851424,
      0.481254,
      0,
      3,
      1,
      NULL,
      NULL,
      0.788116,
      NULL,
      NULL,
      NULL,
      2.037948,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.802475,
      NULL,
      1.373174,
      NULL,
      1.697657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.776599,
      NULL,
      NULL,
      NULL,
      1.998866,
      NULL,
      1.396751,
      NULL,
      NULL,
      NULL,
      1.938394,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.603271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.764457,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.589309,
      NULL,
      0,
      NULL,
      1,
      1.977590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882550,
      0.127929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892154,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      68,
      NULL,
      1.621123,
      NULL,
      0.541602,
      NULL,
      NULL,
      NULL,
      0.946943,
      0.719683,
      4.560772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241058,
      NULL,
      2.529911,
      0.159566,
      3.757832,
      2,
      4,
      3.431914,
      4.644122,
      3.776272,
      3,
      0.250374,
      1.283162,
      NULL,
      NULL,
      1,
      0.607493,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.010249,
      NULL,
      1,
      NULL,
      NULL,
      0.606448,
      0,
      NULL,
      1.762716,
      2.510719,
      NULL,
      NULL,
      1.870256,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.999655,
      0,
      NULL,
      2.234563,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      6,
      4,
      0.000115,
      NULL,
      NULL,
      NULL,
      43.310044,
      2,
      5,
      7.218639,
      '22244',
      NULL,
      '34240',
      NULL,
      NULL,
      '',
      '',
      0.944559,
      '',
      '',
      '');
commit;
end;
/


