set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8808376';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.972378,
      3,
      1,
      '0022',
      1,
      1.536475,
      NULL,
      NULL,
      ' 4-20-1990',
      31,
      NULL,
      NULL,
      2.390805,
      1,
      ' 8-19-1981',
      NULL,
      NULL,
      15,
      0,
      1.175932,
      '10-22-1989',
      ' 1- 4-1996',
      ' 9-11-2001',
      1,
      1.913699,
      2.877346,
      0,
      NULL,
      0,
      3,
      1,
      0.250334,
      NULL,
      4.530207,
      2.088049,
      0.196852,
      4,
      NULL,
      0,
      22.694497,
      4.642731,
      2,
      2,
      0.390333,
      1.718247,
      0,
      1,
      NULL,
      1.374510,
      NULL,
      0.078180,
      1.986220,
      1,
      29,
      9,
      NULL,
      6.037031,
      1,
      0.135694,
      1.317240,
      1,
      1.216979,
      0,
      1,
      NULL,
      0.883914,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.941161,
      1.263000,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.180031,
      NULL,
      0.637855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.193520,
      0,
      0,
      1,
      0,
      NULL,
      1.204711,
      1,
      1,
      0,
      0,
      0.978581,
      0.529245,
      NULL,
      1.751813,
      1.683208,
      NULL,
      0.086777,
      1,
      NULL,
      1,
      NULL,
      1.500662,
      0,
      0.185879,
      0,
      0,
      NULL,
      0.913660,
      1,
      1,
      0,
      0.815487,
      1.167342,
      1.401548,
      2.084889,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0.921190,
      0.069307,
      0.389872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.766793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650264,
      1,
      0.948958,
      1,
      0.186605,
      1.510175,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798929,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722037,
      0,
      1,
      1.268209,
      0,
      NULL,
      0.769351,
      NULL,
      NULL,
      NULL,
      1.753013,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271861,
      0,
      1.451040,
      2,
      301,
      0.128280,
      0.263551,
      NULL,
      NULL,
      NULL,
      2.984212,
      1.713288,
      3,
      NULL,
      0,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      2.261481,
      NULL,
      3.943043,
      NULL,
      2,
      0,
      0,
      0.764740,
      NULL,
      1.020735,
      0.601646,
      1,
      NULL,
      0,
      1.111349,
      0.090895,
      0.378544,
      0.520386,
      3.379258,
      4,
      1.069693,
      2.656629,
      10.855740,
      6.621940,
      6,
      11.069732,
      6,
      2.473892,
      3,
      7.769089,
      0,
      3,
      3.212272,
      NULL,
      1.946726,
      2,
      NULL,
      109.239420,
      106.477239,
      45.834012,
      NULL,
      0,
      4.517603,
      '04332',
      '30413',
      '',
      NULL,
      '',
      '',
      '',
      0.527545,
      '',
      '',
      NULL,
      1.979850,
      1.748853,
      8,
      NULL,
      1,
      21.117267,
      5,
      25,
      0.669570,
      1.069547,
      0.659372,
      NULL,
      2.557608,
      1,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.006834,
      0,
      NULL,
      NULL,
      0.839025,
      NULL,
      NULL,
      NULL,
      3.670311,
      1,
      NULL,
      3,
      NULL,
      0.563997,
      3,
      0,
      1,
      3.511675,
      1,
      3,
      2,
      0,
      2,
      0,
      0.938118,
      NULL,
      6,
      3,
      1,
      2,
      3.864960,
      2.957838,
      1.359161,
      0.615641,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008329,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.634197,
      0,
      1,
      7.974181,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.748222,
      NULL,
      1.651307,
      0,
      3,
      0,
      1,
      2.908505,
      NULL,
      0.584559,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      0,
      0.871224,
      3.209666,
      6,
      2.916215,
      NULL,
      0,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.633679,
      NULL,
      NULL,
      1,
      3.660823,
      1.604980,
      NULL,
      4.168017,
      1,
      3,
      2,
      0,
      3.015223,
      0.663724,
      0.697183,
      6,
      1.731225,
      1,
      3,
      0,
      1,
      6,
      7,
      0.422164,
      NULL,
      1.611589,
      0,
      2.369472,
      NULL,
      0.442535,
      2.603272,
      2,
      1.166061,
      7,
      6.199468,
      0,
      0.842181,
      1.139317,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783104,
      NULL,
      NULL,
      2,
      2.178100,
      0,
      3,
      2.374478,
      2.433373,
      NULL,
      7,
      1.696518,
      3.864509,
      0.471226,
      5,
      3.908165,
      1.111634,
      NULL,
      1.045525,
      1.552613,
      1,
      NULL,
      7.316210,
      NULL,
      NULL,
      27.624204,
      NULL,
      NULL,
      0.858882,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.418096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449336,
      NULL,
      NULL,
      1.822907,
      NULL,
      NULL,
      3.908961,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.885173,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      8.572097,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.457983,
      0.927801,
      1.107095,
      3.504487,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022165,
      1.713860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.758561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.969508,
      NULL,
      NULL,
      NULL,
      NULL,
      0.506679,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.467686,
      0.813169,
      NULL,
      NULL,
      1.091673,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.311242,
      0,
      NULL,
      NULL,
      NULL,
      0.522557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482138,
      NULL,
      1,
      0.968504,
      NULL,
      NULL,
      1,
      NULL,
      1.056368,
      1.994638,
      0,
      0,
      1.796554,
      1,
      1.254485,
      NULL,
      0,
      1.410493,
      NULL,
      1.149601,
      1.560358,
      0,
      0.181059,
      1,
      0,
      NULL,
      0,
      0.503654,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.705293,
      NULL,
      1,
      NULL,
      0,
      NULL,
      57,
      NULL,
      2.503733,
      0,
      25.676957,
      1.208452,
      1.790211,
      NULL,
      NULL,
      0.640780,
      NULL,
      1.197934,
      NULL,
      0.202473,
      NULL,
      1.638262,
      NULL,
      1,
      NULL,
      0.703544,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.942772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790737,
      1.155473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.822563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0.483680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.240246,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.276075,
      3.704896,
      3.173828,
      0.863512,
      NULL,
      0.803002,
      5,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      0.048334,
      1.782665,
      NULL,
      0,
      0.272622,
      0.518740,
      0,
      0,
      NULL,
      1.192589,
      1.343425,
      1,
      NULL,
      1,
      0,
      NULL,
      1.455445,
      0.700650,
      1.051433,
      1,
      NULL,
      1.143288,
      0.377792,
      NULL,
      1.233009,
      0,
      3,
      0.080598,
      NULL,
      1,
      NULL,
      1,
      0.224780,
      NULL,
      0.460330,
      2.920064,
      NULL,
      0,
      NULL,
      0.369146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.528810,
      NULL,
      1,
      NULL,
      1.499438,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.916178,
      6,
      0.606585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.219414,
      0.598808,
      0,
      NULL,
      1,
      NULL,
      1.585717,
      1.517451,
      1,
      NULL,
      NULL,
      95.235947,
      134.966805,
      2.242673,
      0,
      1,
      '12314',
      NULL,
      '41432',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


